/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.reveng;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import org.argouml.kernel.Project;
import org.argouml.language.cpp.profile.ProfileCpp;
import org.argouml.language.cpp.reveng.AttributeModeler;
import org.argouml.language.cpp.reveng.CtorModeler;
import org.argouml.language.cpp.reveng.DtorModeler;
import org.argouml.language.cpp.reveng.MemberModeler;
import org.argouml.language.cpp.reveng.Modeler;
import org.argouml.language.cpp.reveng.OperationModeler;
import org.argouml.language.cpp.reveng.TypedefModeler;
import org.argouml.language.cpp.reveng.XtorModeler;
import org.argouml.model.IllegalModelElementConnectionException;
import org.argouml.model.Model;
import org.argouml.profile.Profile;
import org.argouml.profile.ProfileException;

public class ModelerImpl
implements Modeler {
    private Stack contextStack = new Stack();
    private Object contextAccessSpecifier;
    private int memberDeclarationCount;
    private int compoundStatementCount;
    private boolean ignoreableFunctionDefinition;
    private static final Logger LOG = Logger.getLogger(ModelerImpl.class.getName());
    private Collection newElements;
    private ProfileCpp profile;
    private Project project;
    private AttributeModeler attributeModeler;
    private OperationModeler operationModeler;
    private Object model;
    private TypedefModeler typedefModeler;
    private MemberModeler memberModeler;
    private BaseSpecifierModeler baseSpecifierModeler;
    private XtorModeler xtorModeler;

    ModelerImpl(Project p) throws ProfileException {
        this.project = p;
        List projectProfiles = this.project.getProfileConfiguration().getProfiles();
        Profile cppProfile = null;
        for (Profile projectProfile : projectProfiles) {
            if (projectProfile.getDisplayName() == null || !projectProfile.getDisplayName().contains("C++")) continue;
            cppProfile = projectProfile;
            break;
        }
        this.profile = cppProfile != null ? new ProfileCpp(this.project.getUserDefinedModelList(), cppProfile.getProfilePackages().iterator().next()) : new ProfileCpp(this.project.getModels());
    }

    public void beginTranslationUnit() {
        this.newElements = new HashSet();
        this.contextStack.push(this.getModel());
    }

    public void endTranslationUnit() {
    }

    public Collection getNewElements() {
        return this.newElements;
    }

    public void enterNamespaceScope(String nsName) {
        if (!this.ignore()) {
            Object parentNs = this.getCurrentNamespace();
            Object ns = this.findNamespace(nsName, parentNs);
            if (ns == null) {
                ns = Model.getModelManagementFactory().buildPackage(nsName);
                this.newElements.add(ns);
                Model.getCoreHelper().setNamespace(ns, parentNs);
            }
            this.contextStack.push(ns);
        }
    }

    private Object getCurrentNamespace() {
        Object parentNs = null;
        if (this.contextStack.isEmpty()) {
            parentNs = this.getModel();
        } else {
            parentNs = this.contextStack.peek();
            assert (Model.getFacade().isANamespace(parentNs));
        }
        return parentNs;
    }

    private Object findNamespace(String nsName, Object parentNs) {
        Collection nss = Model.getModelManagementHelper().getAllNamespaces(this.getModel());
        Iterator it = nss.iterator();
        Object ns = null;
        while (it.hasNext()) {
            Object tmpNs = it.next();
            if (!nsName.equals(Model.getFacade().getName(tmpNs)) || Model.getFacade().getNamespace(tmpNs) != parentNs) continue;
            ns = tmpNs;
            break;
        }
        return ns;
    }

    private Object getModel() {
        if (this.model != null) {
            return this.model;
        }
        for (Object userModel : this.getProject().getUserDefinedModelList()) {
            if (Model.getModelManagementHelper().isReadOnly(userModel)) continue;
            this.model = userModel;
            return this.model;
        }
        throw new IllegalStateException("An editable user model wasn't found!");
    }

    public void exitNamespaceScope() {
        if (!this.ignore()) {
            Object ns = this.contextStack.pop();
            assert (Model.getFacade().isANamespace(ns)) : "The popped context (\"" + ns + "\") isn't a namespace!";
        }
    }

    public void makeNamespaceAlias(String ns, String alias) {
    }

    public void beginClassDefinition(String oType, String identifier) {
        if (!this.ignore()) {
            Object ns = this.getCurrentNamespace();
            Object cls = ModelerImpl.findClass(identifier, ns);
            if (cls == null) {
                cls = Model.getCoreFactory().buildClass(identifier, ns);
                this.profile.applyCppClassStereotype(cls);
                this.newElements.add(cls);
            }
            this.contextStack.push(cls);
            if ("otClass".equals(oType)) {
                this.contextAccessSpecifier = Model.getVisibilityKind().getPrivate();
            } else if ("otStruct".equals(oType)) {
                this.contextAccessSpecifier = Model.getVisibilityKind().getPublic();
                this.profile.applyClassSpecifierTaggedValue(cls, "struct");
            } else if (!"otUnion".equals(oType)) assert (false) : "Not expecting any other oType than class, struct and union!";
        }
    }

    private static Object findClass(String identifier, Object ns) {
        Collection classes = Model.getCoreHelper().getAllClasses(ns);
        for (Object candidateClass : classes) {
            if (!Model.getFacade().getName(candidateClass).equals(identifier)) continue;
            return candidateClass;
        }
        return null;
    }

    public void endClassDefinition() {
        if (!this.ignore()) {
            Object cls = this.contextStack.pop();
            assert (Model.getFacade().isAClass(cls)) : "The popped context (\"" + Model.getFacade().getName(cls) + "\") isn't a class!";
            this.contextAccessSpecifier = null;
        }
    }

    public void accessSpecifier(String accessSpec) {
        if (!this.ignore()) {
            if ("public".equals(accessSpec)) {
                this.contextAccessSpecifier = Model.getVisibilityKind().getPublic();
            } else if ("protected".equals(accessSpec)) {
                this.contextAccessSpecifier = Model.getVisibilityKind().getProtected();
            } else if ("private".equals(accessSpec)) {
                this.contextAccessSpecifier = Model.getVisibilityKind().getPrivate();
            } else assert (false) : "Unknown C++ access specifier: " + accessSpec;
        }
    }

    public void beginFunctionDeclaration() {
        if (!this.ignore()) {
            this.operationModeler = new OperationModeler(this.contextStack.peek(), this.contextAccessSpecifier, this.getVoid(), false, this.profile);
            this.contextStack.push(this.operationModeler.getOperation());
        }
    }

    private Project getProject() {
        return this.project;
    }

    private Object getVoid() {
        return this.getProject().findType("void");
    }

    public void endFunctionDeclaration() {
        if (!this.ignore()) {
            assert (this.operationModeler != null) : "operationModeler is null.";
            Object oper = this.contextStack.pop();
            assert (Model.getFacade().isAOperation(oper)) : "The popped context (\"" + oper + "\") isn't an operation!";
            this.operationModeler.finish();
            this.operationModeler = null;
        }
    }

    public void declarationSpecifiers(List declSpecs) {
        if (declSpecs.contains("typedef")) {
            assert (this.typedefModeler == null);
            this.typedefModeler = new TypedefModeler(this.contextStack.peek(), this.contextAccessSpecifier, this.profile);
        } else if (Model.getFacade().isAOperation(this.contextStack.peek())) {
            OperationModeler modeler = this.operationModeler != null ? this.operationModeler : this.xtorModeler;
            modeler.declarationSpecifiers(declSpecs);
        }
    }

    public void simpleTypeSpecifier(List sts) {
        if (!this.ignore()) {
            StringBuffer stsString = new StringBuffer();
            Iterator i = sts.iterator();
            while (i.hasNext()) {
                stsString.append(i.next().toString()).append(" ");
            }
            LOG.finer("In simpleTypeSpecifier, stsString = " + stsString);
            Object theType = this.findOrCreateType(stsString.toString().trim());
            if (this.memberModeler != null) {
                this.memberModeler.setType(theType);
            }
            Object contextModelElement = this.contextStack.peek();
            if (Model.getFacade().isAOperation(contextModelElement)) {
                assert (this.operationModeler != null) : "operationModeler is null in the context of operation " + Model.getFacade().getName(contextModelElement) + ".";
                this.operationModeler.setType(theType);
            } else if (!Model.getFacade().isAClass(contextModelElement)) {
                if (Model.getFacade().isAParameter(contextModelElement)) {
                    Model.getCoreHelper().setType(contextModelElement, theType);
                } else if ((Model.getFacade().isAModel(contextModelElement) || Model.getFacade().isANamespace(contextModelElement)) && this.typedefModeler != null) {
                    this.typedefModeler.setType(theType);
                }
            }
        }
    }

    private Object findOrCreateType(String typeName) {
        Object theType = null;
        LinkedList taggedValues = new LinkedList();
        this.processPtrOperators(typeName, taggedValues);
        theType = this.profile.isBuiltIn(typeName) ? this.profile.getBuiltIn(typeName) : this.getProject().findType(typeName.toString(), true);
        return theType;
    }

    private String processPtrOperators(String typeName, List taggedValues) {
        return typeName;
    }

    public void directDeclarator(String id, boolean typedef) {
        if (!this.ignore()) {
            LOG.finer("In directDeclarator: id = \"" + id + "\"; typedef = " + typedef);
            if (typedef) {
                assert (this.typedefModeler != null);
                this.typedefModeler.directDeclarator(id);
                this.typedefModeler = null;
            } else {
                Model.getCoreHelper().setName(this.contextStack.peek(), id);
            }
        }
    }

    public void storageClassSpecifier(String storageClassSpec) {
    }

    public void typeQualifier(String typeQualifier) {
    }

    public void beginFunctionDefinition() {
        if (!this.ignore()) {
            if (this.isMemberDeclaration()) {
                this.beginFunctionDeclaration();
                this.operationModeler.setDefinedInClass();
            } else {
                this.ignoreableFunctionDefinition = true;
            }
        }
    }

    public void endFunctionDefinition() {
        if (!this.ignore()) {
            if (this.isMemberDeclaration()) {
                this.endFunctionDeclaration();
            } else {
                this.ignoreableFunctionDefinition = false;
            }
        }
    }

    private boolean isMemberDeclaration() {
        return this.memberDeclarationCount > 0;
    }

    public void functionDirectDeclarator(String identifier) {
        if (!this.ignore()) {
            assert (Model.getFacade().isAOperation(this.contextStack.peek()));
            Model.getCoreHelper().setName(this.contextStack.peek(), identifier);
        }
    }

    private boolean ignore() {
        return this.compoundStatementCount > 0 || this.ignoreableFunctionDefinition;
    }

    public void beginParameterDeclaration() {
        if (!this.ignore()) {
            Object oper = this.contextStack.peek();
            if (Model.getFacade().isAOperation(oper)) {
                Object param = Model.getCoreFactory().buildParameter(oper, this.getVoid());
                this.contextStack.push(param);
            }
        }
    }

    public void endParameterDeclaration() {
        if (!this.ignore()) {
            Object param = this.contextStack.peek();
            if (Model.getFacade().isAParameter(param)) {
                this.contextStack.pop();
                if (Model.getFacade().getTaggedValueValue(param, "reference").equals("true") || Model.getFacade().getTaggedValueValue(param, "pointer").equals("true")) {
                    Model.getCoreHelper().setKind(param, Model.getDirectionKind().getInOutParameter());
                }
            }
        }
    }

    public void beginInitializer() {
        if (!this.ignore()) {
            Object context = this.contextStack.peek();
            if (Model.getFacade().isAOperation(context)) {
                Model.getCoreHelper().setAbstract(context, true);
            }
        }
    }

    public void endInitializer() {
    }

    public void beginMemberDeclaration() {
        Object owner = this.contextStack.peek();
        this.assertIsAClassifier(owner);
        this.memberModeler = new MemberModeler(owner, this.contextAccessSpecifier, this.profile);
        ++this.memberDeclarationCount;
    }

    void assertIsAClassifier(Object modelElement) {
        assert (Model.getFacade().isAClassifier(modelElement)) : "modelElement must be a Classifier; its name is \"" + Model.getFacade().getName(modelElement) + "\".";
    }

    public void endMemberDeclaration() {
        --this.memberDeclarationCount;
        this.memberModeler.finish();
        this.memberModeler = null;
    }

    public void beginCompoundStatement() {
        ++this.compoundStatementCount;
    }

    public void endCompoundStatement() {
        --this.compoundStatementCount;
    }

    public void beginPtrOperator() {
        if (!this.ignore()) {
            Object ptrTV = Model.getExtensionMechanismsFactory().buildTaggedValue(ProfileCpp.getTagDefinition("dummy"), new String[]{""});
            this.contextStack.push(ptrTV);
        }
    }

    public void endPtrOperator() {
        if (!this.ignore()) {
            Object ptrTV = this.contextStack.pop();
            assert (Model.getFacade().isATaggedValue(ptrTV)) : "A Tagged Value was expected, but, got: \"" + ptrTV + "\".";
            Object meToBeTagged = this.contextStack.peek();
            if (Model.getFacade().isAOperation(meToBeTagged)) {
                List rps = Model.getCoreHelper().getReturnParameters(meToBeTagged);
                assert (rps.size() == 1);
                meToBeTagged = rps.iterator().next();
            }
            Model.getExtensionMechanismsHelper().addTaggedValue(meToBeTagged, ptrTV);
        }
    }

    public void ptrOperator(String ptrSymbol) {
        if (!this.ignore()) {
            if (ptrSymbol.equals("&") || ptrSymbol.equals("*")) {
                Object discardedTV = this.contextStack.pop();
                assert (Model.getFacade().isATaggedValue(discardedTV));
                Object paramOrAttribute = this.contextStack.peek();
                assert (Model.getFacade().isAParameter(paramOrAttribute) || Model.getFacade().isAAttribute(paramOrAttribute) || Model.getFacade().isAOperation(paramOrAttribute));
                String stereoName = null;
                if (Model.getFacade().isAParameter(paramOrAttribute)) {
                    stereoName = "cppParameter";
                } else if (Model.getFacade().isAAttribute(paramOrAttribute)) {
                    stereoName = "cppAttribute";
                } else if (Model.getFacade().isAOperation(paramOrAttribute)) {
                    List rps = Model.getCoreHelper().getReturnParameters(paramOrAttribute);
                    assert (rps.size() == 1);
                    paramOrAttribute = rps.iterator().next();
                    stereoName = "cppParameter";
                } else {
                    LOG.warning("Unexpected reveng context: " + paramOrAttribute);
                    return;
                }
                this.profile.applyStereotype(stereoName, paramOrAttribute);
                String tvName = null;
                if (ptrSymbol.equals("&")) {
                    tvName = "reference";
                } else if (ptrSymbol.equals("*")) {
                    tvName = "pointer";
                }
                this.profile.applyTaggedValue(stereoName, tvName, paramOrAttribute, "true");
                Object tv = Model.getFacade().getTaggedValue(paramOrAttribute, tvName);
                this.contextStack.push(tv);
            } else {
                LOG.warning("unprocessed ptrSymbol: " + ptrSymbol);
            }
        }
    }

    public void ptrToMember(String scopedItem, String star) {
    }

    public void beginBaseSpecifier() {
        if (!this.ignore()) {
            this.baseSpecifierModeler = new BaseSpecifierModeler();
        }
    }

    public void endBaseSpecifier() {
        if (!this.ignore()) {
            this.baseSpecifierModeler.finish();
            this.baseSpecifierModeler = null;
        }
    }

    public void baseSpecifier(String identifier, boolean isVirtual) {
        if (!this.ignore()) {
            this.baseSpecifierModeler.baseSpecifier(identifier, isVirtual);
        }
    }

    private Object findOrCreateGeneralization(Object parent, Object child) {
        Object generalization = Model.getFacade().getGeneralization(child, parent);
        Object stereotype = null;
        if (generalization == null) {
            try {
                generalization = Model.getUmlFactory().buildConnection(Model.getMetaTypes().getGeneralization(), child, null, parent, null, null, null);
            }
            catch (IllegalModelElementConnectionException e) {
                LOG.severe("Exception while creating generalization, " + (Object)((Object)e));
                throw new RuntimeException(e);
            }
        } else {
            Collection stereotypes = Model.getFacade().getStereotypes(generalization);
            for (Object aStereotype : stereotypes) {
                if (!"cppGeneralization".equals(Model.getFacade().getName(aStereotype))) continue;
                stereotype = aStereotype;
            }
        }
        assert (generalization != null);
        if (stereotype == null) {
            stereotype = this.profile.getCppGeneralizationStereotype();
            assert (stereotype != null);
            Model.getCoreHelper().addStereotype(generalization, stereotype);
        }
        return generalization;
    }

    private boolean isXtorIgnorable() {
        return this.contextStack.size() == 0 || Model.getFacade().isAModel(this.contextStack.peek());
    }

    private void beginXtor(XtorModelerCreator modelerCreator) {
        if (!this.ignore()) {
            assert (this.xtorModeler == null);
            boolean ignorable = this.isXtorIgnorable();
            Object owner = this.contextStack.peek();
            this.xtorModeler = modelerCreator.create(owner, this.contextAccessSpecifier, this.getVoid(), ignorable);
            if (!ignorable) {
                this.assertIsAClassifier(owner);
                this.contextStack.push(this.xtorModeler.getOperation());
            }
        }
    }

    public void beginCtorDefinition() {
        this.beginCtor();
        if (!this.ignore()) {
            this.xtorModeler.setDefinedInClass();
        }
    }

    private void beginCtor() {
        XtorModelerCreator modelerCreator = new XtorModelerCreator(){

            public XtorModeler create(Object owner, Object visibility, Object returnType, boolean ignorable) {
                return new CtorModeler(owner, visibility, returnType, ignorable, ModelerImpl.this.profile);
            }
        };
        this.beginXtor(modelerCreator);
    }

    public void beginDtorHead() {
        XtorModelerCreator modelerCreator = new XtorModelerCreator(){

            public XtorModeler create(Object owner, Object visibility, Object returnType, boolean ignorable) {
                return new DtorModeler(owner, visibility, returnType, ignorable, ModelerImpl.this.profile);
            }
        };
        this.beginXtor(modelerCreator);
    }

    public void endCtorDefinition() {
        this.endXtor();
    }

    private void endXtor() {
        if (!this.ignore()) {
            if (!this.xtorModeler.isIgnorable()) {
                Object poppedXtor = this.contextStack.pop();
                assert (this.xtorModeler.isTheXtor(poppedXtor));
            }
            this.xtorModeler.finish();
            this.xtorModeler = null;
        }
    }

    public void qualifiedCtorId(String identifier) {
        if (!this.ignore()) {
            boolean onlyDeclaration = false;
            if (this.xtorModeler == null) {
                this.beginCtor();
                onlyDeclaration = true;
            }
            this.xtorModeler.setName(identifier);
            if (!this.xtorModeler.isIgnorable()) assert (this.xtorModeler.isTheXtor(this.contextStack.peek()));
            if (onlyDeclaration) {
                this.endXtor();
            }
        }
    }

    public void endDtorHead() {
        this.endXtor();
    }

    public void dtorDeclarator(String qualifiedId) {
        if (!this.xtorModeler.isIgnorable()) assert (this.xtorModeler.isTheXtor(this.contextStack.peek()));
        this.xtorModeler.setName(qualifiedId);
    }

    public void beginMemberDeclarator() {
        Object theType = this.memberModeler.getType();
        this.attributeModeler = new AttributeModeler(this.contextStack.peek(), this.contextAccessSpecifier, theType, this.profile);
        this.contextStack.push(this.attributeModeler.getAttribute());
    }

    public void endMemberDeclarator() {
        if (Model.getFacade().isAAttribute(this.contextStack.peek())) {
            this.attributeModeler.finish();
            assert (this.attributeModeler.getAttribute() == this.contextStack.peek());
            this.contextStack.pop();
        }
    }

    public void beginMemberDeclaratorList() {
    }

    public void endMemberDeclaratorList() {
    }

    private static interface XtorModelerCreator {
        public XtorModeler create(Object var1, Object var2, Object var3, boolean var4);
    }

    private class BaseSpecifierModeler {
        private Object previousAccessSpecifier;
        private Object generalization;

        BaseSpecifierModeler() {
            this.previousAccessSpecifier = ModelerImpl.this.contextAccessSpecifier;
            ModelerImpl.this.contextAccessSpecifier = null;
        }

        void baseSpecifier(String identifier, boolean isVirtual) {
            Object parent = ModelerImpl.this.findOrCreateType(identifier);
            this.generalization = ModelerImpl.this.findOrCreateGeneralization(parent, ModelerImpl.this.contextStack.peek());
            ModelerImpl.this.profile.applyVirtualInheritanceTaggedValue(this.generalization, Boolean.toString(isVirtual));
        }

        void finish() {
            if (ModelerImpl.this.contextAccessSpecifier == null) {
                ModelerImpl.this.contextAccessSpecifier = Model.getVisibilityKind().getPrivate();
            }
            ModelerImpl.this.profile.applyInheritanceVisibilityTaggedValue2Generalization(this.generalization, Model.getFacade().getName(ModelerImpl.this.contextAccessSpecifier));
            ModelerImpl.this.contextAccessSpecifier = this.previousAccessSpecifier;
        }
    }
}

