/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.argouml.application.api.GUISettingsTabInterface;
import org.argouml.i18n.Translator;
import org.argouml.language.cpp.generator.GeneratorCpp;
import org.argouml.language.cpp.generator.Inline;
import org.argouml.moduleloader.ModuleInterface;
import org.argouml.ui.GUI;

public class SettingsTabCpp
implements ModuleInterface,
GUISettingsTabInterface {
    private static final String REVISION_DATE = "$Date: 2013-02-13 12:33:49 +0100 (Wed, 13 Feb 2013) $";
    private static final Logger LOG = Logger.getLogger(SettingsTabCpp.class.getName());
    private JPanel topPanel;
    private JSpinner indent;
    private JCheckBox verboseDocs;
    private JCheckBox lfBeforeCurly;
    private JComboBox useSect;
    private JCheckBox headerGuardUpperCase;
    private JCheckBox headerGuardGUID;
    private JComboBox defaultInline;

    private JPanel buildPanel() {
        LOG.finer("SettingsTabCpp being created...");
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridy = -1;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 30, 0, 5);
        JLabel label = new JLabel(Translator.localize((String)"cpp.indent"));
        Integer spinVal = 4;
        Integer spinMin = 0;
        Integer spinStep = 1;
        this.indent = new JSpinner(new SpinnerNumberModel(spinVal, spinMin, null, spinStep));
        label.setLabelFor(this.indent);
        JPanel indentPanel = new JPanel();
        indentPanel.setLayout(new BoxLayout(indentPanel, 2));
        indentPanel.add(label);
        indentPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        indentPanel.add(this.indent);
        indentPanel.add(Box.createHorizontalGlue());
        panel.add((Component)indentPanel, constraints);
        this.verboseDocs = new JCheckBox(Translator.localize((String)"cpp.verbose-docs"));
        panel.add((Component)this.verboseDocs, constraints);
        this.lfBeforeCurly = new JCheckBox(Translator.localize((String)"cpp.lf-before-curly"));
        panel.add((Component)this.lfBeforeCurly, constraints);
        String[] sectOpts = new String[]{Translator.localize((String)"cpp.sections.none"), Translator.localize((String)"cpp.sections.normal"), Translator.localize((String)"cpp.sections.brief")};
        this.useSect = new JComboBox<String>(sectOpts);
        label = new JLabel(Translator.localize((String)"cpp.sections"));
        label.setLabelFor(this.useSect);
        JPanel sectPanel = new JPanel(new FlowLayout(0, 5, 0));
        sectPanel.add(label);
        sectPanel.add(this.useSect);
        panel.add((Component)sectPanel, constraints);
        this.headerGuardUpperCase = new JCheckBox(Translator.localize((String)"cpp.header-guard-case"));
        panel.add((Component)this.headerGuardUpperCase, constraints);
        this.headerGuardGUID = new JCheckBox(Translator.localize((String)"cpp.header-guard-guid"));
        panel.add((Component)this.headerGuardGUID, constraints);
        String[] inlineOpts = Inline.getStyleLabels();
        for (int i = 0; i < inlineOpts.length; ++i) {
            inlineOpts[i] = Translator.localize((String)inlineOpts[i]);
        }
        this.defaultInline = new JComboBox<String>(inlineOpts);
        label = new JLabel(Translator.localize((String)"cpp.default-inline"));
        label.setLabelFor(this.defaultInline);
        panel.add((Component)label, constraints);
        panel.add((Component)this.defaultInline, constraints);
        top.add((Component)panel, "North");
        LOG.finer("SettingsTabCpp created!");
        return top;
    }

    public void handleSettingsTabSave() {
        GeneratorCpp cpp = GeneratorCpp.getInstance();
        int indWidth = (Integer)this.indent.getValue();
        cpp.setIndent(indWidth);
        cpp.setLfBeforeCurly(this.lfBeforeCurly.isSelected());
        cpp.setVerboseDocs(this.verboseDocs.isSelected());
        cpp.setUseSect(this.useSect.getSelectedIndex());
        cpp.setHeaderGuardUpperCase(this.headerGuardUpperCase.isSelected());
        cpp.setHeaderGuardGUID(this.headerGuardGUID.isSelected());
        cpp.setDefaultInlineStyle(this.defaultInline.getSelectedIndex());
    }

    public void handleSettingsTabCancel() {
    }

    public void handleSettingsTabRefresh() {
        GeneratorCpp cpp = GeneratorCpp.getInstance();
        this.lfBeforeCurly.setSelected(cpp.isLfBeforeCurly());
        this.verboseDocs.setSelected(cpp.isVerboseDocs());
        this.indent.setValue(cpp.getIndent());
        this.useSect.setSelectedIndex(cpp.getUseSect());
        this.headerGuardUpperCase.setSelected(cpp.isHeaderGuardUpperCase());
        this.headerGuardGUID.setSelected(cpp.isHeaderGuardGUID());
        this.defaultInline.setSelectedIndex(cpp.getDefaultInlineStyle());
    }

    public void handleResetToDefault() {
    }

    public String getTabKey() {
        return "cpp.tabname";
    }

    public JPanel getTabPanel() {
        if (this.topPanel == null) {
            this.topPanel = this.buildPanel();
        }
        return this.topPanel;
    }

    public String getName() {
        return "SettingsTabCpp";
    }

    public String getInfo(int type) {
        switch (type) {
            case 1: {
                return "Daniele Tamino";
            }
            case 0: {
                return "C++ Settings";
            }
            case 2: {
                return "Revision date: $Date: 2013-02-13 12:33:49 +0100 (Wed, 13 Feb 2013) $";
            }
            case 3: {
                return "http://argouml-downloads.tigris.org/";
            }
        }
        return null;
    }

    public boolean enable() {
        GUI.getInstance().addSettingsTab((GUISettingsTabInterface)this);
        return true;
    }

    public boolean disable() {
        return false;
    }
}

