/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.uml.reveng.idl;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.argouml.kernel.Project;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.FileImportUtils;
import org.argouml.uml.reveng.ImportInterface;
import org.argouml.uml.reveng.ImportSettings;
import org.argouml.uml.reveng.ImporterManager;
import org.argouml.uml.reveng.SettingsTypes;
import org.argouml.uml.reveng.idl.IDLLexer;
import org.argouml.uml.reveng.idl.IDLParser;
import org.argouml.uml.reveng.idl.Modeler;
import org.argouml.util.SuffixFilter;

public class IDLFileImport
implements ImportInterface {
    private Project currentProject = null;

    public Collection parseFiles(Project p, Collection files, ImportSettings settings, ProgressMonitor monitor) throws ImportInterface.ImportException {
        this.currentProject = p;
        HashSet newElements = new HashSet();
        monitor.setMaximumProgress(files.size());
        int count = 1;
        for (File file : files) {
            String fileName = file.getName();
            try {
                newElements.addAll(this.parseFile(new FileInputStream(file), fileName));
            }
            catch (FileNotFoundException e) {
                throw new ImportInterface.ImportException("File not found: " + fileName, (Throwable)e);
            }
            monitor.updateProgress(count++);
        }
        return newElements;
    }

    public Collection parseFile(InputStream is, String fileName) throws ImportInterface.ImportException {
        int lastSlash = fileName.lastIndexOf(47);
        if (lastSlash != -1) {
            fileName = fileName.substring(lastSlash + 1);
        }
        IDLParser parser = new IDLParser(new IDLLexer(new BufferedInputStream(is)));
        Modeler modeller = new Modeler(this.currentProject.getModel(), fileName);
        try {
            parser.specification(modeller);
        }
        catch (RecognitionException e) {
            throw new ImportInterface.ImportException("File: " + fileName, (Throwable)e);
        }
        catch (TokenStreamException e) {
            throw new ImportInterface.ImportException("File: " + fileName, (Throwable)e);
        }
        return modeller.getNewElements();
    }

    public boolean enable() {
        ImporterManager.getInstance().addImporter((ImportInterface)this);
        return true;
    }

    public boolean disable() {
        return true;
    }

    public String getName() {
        return "IDL";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "Java import from IDL files";
            }
            case 1: {
                return "Andreas Rueckert";
            }
            case 2: {
                return "0.2 - $Id: IDLFileImport.java 231 2010-01-12 18:36:00Z linus $";
            }
        }
        return null;
    }

    public SuffixFilter[] getSuffixFilters() {
        SuffixFilter[] result = new SuffixFilter[]{new SuffixFilter("idl", "Interface Definition Language file")};
        return result;
    }

    public boolean isParseable(File file) {
        return FileImportUtils.matchesSuffix((Object)file, (SuffixFilter[])this.getSuffixFilters());
    }

    public List<SettingsTypes.Setting> getImportSettings() {
        return null;
    }
}

