/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import org.openide.ErrorManager;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.TimedSoftReference;

public class NbBundle {
    private static final boolean USE_DEBUG_LOADER = Boolean.getBoolean("org.openide.util.NbBundle.DEBUG");
    private static String brandingToken = null;
    private static final Map localizedFileCache = new WeakHashMap();
    private static final Map bundleCache = new WeakHashMap();
    static /* synthetic */ Class class$org$openide$util$NbBundle;

    public static String getBranding() {
        return brandingToken;
    }

    public static void setBranding(String string) throws IllegalArgumentException {
        brandingToken = string;
    }

    public static synchronized URL getLocalizedFile(String string, String string2) throws MissingResourceException {
        return NbBundle.getLocalizedFile(string, string2, Locale.getDefault(), NbBundle.getLoader());
    }

    public static synchronized URL getLocalizedFile(String string, String string2, Locale locale) throws MissingResourceException {
        return NbBundle.getLocalizedFile(string, string2, locale, NbBundle.getLoader());
    }

    public static synchronized URL getLocalizedFile(String string, String string2, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        URL uRL = null;
        Iterator iterator = new LocaleIterator(locale);
        String string3 = "[" + Integer.toString(classLoader.hashCode()) + "]";
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string4 = string.replace('.', '/');
        HashMap hashMap = (HashMap)localizedFileCache.get(classLoader);
        if (hashMap == null) {
            hashMap = new HashMap();
            localizedFileCache.put(classLoader, hashMap);
        }
        String string5 = string2 != null ? string4 + '.' + string2 : string4;
        uRL = (URL)hashMap.get(string5);
        URL uRL2 = uRL == null ? classLoader.getResource(string5) : null;
        while (iterator.hasNext()) {
            String string6 = (String)iterator.next();
            string5 = string2 != null ? string4 + string6 + '.' + string2 : string4 + string6;
            uRL = (URL)hashMap.get(string5);
            if (uRL != null) break;
            arrayList.add(string5);
            uRL = string6.length() == 0 ? uRL2 : classLoader.getResource(string5);
            if (uRL == null) continue;
        }
        if (uRL == null) {
            string5 = string.replace('.', '/');
            if (string2 != null) {
                string5 = string5 + '.' + string2;
            }
            throw new MissingResourceException("Cannot find localized resource " + string5 + " in " + classLoader, classLoader.toString(), string5);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), uRL);
        }
        return uRL;
    }

    public static Object getLocalizedValue(Map map, String string, Locale locale) {
        if (map instanceof Attributes) {
            throw new IllegalArgumentException("Please do not use a java.util.jar.Attributes for NbBundle.getLocalizedValue without using the special form that works properly with Attributes.Name's as keys.");
        }
        LocaleIterator localeIterator = new LocaleIterator(locale);
        while (localeIterator.hasNext()) {
            String string2 = string + (String)localeIterator.next();
            Object v = map.get(string2);
            if (v == null) continue;
            if (USE_DEBUG_LOADER && v instanceof String) {
                return (String)v + " (?:" + string2 + ")";
            }
            return v;
        }
        return null;
    }

    public static Object getLocalizedValue(Map map, String string) {
        return NbBundle.getLocalizedValue(map, string, Locale.getDefault());
    }

    public static String getLocalizedValue(Attributes attributes, Attributes.Name name, Locale locale) {
        return (String)NbBundle.getLocalizedValue(NbBundle.attr2Map(attributes), name.toString().toLowerCase(Locale.US), locale);
    }

    public static String getLocalizedValue(Attributes attributes, Attributes.Name name) {
        return (String)NbBundle.getLocalizedValue(NbBundle.attr2Map(attributes), name.toString().toLowerCase(Locale.US));
    }

    private static Map attr2Map(Attributes attributes) {
        return new AttributesMap(attributes);
    }

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return NbBundle.getBundle(string, Locale.getDefault(), NbBundle.getLoader());
    }

    public static ResourceBundle getBundle(Class clazz) throws MissingResourceException {
        String string = NbBundle.findName(clazz);
        return NbBundle.getBundle(string, Locale.getDefault(), clazz.getClassLoader());
    }

    private static String findName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n + 1);
            return string + "Bundle";
        }
        return "Bundle";
    }

    public static final ResourceBundle getBundle(String string, Locale locale) throws MissingResourceException {
        return NbBundle.getBundle(string, locale, NbBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle resourceBundle;
        if (USE_DEBUG_LOADER) {
            classLoader = DebugLoader.get(classLoader);
        }
        if ((resourceBundle = NbBundle.getBundleFast(string, locale, classLoader)) != null) {
            return resourceBundle;
        }
        MissingResourceException missingResourceException = new MissingResourceException("No such bundle " + string, string, null);
        if (Lookup.getDefault().lookup(ClassLoader.class) == null) {
            ErrorManager.getDefault().annotate(missingResourceException, 0, "Class loader not yet initialized in lookup", null, null, null);
        } else {
            ErrorManager.getDefault().annotate(missingResourceException, 0, "Offending classloader: " + classLoader, null, null, null);
        }
        throw missingResourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getBundleFast(String string, Locale locale, ClassLoader classLoader) {
        HashMap<String, TimedSoftReference> hashMap;
        Object object = bundleCache;
        synchronized (object) {
            hashMap = (HashMap<String, TimedSoftReference>)bundleCache.get(classLoader);
            if (hashMap == null) {
                hashMap = new HashMap<String, TimedSoftReference>();
                bundleCache.put(classLoader, hashMap);
            }
        }
        object = locale.toString();
        char[] cArray = new char[string.length() + (brandingToken != null ? brandingToken.length() : 1) + 2 + ((String)object).length()];
        string.getChars(0, string.length(), cArray, 0);
        cArray[string.length()] = 47;
        int n = string.length() + 1;
        if (brandingToken == null) {
            cArray[n] = 45;
            ++n;
        } else {
            brandingToken.getChars(0, brandingToken.length(), cArray, n);
            n += brandingToken.length();
        }
        cArray[n] = 47;
        ((String)object).getChars(0, ((String)object).length(), cArray, ++n);
        String string2 = new String(cArray);
        HashMap<String, TimedSoftReference> hashMap2 = hashMap;
        synchronized (hashMap2) {
            ResourceBundle resourceBundle;
            Object v = hashMap.get(string2);
            ResourceBundle resourceBundle2 = resourceBundle = v != null ? (ResourceBundle)((Reference)v).get() : null;
            if (resourceBundle != null) {
                return resourceBundle;
            }
            resourceBundle = NbBundle.loadBundle(string, locale, classLoader);
            if (resourceBundle != null) {
                hashMap.put(string2, new TimedSoftReference(resourceBundle, hashMap, string2));
            }
            return resourceBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle loadBundle(String string, Locale locale, ClassLoader classLoader) {
        String string2 = string.replace('.', '/');
        Iterator iterator = new LocaleIterator(locale);
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            linkedList.addFirst(iterator.next());
        }
        iterator = linkedList.iterator();
        Properties properties = new Properties();
        boolean bl = true;
        while (iterator.hasNext()) {
            block9: {
                String string3 = string2 + (String)iterator.next() + ".properties";
                URL uRL = classLoader.getResource(string3);
                if (uRL != null) {
                    try {
                        InputStream inputStream = USE_DEBUG_LOADER ? classLoader.getResourceAsStream(string3) : uRL.openStream();
                        try {
                            properties.load(inputStream);
                            break block9;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().annotate(iOException, 0, "While loading: " + string3, null, null, null);
                        ErrorManager.getDefault().notify(16, iOException);
                        return null;
                    }
                }
                if (bl) {
                    return NbBundle.loadBundleClass(string, string2, locale, linkedList, classLoader);
                }
            }
            bl = false;
        }
        return new PBundle(properties, locale);
    }

    private static ResourceBundle loadBundleClass(String string, String string2, Locale locale, List list, ClassLoader classLoader) {
        if (classLoader.getResource(string2 + ".class") == null) {
            return null;
        }
        ResourceBundle resourceBundle = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Class<?> clazz = Class.forName(string + (String)iterator.next(), true, classLoader);
                ResourceBundle resourceBundle2 = (ResourceBundle)clazz.newInstance();
                if (resourceBundle == null) {
                    resourceBundle = resourceBundle2;
                    continue;
                }
                resourceBundle = new MergedBundle(locale, resourceBundle2, resourceBundle);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, exception);
            }
            catch (LinkageError linkageError) {
                ErrorManager.getDefault().notify(16, linkageError);
            }
        }
        return resourceBundle;
    }

    public static String getMessage(Class clazz, String string) throws MissingResourceException {
        return NbBundle.getBundle(clazz).getString(string);
    }

    public static String getMessage(Class clazz, String string, Object object) throws MissingResourceException {
        return NbBundle.getMessage(clazz, string, new Object[]{object});
    }

    public static String getMessage(Class clazz, String string, Object object, Object object2) throws MissingResourceException {
        return NbBundle.getMessage(clazz, string, new Object[]{object, object2});
    }

    public static String getMessage(Class clazz, String string, Object object, Object object2, Object object3) throws MissingResourceException {
        return NbBundle.getMessage(clazz, string, new Object[]{object, object2, object3});
    }

    public static String getMessage(Class clazz, String string, Object[] objectArray) throws MissingResourceException {
        return MessageFormat.format(NbBundle.getMessage(clazz, string), objectArray);
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
    }

    public static Iterator getLocalizingSuffixes() {
        return new LocaleIterator(Locale.getDefault());
    }

    public static void setClassLoaderFinder(ClassLoaderFinder classLoaderFinder) {
        throw new Error();
    }

    private static final class DebugLoader
    extends ClassLoader {
        private static int count = 0;
        private static final Map knownIDs = new HashMap();
        private static final Map existing = new WeakHashMap();

        private DebugLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getID(String string) {
            Map map = knownIDs;
            synchronized (map) {
                Integer n = (Integer)knownIDs.get(string);
                if (n == null) {
                    n = new Integer(++count);
                    knownIDs.put(string, n);
                    System.err.println("NbBundle trace: #" + n + " = " + string);
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ClassLoader get(ClassLoader classLoader) {
            Map map = existing;
            synchronized (map) {
                ClassLoader classLoader2;
                Reference reference = (Reference)existing.get(classLoader);
                if (reference != null && (classLoader2 = (ClassLoader)reference.get()) != null) {
                    return classLoader2;
                }
                classLoader2 = new DebugLoader(classLoader);
                existing.put(classLoader, new WeakReference<ClassLoader>(classLoader2));
                return classLoader2;
            }
        }

        public InputStream getResourceAsStream(String string) {
            InputStream inputStream = super.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            if (string.endsWith(".properties")) {
                int n = DebugLoader.getID(string);
                boolean bl = string.indexOf("/Bundle.") != -1 || string.indexOf("/Bundle_") != -1;
                return new DebugInputStream(inputStream, n, bl);
            }
            return inputStream;
        }

        private static final class DebugInputStream
        extends InputStream {
            private static final int WAITING_FOR_KEY = 0;
            private static final int IN_COMMENT = 1;
            private static final int IN_KEY = 2;
            private static final int IN_KEY_BACKSLASH = 3;
            private static final int AFTER_KEY = 4;
            private static final int WAITING_FOR_VALUE = 5;
            private static final int IN_VALUE = 6;
            private static final int IN_VALUE_BACKSLASH = 7;
            private final InputStream base;
            private final int id;
            private final boolean localizable;
            private int line = 0;
            private int state = 0;
            private boolean twixtCrAndNl = false;
            private String toInsert = null;
            private boolean reverseLocalizable = false;
            private StringBuffer lastComment = null;

            public DebugInputStream(InputStream inputStream, int n, boolean bl) {
                this.base = inputStream;
                this.id = n;
                this.localizable = bl;
            }

            public int read() throws IOException {
                if (this.toInsert != null) {
                    char c = this.toInsert.charAt(0);
                    this.toInsert = this.toInsert.length() > 1 ? this.toInsert.substring(1) : null;
                    return c;
                }
                int n = this.base.read();
                if (n == 10) {
                    this.twixtCrAndNl = false;
                    ++this.line;
                } else if (n == 13) {
                    if (this.twixtCrAndNl) {
                        ++this.line;
                    } else {
                        this.twixtCrAndNl = true;
                    }
                } else {
                    this.twixtCrAndNl = false;
                }
                switch (this.state) {
                    case 0: {
                        switch (n) {
                            case 33: 
                            case 35: {
                                this.state = 1;
                                this.lastComment = new StringBuffer();
                                this.lastComment.append((char)n);
                                return n;
                            }
                            case -1: 
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                return n;
                            }
                            case 92: {
                                this.state = 3;
                                return n;
                            }
                        }
                        this.state = 2;
                        return n;
                    }
                    case 1: {
                        switch (n) {
                            case 10: 
                            case 13: {
                                String string = this.lastComment.toString();
                                this.lastComment = null;
                                if (this.localizable && string.equals("#NOI18N")) {
                                    this.reverseLocalizable = true;
                                } else if (this.localizable && string.equals("#PARTNOI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTNOI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && string.equals("#I18N")) {
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && string.equals("#PARTI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = false;
                                } else if (this.localizable && (string.equals("#I18N") || string.equals("#PARTI18N")) || !this.localizable && (string.equals("#NOI18N") || string.equals("#PARTNOI18N"))) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): incongruous comment " + string + " found for bundle");
                                    this.reverseLocalizable = false;
                                }
                                this.state = 0;
                                return n;
                            }
                        }
                        this.lastComment.append((char)n);
                        return n;
                    }
                    case 2: {
                        switch (n) {
                            case 92: {
                                this.state = 3;
                                return n;
                            }
                            case 9: 
                            case 32: {
                                this.state = 4;
                                return n;
                            }
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                        }
                        return n;
                    }
                    case 3: {
                        this.state = 2;
                        return n;
                    }
                    case 4: {
                        switch (n) {
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                        }
                        return n;
                    }
                    case 5: {
                        switch (n) {
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                            case 9: 
                            case 32: {
                                return n;
                            }
                            case 92: {
                                this.state = 7;
                                return n;
                            }
                        }
                        this.state = 6;
                        return n;
                    }
                    case 6: {
                        switch (n) {
                            case 92: {
                                this.state = 7;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                boolean bl = this.reverseLocalizable;
                                this.reverseLocalizable = false;
                                this.state = 0;
                                if (this.localizable ^ bl) {
                                    this.toInsert = "(" + this.id + ":" + this.line + ")" + new Character((char)n);
                                    return 32;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 7: {
                        this.state = 6;
                        return n;
                    }
                }
                throw new IOException("should never happen");
            }

            public static void main(String[] stringArray) throws Exception {
                int n;
                if (stringArray.length != 1) {
                    throw new Exception();
                }
                boolean bl = Boolean.valueOf(stringArray[0]);
                DebugInputStream debugInputStream = new DebugInputStream(System.in, 123, bl);
                while ((n = debugInputStream.read()) != -1) {
                    System.out.write(n);
                }
            }
        }
    }

    private static class LocaleIterator
    implements Iterator {
        private boolean defaultInProgress = false;
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = brandingToken == null ? null : "_" + brandingToken;
        }

        public Object next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String string = this.branding == null ? this.current : this.branding + this.current;
            int n = this.current.lastIndexOf(95);
            if (n == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (n == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, n);
            }
            return string;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int n = this.branding.lastIndexOf(95);
                this.branding = n == 0 ? null : this.branding.substring(0, n);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MergedBundle
    extends ResourceBundle {
        private Locale loc;
        private ResourceBundle sub1;
        private ResourceBundle sub2;

        public MergedBundle(Locale locale, ResourceBundle resourceBundle, ResourceBundle resourceBundle2) {
            this.loc = locale;
            this.sub1 = resourceBundle;
            this.sub2 = resourceBundle2;
        }

        public Locale getLocale() {
            return this.loc;
        }

        public Enumeration getKeys() {
            return Enumerations.removeDuplicates(Enumerations.concat(this.sub1.getKeys(), this.sub2.getKeys()));
        }

        protected Object handleGetObject(String string) throws MissingResourceException {
            try {
                return this.sub1.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                return this.sub2.getObject(string);
            }
        }
    }

    private static final class PBundle
    extends ResourceBundle {
        private final Map m;
        private final Locale locale;

        public PBundle(Map map, Locale locale) {
            this.m = map;
            this.locale = locale;
        }

        public Enumeration getKeys() {
            return Collections.enumeration(this.m.keySet());
        }

        protected Object handleGetObject(String string) {
            return this.m.get(string);
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    private static class AttributesMap
    extends HashMap {
        private Attributes attrs;

        public AttributesMap(Attributes attributes) {
            super(7);
            this.attrs = attributes;
        }

        public Object get(Object object) {
            Attributes.Name name;
            try {
                name = new Attributes.Name((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate(illegalArgumentException, 16, (String)object, NbBundle.getMessage(class$org$openide$util$NbBundle == null ? (class$org$openide$util$NbBundle = NbBundle.class$("org.openide.util.NbBundle")) : class$org$openide$util$NbBundle, "EXC_bad_attributes_name", object, Locale.getDefault().toString()), null, null);
                errorManager.notify(illegalArgumentException);
                return null;
            }
            return this.attrs.getValue(name);
        }
    }

    public static interface ClassLoaderFinder {
        public ClassLoader find();
    }
}

