/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap results;
    static /* synthetic */ Class class$org$openide$util$LookupListener;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup lookup = this.provider.getLookup();
        Iterator<Object> iterator = null;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (lookup != this.delegate) {
                this.delegate = lookup;
                if (this.results != null) {
                    iterator = Arrays.asList(this.results.values().toArray()).iterator();
                }
            }
        }
        if (iterator != null) {
            simpleProxyLookup = iterator;
            while (simpleProxyLookup.hasNext()) {
                Reference reference = (Reference)simpleProxyLookup.next();
                ProxyResult proxyResult = (ProxyResult)reference.get();
                if (proxyResult == null || !proxyResult.updateLookup(lookup)) continue;
                proxyResult.resultChanged(null);
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result lookup(Lookup.Template template) {
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            Object object;
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult proxyResult;
                object = (Reference)this.results.get(template);
                if (object != null && (proxyResult = (ProxyResult)((Reference)object).get()) != null) {
                    return proxyResult;
                }
            }
            object = new ProxyResult(template);
            this.results.put(template, new WeakReference<Object>(object));
            return object;
        }
    }

    public Object lookup(Class clazz) {
        return this.checkLookup().lookup(clazz);
    }

    public Lookup.Item lookupItem(Lookup.Template template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class ProxyResult
    extends WaitableResult
    implements LookupListener {
        private Lookup.Template template;
        private Lookup.Result delegate;
        private EventListenerList listeners;
        private LookupListener lastListener;

        ProxyResult(Lookup.Template template) {
            this.template = template;
        }

        private Lookup.Result checkResult() {
            this.updateLookup(SimpleProxyLookup.this.checkLookup());
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup lookup) {
            LookupListener lookupListener;
            List list = this.delegate != null ? this.delegate.allItems() : null;
            Lookup.Result result = this;
            synchronized (result) {
                if (this.delegate != null && this.lastListener != null) {
                    lookupListener = this.lastListener;
                    this.delegate.removeLookupListener(this.lastListener);
                } else {
                    lookupListener = null;
                }
            }
            result = lookup.lookup(this.template);
            ArrayList arrayList = this;
            synchronized (arrayList) {
                if (lookupListener == this.lastListener) {
                    this.delegate = result;
                    this.lastListener = (LookupListener)WeakListeners.create(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = SimpleProxyLookup.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, this, this.delegate);
                    this.delegate.addLookupListener(this.lastListener);
                }
            }
            if (list == null) {
                return false;
            }
            arrayList = this.delegate.allItems();
            if (!(list instanceof List)) {
                list = list == Collections.EMPTY_SET ? Collections.EMPTY_LIST : new ArrayList(list);
            }
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            return !((Object)list).equals(arrayList);
        }

        public synchronized void addLookupListener(LookupListener lookupListener) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = SimpleProxyLookup.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, lookupListener);
        }

        public synchronized void removeLookupListener(LookupListener lookupListener) {
            if (this.listeners != null) {
                this.listeners.remove(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = SimpleProxyLookup.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, lookupListener);
            }
        }

        public Collection allInstances() {
            return this.checkResult().allInstances();
        }

        public Set allClasses() {
            return this.checkResult().allClasses();
        }

        public Collection allItems() {
            return this.checkResult().allItems();
        }

        protected void beforeLookup(Lookup.Template template) {
            Lookup.Result result = this.checkResult();
            if (result instanceof WaitableResult) {
                ((WaitableResult)result).beforeLookup(template);
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            EventListenerList eventListenerList = this.listeners;
            if (eventListenerList == null) {
                return;
            }
            Object[] objectArray = eventListenerList.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            LookupEvent lookupEvent2 = new LookupEvent(this);
            AbstractLookup.notifyListeners(objectArray, lookupEvent2);
        }
    }
}

