/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class ReorderAction
extends UndoableAction {
    private static final long serialVersionUID = -2190865994915716779L;
    public static final int SEND_TO_BACK = 1;
    public static final int BRING_TO_FRONT = 2;
    public static final int SEND_BACKWARD = 3;
    public static final int BRING_FORWARD = 4;
    public static ReorderAction SendToBack = new ReorderAction(1);
    public static ReorderAction BringToFront = new ReorderAction(2);
    public static ReorderAction SendBackward = new ReorderAction(3);
    public static ReorderAction BringForward = new ReorderAction(4);
    private int function;

    public ReorderAction(int function) {
        this(ReorderAction.wordFor(function), function, false);
    }

    public ReorderAction(String name, int function) {
        this(name, function, false);
    }

    public ReorderAction(String name, Icon icon, int function) {
        this(name, icon, function, false);
    }

    public ReorderAction(String name, int function, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
        this.function = function;
    }

    public ReorderAction(String name, Icon icon, int function, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
        this.function = function;
    }

    protected static String wordFor(int f) {
        switch (f) {
            case 3: {
                return "Backward";
            }
            case 1: {
                return "ToBack";
            }
            case 4: {
                return "Forward";
            }
            case 2: {
                return "ToFront";
            }
        }
        return "";
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Editor ce = Globals.curEditor();
        LayerManager lm = ce.getLayerManager();
        SelectionManager sm = ce.getSelectionManager();
        sm.reorder(this.function, lm.getActiveLayer());
        sm.endTrans();
    }
}

