/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.pgml;

import java.util.List;
import java.util.StringTokenizer;
import org.tigris.gef.persistence.pgml.BaseHandler;
import org.tigris.gef.persistence.pgml.Container;
import org.tigris.gef.persistence.pgml.PGMLStackParser;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigNode;
import org.xml.sax.SAXException;

public class FigGroupHandler
extends BaseHandler
implements Container {
    private FigGroup group;

    public FigGroupHandler(PGMLStackParser parser, FigGroup theGroup) {
        super(parser);
        this.group = theGroup;
    }

    public FigGroup getFigGroup() {
        return this.group;
    }

    public void endElement(String uri, String localname, String qname) throws SAXException {
        if (this.group instanceof FigNode) {
            Object owner = this.group.getOwner();
            List nodes = this.getPGMLStackParser().getDiagram().getNodes();
            if (!nodes.contains(owner)) {
                nodes.add(owner);
            }
        }
        super.endElement(uri, localname, qname);
    }

    public void addObject(Object toAdd) {
        if (toAdd instanceof Fig) {
            this.group.addFig((Fig)toAdd);
        }
        if (toAdd instanceof String) {
            StringTokenizer st2 = new StringTokenizer((String)toAdd, "=\"' \t\n");
            while (st2.hasMoreElements()) {
                String t = st2.nextToken();
                String v = "no such fig";
                if (st2.hasMoreElements()) {
                    v = st2.nextToken();
                }
                if (!t.equals("enclosingFig")) continue;
                this.group.setEnclosingFig(this.getPGMLStackParser().findFig(v));
            }
        }
    }
}

