/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.argouml.core.propertypanels.ui.ExpressionModel;
import org.argouml.i18n.Translator;
import org.argouml.ui.LookAndFeelMgr;

class ExpressionLanguageField
extends JTextField
implements DocumentListener {
    private ExpressionModel model;

    public ExpressionLanguageField(ExpressionModel m) {
        this.model = m;
        this.getDocument().addDocumentListener(this);
        this.setToolTipText(Translator.localize((String)"label.language.tooltip"));
        this.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        String oldText = this.getText();
        String newText = this.model.getLanguage();
        if (!(oldText != null && newText != null && oldText.equals(newText) || oldText == newText)) {
            this.setText(newText);
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        this.model.setLanguage(this.getText());
    }

    public void removeUpdate(DocumentEvent p1) {
        this.model.setLanguage(this.getText());
    }

    public void insertUpdate(DocumentEvent p1) {
        this.model.setLanguage(this.getText());
    }
}

