/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.argouml.core.propertypanels.ui.UMLExpressionModel;
import org.argouml.i18n.Translator;
import org.argouml.ui.LookAndFeelMgr;

class UMLExpressionLanguageField
extends JTextField
implements DocumentListener {
    private UMLExpressionModel model;
    private boolean notifyModel;

    public UMLExpressionLanguageField(UMLExpressionModel m, boolean n) {
        this.model = m;
        this.notifyModel = n;
        this.getDocument().addDocumentListener(this);
        this.setToolTipText(Translator.localize((String)"label.language.tooltip"));
        this.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        this.update();
    }

    void update() {
        String oldText = this.getText();
        String newText = this.model.getLanguage();
        if (!(oldText != null && newText != null && oldText.equals(newText) || oldText == newText)) {
            this.setText(newText);
        }
        if (newText == null) {
            this.setEditable(false);
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        this.model.setLanguage(this.getText());
    }

    public void removeUpdate(DocumentEvent p1) {
        this.model.setLanguage(this.getText());
    }

    public void insertUpdate(DocumentEvent p1) {
        this.model.setLanguage(this.getText());
    }
}

