/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

class UMLSubmachineStateComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = -8661322478068344016L;

    public UMLSubmachineStateComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAStateMachine(element) && element != Model.getStateMachinesHelper().getStateMachine(this.getTarget());
    }

    protected void buildModelList() {
        this.removeAllElements();
        Project p = ProjectManager.getManager().getCurrentProject();
        Object model = p.getModel();
        this.setElements(Model.getStateMachinesHelper().getAllPossibleStatemachines(model, this.getTarget()));
    }

    protected Object getSelectedModelElement() {
        if (this.getTarget() != null) {
            return Model.getFacade().getSubmachine(this.getTarget());
        }
        return null;
    }

    public Action getAction() {
        return new ActionSetSubmachineStateSubmachine();
    }

    private class ActionSetSubmachineStateSubmachine
    extends UndoableAction {
        private static final long serialVersionUID = -2501791485368016442L;

        protected ActionSetSubmachineStateSubmachine() {
            super(Translator.localize((String)"action.set"), null);
            this.putValue("ShortDescription", Translator.localize((String)"action.set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox box = (UMLComboBox)e.getSource();
            Model.getStateMachinesHelper().setStatemachineAsSubmachine(UMLSubmachineStateComboBoxModel.this.getTarget(), box.getSelectedItem());
        }
    }
}

