/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.argouml.model.Model;

class UMLValueSpecificationModel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(UMLValueSpecificationModel.class.getName());
    private Object target;
    private String propertyName;
    private Object rememberExpression;
    private static final String EMPTYSTRING = "";
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public UMLValueSpecificationModel(Object target, String name) {
        this.target = target;
        this.propertyName = name;
        this.startListeningForModelChanges();
    }

    protected void startListeningForModelChanges() {
        if (Model.getFacade().isAUMLElement(this.target)) {
            Model.getPump().addModelEventListener((PropertyChangeListener)this, this.target, this.propertyName);
        }
        LOG.log(Level.FINE, ">>Start listening for UML changes...");
    }

    protected void stopListeningForModelChanges() {
        if (Model.getFacade().isAUMLElement(this.target)) {
            Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.target, this.propertyName);
        }
        LOG.log(Level.FINE, ">>Stop listening for UML changes...");
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.propertyName.equals(e.getPropertyName())) {
            if (this.rememberExpression != e.getNewValue()) {
                this.fireStateChanged();
                LOG.log(Level.FINE, ">>UML expression changed.");
            } else {
                LOG.log(Level.FINE, ">>Got an event for a modelchange that we inflicted ourselves...");
            }
        }
    }

    protected Object getTarget() {
        return this.target;
    }

    public Object getExpression() {
        return Model.getFacade().getInitialValue(this.getTarget());
    }

    private void setExpression(Object expression) {
        Object target = this.getTarget();
        assert (expression == null || Model.getFacade().isAExpression(expression));
        Model.getCoreHelper().setInitialValue(target, null);
        Model.getCoreHelper().setInitialValue(target, expression);
    }

    public Object newExpression(String lang, String body) {
        return Model.getDataTypesFactory().createExpression(lang, body);
    }

    public String getText() {
        Object expression = this.getExpression();
        if (expression == null) {
            return EMPTYSTRING;
        }
        return Model.getFacade().getBody(expression).toString();
    }

    public Object[] getValue() {
        return Model.getDataTypesHelper().getValueSpecificationValues(this.getExpression());
    }

    public void setValue(Object[] tabValues) {
        this.rememberExpression = this.getExpression();
        this.stopListeningForModelChanges();
        if (tabValues == null) {
            if (this.rememberExpression != null) {
                Model.getUmlFactory().delete(this.rememberExpression);
            }
            this.rememberExpression = null;
            this.setExpression(this.rememberExpression);
        } else {
            Model.getDataTypesHelper().modifyValueSpecification(this.rememberExpression, tabValues);
            Model.getCoreHelper().setInitialValue(this.target, this.rememberExpression);
        }
        this.startListeningForModelChanges();
    }

    public void createValueSpecification(String sType) {
        Object exp = Model.getDataTypesHelper().createValueSpecification(this.getTarget(), sType);
        Model.getCoreHelper().setInitialValue(this.target, exp);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
        LOG.log(Level.FINE, ">>Add listener");
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
        LOG.log(Level.FINE, ">>Remove listener");
    }

    protected void fireStateChanged() {
        LOG.log(Level.FINE, ">>Fire state changed to listeners.");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

