/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.argouml.model.AbstractModelEventPump;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.AssociationChangeListener;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.DeleteInstanceEvent;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.model.UmlChangeListener;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.RootContainerAdapter;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelEventPumpEUMLImpl
extends AbstractModelEventPump {
    private final List<Element> deleteEventIgnoreList = new ArrayList<Element>();
    private EUMLModelImplementation modelImpl;
    private RootContainerAdapter rootContainerAdapter = new RootContainerAdapter(this);
    private Map<Object, List<Listener>> registerForElements = new HashMap<Object, List<Listener>>();
    private Map<Object, List<Listener>> registerForClasses = new LinkedHashMap<Object, List<Listener>>();
    private Object mutex;
    private static final Logger LOG = Logger.getLogger(ModelEventPumpEUMLImpl.class.getName());
    public static final int COMMAND_STACK_UPDATE = 11;

    public ModelEventPumpEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
        this.mutex = this;
        implementation.getEditingDomain().getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                ModelEventPumpEUMLImpl.this.notifyChanged((Notification)new NotificationImpl(11, false, false));
            }
        });
    }

    public void setRootContainer(Notifier container) {
        this.rootContainerAdapter.setRootContainer(container);
    }

    public RootContainerAdapter getRootContainer() {
        return this.rootContainerAdapter;
    }

    @Override
    public void addClassModelEventListener(PropertyChangeListener listener, Object modelClass, String[] propertyNames) {
        if (!(modelClass instanceof Class) || !EObject.class.isAssignableFrom((Class)modelClass)) {
            throw new IllegalArgumentException("The model class must be instance of java.lang.Class<EObject>");
        }
        this.registerListener(modelClass, listener, propertyNames, this.registerForClasses);
    }

    @Override
    public void addModelEventListener(PropertyChangeListener listener, Object modelElement, String[] propertyNames) {
        LOG.log(Level.FINE, "Adding a listener {0} to {1} for {2}", new Object[]{listener, modelElement, propertyNames});
        if (!(modelElement instanceof EObject)) {
            throw new IllegalArgumentException("The modelelement must be instance of EObject. We got " + modelElement);
        }
        this.registerListener(modelElement, listener, propertyNames, this.registerForElements);
    }

    @Override
    public void addModelEventListener(UmlChangeListener listener, Object modelElement, String[] propertyNames) {
        LOG.log(Level.FINE, "Adding a listener {0} to {1} for {2}", new Object[]{listener, modelElement, propertyNames});
        if (!(modelElement instanceof EObject)) {
            throw new IllegalArgumentException("The modelelement must be instance of EObject. We got " + modelElement);
        }
        this.registerListener(modelElement, listener, propertyNames, this.registerForElements);
    }

    @Override
    public void addModelEventListener(PropertyChangeListener listener, Object modelelement) {
        this.addModelEventListener(listener, modelelement, (String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(Object notifier, EventListener listener, String[] propertyNames, Map<Object, List<Listener>> register) {
        if (notifier == null || listener == null) {
            throw new NullPointerException("The model element/class and the listener must be non-null.");
        }
        Object object = this.mutex;
        synchronized (object) {
            List<Listener> list = register.get(notifier);
            boolean found = false;
            if (list == null) {
                list = new ArrayList<Listener>();
                register.put(notifier, list);
            } else {
                for (Listener l : list) {
                    if (l.getListener() != listener) continue;
                    l.setProperties(propertyNames);
                    found = true;
                    break;
                }
            }
            if (!found) {
                list.add(new Listener(listener, propertyNames));
            }
        }
    }

    @Override
    public void flushModelEvents() {
    }

    @Override
    public void removeClassModelEventListener(PropertyChangeListener listener, Object modelClass, String[] propertyNames) {
        if (!(modelClass instanceof Class) || !EObject.class.isAssignableFrom((Class)modelClass)) {
            throw new IllegalArgumentException();
        }
        this.unregisterListener(modelClass, listener, propertyNames, this.registerForClasses);
    }

    @Override
    public void removeModelEventListener(PropertyChangeListener listener, Object modelelement, String[] propertyNames) {
        this.unregisterListener(modelelement, listener, propertyNames, this.registerForElements);
    }

    @Override
    public void removeModelEventListener(UmlChangeListener listener, Object modelelement, String[] propertyNames) {
        this.unregisterListener(modelelement, listener, propertyNames, this.registerForElements);
    }

    @Override
    public void removeModelEventListener(PropertyChangeListener listener, Object modelelement) {
        this.removeModelEventListener(listener, modelelement, (String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(Object notifier, EventListener listener, String[] propertyNames, Map<Object, List<Listener>> register) {
        if (notifier == null || listener == null) {
            throw new NullPointerException("The model element/class and the listener must be non-null.");
        }
        Object object = this.mutex;
        synchronized (object) {
            List<Listener> list = register.get(notifier);
            if (list == null) {
                return;
            }
            Iterator<Listener> iter = list.iterator();
            while (iter.hasNext()) {
                Listener l = iter.next();
                if (l.getListener() != listener) continue;
                if (propertyNames != null) {
                    l.removeProperties(propertyNames);
                    if (!l.getProperties().isEmpty()) break;
                    iter.remove();
                    break;
                }
                iter.remove();
                break;
            }
            if (list.isEmpty()) {
                register.remove(notifier);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 8) {
            return;
        }
        ENamedElement feature = (ENamedElement)notification.getFeature();
        String featureName = feature == null ? "" : feature.getName();
        EReference oppositeRef = feature instanceof EReference ? ((EReference)feature).getEOpposite() : null;
        this.fireEvent(notification.getNotifier(), notification.getOldValue(), notification.getNewValue(), notification.getEventType(), featureName, oppositeRef);
    }

    void fireEvent(Object notifier, Object oldValue, Object newValue, int eventType, String featureName, EReference oppositeRef) {
        String propName;
        LOG.log(Level.FINE, "event  - Property: {0} Type : {1} Old: {2} New: {3} From: {4}", new Object[]{featureName, eventType, oldValue, newValue, notifier});
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EventAndListeners {
            private PropertyChangeEvent event;
            private List<EventListener> listeners;

            public EventAndListeners(PropertyChangeEvent e, List<EventListener> l) {
                this.event = e;
                this.listeners = l;
            }
        }
        ArrayList<EventAndListeners> events = new ArrayList<EventAndListeners>();
        if (eventType == 1) {
            propName = this.mapPropertyName(featureName);
            events.add(new EventAndListeners(new AttributeChangeEvent(notifier, propName, oldValue, newValue, null), this.getListeners(notifier, propName)));
        } else if (eventType == 3 || eventType == 4) {
            propName = this.mapPropertyName(featureName);
            if (eventType == 3) {
                events.add(new EventAndListeners(new AddAssociationEvent(notifier, propName, null, newValue, newValue, null), this.getListeners(notifier, propName)));
                events.add(new EventAndListeners(new AttributeChangeEvent(notifier, propName, null, newValue, null), this.getListeners(notifier, propName)));
            } else {
                if (this.isDeleteEventRequired(oldValue)) {
                    events.add(new EventAndListeners(new DeleteInstanceEvent(oldValue, "remove", null, null, null), this.getListeners(oldValue)));
                } else {
                    LOG.log(Level.INFO, "Not sending delete event - assume remove");
                }
                events.add(new EventAndListeners(new RemoveAssociationEvent(notifier, propName, oldValue, null, oldValue, null), this.getListeners(notifier, propName)));
                events.add(new EventAndListeners(new AttributeChangeEvent(notifier, propName, oldValue, null, null), this.getListeners(notifier, propName)));
            }
            if (oppositeRef != null) {
                propName = this.mapPropertyName(oppositeRef.getName());
                if (eventType == 3) {
                    events.add(new EventAndListeners(new AddAssociationEvent(newValue, propName, null, notifier, notifier, null), this.getListeners(newValue, propName)));
                    events.add(new EventAndListeners(new AttributeChangeEvent(newValue, propName, null, notifier, null), this.getListeners(newValue, propName)));
                } else {
                    events.add(new EventAndListeners(new AddAssociationEvent(oldValue, propName, notifier, null, notifier, null), this.getListeners(oldValue, propName)));
                }
            }
        }
        for (EventAndListeners e : events) {
            if (e.listeners == null) continue;
            for (EventListener l : e.listeners) {
                if (l instanceof AssociationChangeListener) {
                    if (e.event instanceof AddAssociationEvent) {
                        ((AssociationChangeListener)l).elementAdded((AddAssociationEvent)e.event);
                        continue;
                    }
                    if (!(e.event instanceof RemoveAssociationEvent)) continue;
                    ((AssociationChangeListener)l).elementRemoved((RemoveAssociationEvent)e.event);
                    continue;
                }
                if (!(l instanceof PropertyChangeListener)) continue;
                ((PropertyChangeListener)l).propertyChange(e.event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeleteEventRequired(Object element) {
        List<Element> list = this.deleteEventIgnoreList;
        synchronized (list) {
            if (this.deleteEventIgnoreList.contains(element)) {
                this.deleteEventIgnoreList.remove(element);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addElementForDeleteEventIgnore(Element element) {
        List<Element> list = this.deleteEventIgnoreList;
        synchronized (list) {
            this.deleteEventIgnoreList.add(element);
        }
    }

    private List<EventListener> getListeners(Object element) {
        return this.getListeners(element, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EventListener> getListeners(Object element, String propName) {
        ArrayList<EventListener> returnedList = new ArrayList<EventListener>();
        Object object = this.mutex;
        synchronized (object) {
            this.addListeners(returnedList, element, propName, this.registerForElements);
            for (Object o : this.registerForClasses.keySet()) {
                Class type;
                if (!(o instanceof Class) || !(type = (Class)o).isAssignableFrom(element.getClass())) continue;
                this.addListeners(returnedList, o, propName, this.registerForClasses);
            }
        }
        return returnedList.isEmpty() ? null : returnedList;
    }

    private void addListeners(List<EventListener> listeners, Object element, String propName, Map<Object, List<Listener>> register) {
        List<Listener> list = register.get(element);
        if (list != null) {
            for (Listener l : list) {
                if (propName != null && l.getProperties() != null && !l.getProperties().contains(propName)) continue;
                listeners.add(l.getListener());
            }
        }
    }

    @Override
    public void startPumpingEvents() {
        this.rootContainerAdapter.setDeliverEvents(true);
    }

    @Override
    public void stopPumpingEvents() {
        this.rootContainerAdapter.setDeliverEvents(false);
    }

    private String mapPropertyName(String name) {
        if (name.equals("ownedAttribute")) {
            return "feature";
        }
        return name;
    }

    @Override
    public List getDebugInfo() {
        ArrayList<Object> info = new ArrayList<Object>();
        info.add("Event Listeners");
        for (Map.Entry<Object, List<Listener>> entry : this.registerForElements.entrySet()) {
            String item = entry.getKey().toString();
            List<String> modelElementNode = this.newDebugNode(item);
            info.add(modelElementNode);
            List<Listener> listenerList = entry.getValue();
            HashMap map = new HashMap();
            for (Listener listener : listenerList) {
                if (listener.getProperties() != null) {
                    for (String eventName : listener.getProperties()) {
                        if (!map.containsKey(eventName)) {
                            map.put(eventName, new LinkedList());
                        }
                        ((List)map.get(eventName)).add(listener.getListener().getClass().getName());
                    }
                    continue;
                }
                if (!map.containsKey("")) {
                    map.put("", new LinkedList());
                }
                ((List)map.get("")).add(listener.getListener().getClass().getName());
            }
            for (Map.Entry o : map.entrySet()) {
                modelElementNode.add((String)o.getKey());
                modelElementNode.add((String)((Object)((List)o.getValue())));
            }
        }
        return info;
    }

    private List<String> newDebugNode(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener {
        private EventListener listener;
        private Set<String> props;

        Listener(EventListener theListener, String[] properties) {
            this.listener = theListener;
            if (properties != null) {
                this.setProperties(properties);
            }
        }

        void setProperties(String[] properties) {
            if (properties == null) {
                this.props = null;
            } else {
                if (this.props == null) {
                    this.props = new HashSet<String>();
                }
                for (String s : properties) {
                    this.props.add(s);
                }
            }
        }

        void removeProperties(String[] properties) {
            if (this.props == null) {
                return;
            }
            for (String s : properties) {
                this.props.remove(s);
            }
        }

        EventListener getListener() {
            return this.listener;
        }

        Set<String> getProperties() {
            return this.props;
        }
    }
}

