/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.argouml.model.UmlException;
import org.argouml.model.XmiExtensionWriter;
import org.argouml.model.XmiWriter;
import org.argouml.model.euml.EUMLModelImplementation;
import org.argouml.model.euml.NotYetImplementedException;
import org.eclipse.uml2.uml.Package;

class XmiWriterEUMLImpl
implements XmiWriter {
    private EUMLModelImplementation modelImpl;
    private OutputStream oStream;
    private Package model;

    public XmiWriterEUMLImpl(EUMLModelImplementation implementation, Object theModel, OutputStream stream, String version) {
        if (stream == null) {
            throw new IllegalArgumentException("An OutputStream must be provided");
        }
        if (!(theModel instanceof Package)) {
            throw new IllegalArgumentException("A container must be provided and it must be a UML 2 Package");
        }
        if (implementation == null) {
            throw new IllegalArgumentException("A parent must be provided");
        }
        this.modelImpl = implementation;
        this.model = (Package)theModel;
        this.oStream = stream;
    }

    public void write() throws UmlException {
        if (this.model.eResource() == null) {
            throw new UmlException("Root container is not affiliated with any resource!");
        }
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("LINE_WIDTH", 100);
        try {
            this.modelImpl.getModelEventPump().stopPumpingEvents();
            this.model.eResource().save(this.oStream, options);
        }
        catch (IOException ioe) {
            throw new UmlException(ioe);
        }
        finally {
            this.modelImpl.getModelEventPump().startPumpingEvents();
        }
    }

    public void setXmiExtensionWriter(XmiExtensionWriter xmiExtensionWriter) {
        throw new NotYetImplementedException();
    }
}

