/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class DOMLineNumbers {
    private final Document document;
    private String xmlString;
    private List<Integer> lines;

    public DOMLineNumbers(Document document, String xmlString) {
        this.document = document;
        this.xmlString = xmlString;
    }

    public void determine() {
        this.calculateLinesMap();
        this.determineLocation(this.document, 0);
    }

    private int determineLocation(Node n, int index) {
        String te;
        ProcessingInstruction pi;
        int nextIndex = index;
        if (n.getNodeType() == 10) {
            nextIndex = this.xmlString.indexOf("<!DOCTYPE", nextIndex);
        } else if (n.getNodeType() == 8) {
            nextIndex = this.xmlString.indexOf("<!--", nextIndex);
        } else if (n.getNodeType() == 1) {
            nextIndex = this.xmlString.indexOf("<" + n.getNodeName(), nextIndex);
        } else if (n.getNodeType() == 4) {
            nextIndex = this.xmlString.indexOf("<![CDATA[", nextIndex);
        } else if (n.getNodeType() == 7) {
            pi = (ProcessingInstruction)n;
            nextIndex = this.xmlString.indexOf("<?" + pi.getTarget(), nextIndex);
        } else if (n.getNodeType() == 3) {
            te = this.unexpandEntities(n, n.getNodeValue());
            int newIndex = this.xmlString.indexOf(te, nextIndex);
            if (newIndex > 0) {
                nextIndex = newIndex;
            }
        } else if (n.getNodeType() == 5) {
            nextIndex = this.xmlString.indexOf("&" + n.getNodeName() + ";", nextIndex);
        }
        this.setBeginLocation(n, nextIndex);
        if (n.hasChildNodes()) {
            NodeList childs = n.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                nextIndex = this.determineLocation(childs.item(i), nextIndex);
            }
        }
        if (n.getNodeType() == 1) {
            nextIndex += 2 + n.getNodeName().length() + 1;
        } else if (n.getNodeType() == 10) {
            Node nextSibling = n.getNextSibling();
            nextIndex = nextSibling.getNodeType() == 1 ? this.xmlString.indexOf("<" + nextSibling.getNodeName(), nextIndex) - 1 : (nextSibling.getNodeType() == 8 ? this.xmlString.indexOf("<!--", nextIndex) : this.xmlString.indexOf(">", nextIndex));
        } else if (n.getNodeType() == 8) {
            nextIndex += 7;
            nextIndex += n.getNodeValue().length();
        } else if (n.getNodeType() == 3) {
            te = this.unexpandEntities(n, n.getNodeValue());
            nextIndex += te.length();
        } else if (n.getNodeType() == 4) {
            nextIndex += "<![CDATA[".length() + n.getNodeValue().length() + "]]>".length();
        } else if (n.getNodeType() == 7) {
            pi = (ProcessingInstruction)n;
            nextIndex += "<?".length() + pi.getTarget().length() + "?>".length() + pi.getData().length();
        }
        this.setEndLocation(n, nextIndex - 1);
        return nextIndex;
    }

    private String unexpandEntities(Node n, String te) {
        String result = te;
        DocumentType doctype = n.getOwnerDocument().getDoctype();
        result = result.replaceAll(Matcher.quoteReplacement("&"), "&amp;");
        result = result.replaceAll(Matcher.quoteReplacement("<"), "&lt;");
        result = result.replaceAll(Matcher.quoteReplacement(">"), "&gt;");
        result = result.replaceAll(Matcher.quoteReplacement("\""), "&quot;");
        result = result.replaceAll(Matcher.quoteReplacement("'"), "&apos;");
        if (doctype != null) {
            NamedNodeMap entities = doctype.getEntities();
            String internalSubset = doctype.getInternalSubset();
            if (internalSubset == null) {
                internalSubset = "";
            }
            for (int i = 0; i < entities.getLength(); ++i) {
                Node item = entities.item(i);
                String entityName = item.getNodeName();
                Node firstChild = item.getFirstChild();
                if (firstChild != null) {
                    result = result.replaceAll(Matcher.quoteReplacement(firstChild.getNodeValue()), "&" + entityName + ";");
                    continue;
                }
                Matcher m = Pattern.compile(Matcher.quoteReplacement("<!ENTITY " + entityName + " ") + "[']([^']*)[']>").matcher(internalSubset);
                if (!m.find()) continue;
                result = result.replaceAll(Matcher.quoteReplacement(m.group(1)), "&" + entityName + ";");
            }
        }
        return result;
    }

    private void setBeginLocation(Node n, int index) {
        if (n != null) {
            int line = this.toLine(index);
            n.setUserData("pmd:beginLine", line, null);
            n.setUserData("pmd:beginColumn", this.toColumn(line, index), null);
        }
    }

    private void setEndLocation(Node n, int index) {
        if (n != null) {
            int line = this.toLine(index);
            n.setUserData("pmd:endLine", line, null);
            n.setUserData("pmd:endColumn", this.toColumn(line, index), null);
        }
    }

    private void calculateLinesMap() {
        this.lines = new ArrayList<Integer>();
        int index = -1;
        int count = StringUtils.countMatches((CharSequence)this.xmlString, (CharSequence)"\n");
        for (int line = 1; line <= count; ++line) {
            this.lines.add(index + 1);
            index = this.xmlString.indexOf("\n", index + 1);
        }
        this.lines.add(index + 1);
    }

    private int toLine(int index) {
        int low = 0;
        int high = this.lines.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            int middleStart = this.lines.get(middle);
            if (middleStart == index) {
                return middle + 1;
            }
            if (middleStart > index) {
                high = middle - 1;
                continue;
            }
            low = middle + 1;
        }
        return low;
    }

    private int toColumn(int line, int index) {
        Integer lineStart = this.lines.get(line - 1);
        if (lineStart == null) {
            lineStart = this.lines.get(this.lines.size() - 1);
        }
        int column = index - lineStart;
        return column + 1;
    }
}

