/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.benchmark.TextReport;
import net.sourceforge.pmd.cli.PMDCommandLineInterface;
import net.sourceforge.pmd.cli.PMDParameters;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageFilenameFilter;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.processor.MonoThreadProcessor;
import net.sourceforge.pmd.processor.MultiThreadProcessor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.SystemUtils;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.datasource.ReaderDataSource;
import net.sourceforge.pmd.util.log.ConsoleLogHandler;
import net.sourceforge.pmd.util.log.ScopedLogHandlersManager;

public class PMD {
    private static final Logger LOG = Logger.getLogger(PMD.class.getName());
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String SUPPRESS_MARKER = "NOPMD";
    protected final PMDConfiguration configuration;
    private final SourceCodeProcessor rulesetsFileProcessor;
    public static final String VERSION;

    public static List<DataSource> getURIDataSources(String uriString) throws PMDException {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        try {
            DBURI dbUri = new DBURI(uriString);
            DBMSMetadata dbmsMetadata = new DBMSMetadata(dbUri);
            LOG.log(Level.FINE, "DBMSMetadata retrieved");
            List<SourceObject> sourceObjectList = dbmsMetadata.getSourceObjectList();
            LOG.log(Level.FINE, "Located {0} database source objects", sourceObjectList.size());
            for (SourceObject sourceObject : sourceObjectList) {
                String falseFilePath = sourceObject.getPseudoFileName();
                LOG.log(Level.FINEST, "Adding database source object {0}", falseFilePath);
                try {
                    dataSources.add(new ReaderDataSource(dbmsMetadata.getSourceCode(sourceObject), falseFilePath));
                }
                catch (SQLException ex) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Cannot get SourceCode for " + falseFilePath + "  - skipping ...", ex);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new PMDException("Cannot get DataSources from DBURI - \"" + uriString + "\"", e);
        }
        catch (SQLException e) {
            throw new PMDException("Cannot get DataSources from DBURI, couldn't access the database - \"" + uriString + "\"", e);
        }
        catch (ClassNotFoundException e) {
            throw new PMDException("Cannot get DataSources from DBURI, probably missing database jdbc driver - \"" + uriString + "\"", e);
        }
        catch (Exception e) {
            throw new PMDException("Encountered unexpected problem with URI \"" + uriString + "\"", e);
        }
        return dataSources;
    }

    public static Parser parserFor(LanguageVersion languageVersion, PMDConfiguration configuration) {
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        ParserOptions options = languageVersionHandler.getDefaultParserOptions();
        if (configuration != null) {
            options.setSuppressMarker(configuration.getSuppressMarker());
        }
        return languageVersionHandler.getParser(options);
    }

    public static Report setupReport(RuleSets rs, RuleContext ctx, String fileName) {
        Set<Rule> brokenRules = PMD.removeBrokenRules(rs);
        Report report = Report.createReport(ctx, fileName);
        for (Rule rule : brokenRules) {
            report.addConfigError(new Report.RuleConfigurationError(rule, rule.dysfunctionReason()));
        }
        return report;
    }

    private static Set<Rule> removeBrokenRules(RuleSets ruleSets) {
        HashSet<Rule> brokenRules = new HashSet<Rule>();
        ruleSets.removeDysfunctionalRules(brokenRules);
        for (Rule rule : brokenRules) {
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.log(Level.WARNING, "Removed misconfigured rule: " + rule.getName() + "  cause: " + rule.dysfunctionReason());
        }
        return brokenRules;
    }

    public PMD() {
        this(new PMDConfiguration());
    }

    public PMD(PMDConfiguration configuration) {
        this.configuration = configuration;
        this.rulesetsFileProcessor = new SourceCodeProcessor(configuration);
    }

    public PMDConfiguration getConfiguration() {
        return this.configuration;
    }

    public SourceCodeProcessor getSourceCodeProcessor() {
        return this.rulesetsFileProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doPMD(PMDConfiguration configuration) {
        RuleSetFactory ruleSetFactory = RulesetsFactoryUtils.getRulesetFactory(configuration);
        RuleSets ruleSets = RulesetsFactoryUtils.getRuleSetsWithBenchmark(configuration.getRuleSets(), ruleSetFactory);
        if (ruleSets == null) {
            return 0;
        }
        Set<Language> languages = PMD.getApplicableLanguages(configuration, ruleSets);
        List<DataSource> files = PMD.getApplicableFiles(configuration, languages);
        long reportStart = System.nanoTime();
        try {
            Renderer renderer = configuration.createRenderer();
            LinkedList<Renderer> renderers = new LinkedList<Renderer>();
            renderers.add(renderer);
            renderer.setWriter(IOUtil.createWriter(configuration.getReportFile()));
            renderer.start();
            Benchmarker.mark(Benchmark.Reporting, System.nanoTime() - reportStart, 0L);
            RuleContext ctx = new RuleContext();
            final AtomicInteger violations = new AtomicInteger(0);
            ctx.getReport().addListener(new ReportListener(){

                @Override
                public void ruleViolationAdded(RuleViolation ruleViolation) {
                    violations.incrementAndGet();
                }

                @Override
                public void metricAdded(Metric metric) {
                }
            });
            PMD.processFiles(configuration, ruleSetFactory, files, ctx, renderers);
            reportStart = System.nanoTime();
            renderer.end();
            renderer.flush();
            int n = violations.get();
            return n;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null) {
                LOG.severe(message);
            } else {
                LOG.log(Level.SEVERE, "Exception during processing", e);
            }
            LOG.log(Level.FINE, "Exception during processing", e);
            LOG.info(PMDCommandLineInterface.buildUsageText());
            int n = 0;
            return n;
        }
        finally {
            Benchmarker.mark(Benchmark.Reporting, System.nanoTime() - reportStart, 0L);
        }
    }

    public static RuleContext newRuleContext(String sourceCodeFilename, File sourceCodeFile) {
        RuleContext context = new RuleContext();
        context.setSourceCodeFile(sourceCodeFile);
        context.setSourceCodeFilename(sourceCodeFilename);
        context.setReport(new Report());
        return context;
    }

    public static void processFiles(PMDConfiguration configuration, RuleSetFactory ruleSetFactory, Collection<File> files, RuleContext ctx, ProgressMonitor monitor) {
    }

    public static void processFiles(PMDConfiguration configuration, RuleSetFactory ruleSetFactory, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        PMD.sortFiles(configuration, files);
        if (SystemUtils.MT_SUPPORTED && configuration.getThreads() > 0) {
            new MultiThreadProcessor(configuration).processFiles(ruleSetFactory, files, ctx, renderers);
        } else {
            new MonoThreadProcessor(configuration).processFiles(ruleSetFactory, files, ctx, renderers);
        }
    }

    private static void sortFiles(PMDConfiguration configuration, List<DataSource> files) {
        if (configuration.isStressTest()) {
            Collections.shuffle(files);
        } else {
            final boolean useShortNames = configuration.isReportShortNames();
            final String inputPaths = configuration.getInputPaths();
            Collections.sort(files, new Comparator<DataSource>(){

                @Override
                public int compare(DataSource left, DataSource right) {
                    String leftString = left.getNiceFileName(useShortNames, inputPaths);
                    String rightString = right.getNiceFileName(useShortNames, inputPaths);
                    return leftString.compareTo(rightString);
                }
            });
        }
    }

    public static List<DataSource> getApplicableFiles(PMDConfiguration configuration, Set<Language> languages) {
        long startFiles = System.nanoTime();
        List<DataSource> files = PMD.internalGetApplicableFiles(configuration, languages);
        long endFiles = System.nanoTime();
        Benchmarker.mark(Benchmark.CollectFiles, endFiles - startFiles, 0L);
        return files;
    }

    private static List<DataSource> internalGetApplicableFiles(PMDConfiguration configuration, Set<Language> languages) {
        LanguageFilenameFilter fileSelector = new LanguageFilenameFilter(languages);
        ArrayList<DataSource> files = new ArrayList<DataSource>();
        if (null != configuration.getInputPaths()) {
            files.addAll(FileUtil.collectFiles(configuration.getInputPaths(), fileSelector));
        }
        if (null != configuration.getInputUri()) {
            String uriString = configuration.getInputUri();
            try {
                List<DataSource> dataSources = PMD.getURIDataSources(uriString);
                files.addAll(dataSources);
            }
            catch (PMDException ex) {
                LOG.log(Level.SEVERE, "Problem with Input URI", ex);
                throw new RuntimeException("Problem with DBURI: " + uriString, ex);
            }
        }
        return files;
    }

    private static Set<Language> getApplicableLanguages(PMDConfiguration configuration, RuleSets ruleSets) {
        HashSet<Language> languages = new HashSet<Language>();
        LanguageVersionDiscoverer discoverer = configuration.getLanguageVersionDiscoverer();
        for (Rule rule : ruleSets.getAllRules()) {
            LanguageVersion version;
            Language language = rule.getLanguage();
            if (languages.contains(language) || !RuleSet.applies(rule, version = discoverer.getDefaultLanguageVersion(language))) continue;
            languages.add(language);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Using " + language.getShortName() + " version: " + version.getShortName());
        }
        return languages;
    }

    public static void main(String[] args) {
        PMDCommandLineInterface.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String[] args) {
        int status = 0;
        long start = System.nanoTime();
        PMDParameters params = PMDCommandLineInterface.extractParameters(new PMDParameters(), args, "pmd");
        PMDConfiguration configuration = PMDParameters.transformParametersIntoConfiguration(params);
        Level logLevel = params.isDebug() ? Level.FINER : Level.INFO;
        ConsoleLogHandler logHandler = new ConsoleLogHandler();
        ScopedLogHandlersManager logHandlerManager = new ScopedLogHandlersManager(logLevel, logHandler);
        Level oldLogLevel = LOG.getLevel();
        LOG.setLevel(logLevel);
        try {
            int violations = PMD.doPMD(configuration);
            status = violations > 0 ? 4 : 0;
        }
        catch (Exception e) {
            System.out.println(PMDCommandLineInterface.buildUsageText());
            System.out.println();
            System.err.println(e.getMessage());
            status = 1;
        }
        finally {
            logHandlerManager.close();
            LOG.setLevel(oldLogLevel);
            if (params.isBenchmark()) {
                long end = System.nanoTime();
                Benchmarker.mark(Benchmark.TotalPMD, end - start, 0L);
                TextReport report = new TextReport();
                report.generate(Benchmarker.values(), System.err);
            }
        }
        return status;
    }

    static {
        String pmdVersion = null;
        InputStream stream = PMD.class.getResourceAsStream("/META-INF/maven/net.sourceforge.pmd/pmd-core/pom.properties");
        if (stream != null) {
            try {
                Properties properties = new Properties();
                properties.load(stream);
                pmdVersion = properties.getProperty("version");
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "Couldn't determine version of PMD", e);
            }
        }
        if (pmdVersion == null) {
            pmdVersion = "unknown";
        }
        VERSION = pmdVersion;
    }

    public static interface ProgressMonitor {
        public boolean status(int var1, int var2);
    }
}

