/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.processor.AbstractPMDProcessor;
import net.sourceforge.pmd.processor.PmdRunnable;
import net.sourceforge.pmd.processor.PmdThreadFactory;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.datasource.DataSource;

public class MultiThreadProcessor
extends AbstractPMDProcessor {
    public MultiThreadProcessor(PMDConfiguration configuration) {
        super(configuration);
    }

    public void processFiles(RuleSetFactory ruleSetFactory, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        RuleSets rs = this.createRuleSets(ruleSetFactory);
        rs.start(ctx);
        PmdThreadFactory factory = new PmdThreadFactory(ruleSetFactory, ctx);
        ExecutorService executor = Executors.newFixedThreadPool(this.configuration.getThreads(), factory);
        LinkedList<Future<Report>> tasks = new LinkedList<Future<Report>>();
        for (DataSource dataSource : files) {
            String niceFileName = this.filenameFrom(dataSource);
            PmdRunnable r = new PmdRunnable(executor, this.configuration, dataSource, niceFileName, renderers);
            Future<Report> future = executor.submit(r);
            tasks.add(future);
        }
        executor.shutdown();
        this.processReports(renderers, tasks);
        rs.end(ctx);
        super.renderReports(renderers, ctx.getReport());
    }

    private void processReports(List<Renderer> renderers, List<Future<Report>> tasks) throws Error {
        while (!tasks.isEmpty()) {
            Future<Report> future = tasks.remove(0);
            Report report = null;
            try {
                report = future.get();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                future.cancel(true);
            }
            catch (ExecutionException ee) {
                Throwable t = ee.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalStateException("PmdRunnable exception", t);
            }
            super.renderReports(renderers, report);
        }
    }
}

