/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.pmd.util.filter.Filter;

public class RegexStringFilter
implements Filter<String> {
    private static final Pattern ENDS_WITH = Pattern.compile("\\^?\\.\\*([^\\\\\\[\\(\\.\\*\\?\\+\\|\\{\\$]+)(?:\\\\?(\\.\\w+))?\\$?");
    protected String regex;
    protected Pattern pattern;
    protected String endsWith;

    public RegexStringFilter(String regex) {
        this.regex = regex;
        this.optimize();
    }

    public String getRegex() {
        return this.regex;
    }

    public String getEndsWith() {
        return this.endsWith;
    }

    protected void optimize() {
        Matcher matcher = ENDS_WITH.matcher(this.regex);
        if (matcher.matches()) {
            String literalPath = matcher.group(1);
            String fileExtension = matcher.group(2);
            this.endsWith = fileExtension != null ? literalPath + fileExtension : literalPath;
        } else {
            try {
                this.pattern = Pattern.compile(this.regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean filter(String obj) {
        if (this.endsWith != null) {
            return obj.endsWith(this.endsWith);
        }
        if (this.pattern != null) {
            return this.pattern.matcher(obj).matches();
        }
        return false;
    }

    public String toString() {
        return "matches " + this.regex;
    }
}

