/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.plsql.ast.ASTName;
import net.sourceforge.pmd.lang.plsql.ast.AbstractPLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.symboltable.Applier;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.plsql.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractScope;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ClassScope
extends AbstractScope {
    private static final Logger LOGGER = Logger.getLogger(ClassScope.class.getName());
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;

    public ClassScope(String className) {
        this.className = AbstractPLSQLNode.getCanonicalImage(className);
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    public void addDeclaration(NameDeclaration declaration) {
        if (declaration instanceof VariableNameDeclaration && this.getDeclarations().keySet().contains(declaration)) {
            throw new RuntimeException(declaration + " is already in the symbol table");
        }
        super.addDeclaration(declaration);
    }

    public NameDeclaration addNameOccurrence(NameOccurrence occ) {
        Map<VariableNameDeclaration, List<NameOccurrence>> variableNames;
        List<NameOccurrence> nameOccurrences;
        PLSQLNameOccurrence occurrence = (PLSQLNameOccurrence)occ;
        NameDeclaration decl = this.findVariableHere(occurrence);
        Map<MethodNameDeclaration, List<NameOccurrence>> methodNames = this.getMethodDeclarations();
        if (decl != null && occurrence.isMethodOrConstructorInvocation()) {
            List<NameOccurrence> nameOccurrences2 = methodNames.get(decl);
            if (nameOccurrences2 != null) {
                nameOccurrences2.add(occurrence);
                PLSQLNode n = occurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !occurrence.isThisOrSuper() && (nameOccurrences = (variableNames = this.getVariableDeclarations()).get(decl)) != null) {
            nameOccurrences.add(occurrence);
            PLSQLNode n = occurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.getDeclarations(MethodNameDeclaration.class);
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public ClassScope getEnclosingClassScope() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    protected NameDeclaration findVariableHere(PLSQLNameOccurrence occurrence) {
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations = this.getVariableDeclarations();
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations = this.getMethodDeclarations();
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (variableDeclarations.isEmpty() && methodDeclarations.isEmpty()) {
                return null;
            }
            if (!variableDeclarations.isEmpty()) {
                return (NameDeclaration)variableDeclarations.keySet().iterator().next();
            }
            return (NameDeclaration)methodDeclarations.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                int args;
                if (!mnd.getImage().equals(occurrence.getImage()) || (args = occurrence.getArgumentCount()) != mnd.getParameterCount() && (!mnd.isVarargs() || args < mnd.getParameterCount() - 1)) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (null == occurrence.getImage() && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("occurrence==" + occurrence.toString() + "with Argumanet Count == " + occurrence.getArgumentCount() + " for className=" + this.className);
        }
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, this.getVariableDeclarations().keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        String res = "ClassScope (" + this.className + "): ";
        Map<ClassNameDeclaration, List<NameOccurrence>> classNames = this.getClassDeclarations();
        Map<MethodNameDeclaration, List<NameOccurrence>> methodNames = this.getMethodDeclarations();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableNames = this.getVariableDeclarations();
        if (!classNames.isEmpty()) {
            res = res + "(" + classNames.keySet() + ")";
        }
        if (!methodNames.isEmpty()) {
            for (MethodNameDeclaration mnd : methodNames.keySet()) {
                res = res + mnd.toString();
                int usages = methodNames.get((Object)mnd).size();
                res = res + "(begins at line " + mnd.getNode().getBeginLine() + ", " + usages + " usages)";
                res = res + ",";
            }
        }
        if (!variableNames.isEmpty()) {
            res = res + "(" + variableNames.keySet() + ")";
        }
        return res;
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

