:userdoc.
:title.IPFDoclet Documentation

.********************************************************************************
:h1.What is it?
.********************************************************************************
:font facename='Tms Rmn' size=24x24.What Is It?:font facename='default' size=0x0.

:p.When programming with Java, Sun has provided a tool which makes it
possible to document source code in such a way that the documentation can
be formatted into html, in an extremely readable way.  All of Sun's API
documentation is provided in this format, and developers writing Java code
almost always document their code in this way.  The tool is known as javadoc.

:p.Starting in JDK 1.2, Sun has changed the format of the html generated by
this tool.  They have also provided a simple means to change or extend the
documentation that is generated.  This is by means of the so-called
"Doclets".  A Doclet is a java class that extends the class
sun.sun.javadoc.Doclet.  When running javadoc normally,
a standard doclet is automatically used.  However, an alternative doclet may be specified on the
command line.

:p.In fact, Sun has made this mechanism so powerful, that it is possible to
generate documentation in a completely different format from html.  That is
what this doclet does.

:p.The format generated by this doclet is known as IPF, which stands for
Information Presentation Facility.  This is the format that IBM uses for help
documents on the OS/2 operating system, in a similar way to hlp files on the
Windows family of operating systems.  Unlike on Windows, IPF source files can
be compiled not only to .hlp files, but to standalone online documents, with
the extension inf.  That is the type of document that can be generated from
standard javadoc tags with this tool.

:p.You might wonder what the motivation for doing this is.  After all, html
is a widely available and open standard, with a viewer for virtually every
platform, whereas inf files can be viewed only on the OS/2, Windows, and AIX
platforms (through freely available viewers).  Also, html is a somewhat
richer tagging language than IPF, hence the IPF documents typically aren't as
"pretty" as the html documents generated by the standard javadoc.  However,
IPF has three advantages that, in my opinion, make it a superior choice in
many cases&colon.
:ol.
:li.IPF files, when compiled, are highly compact.  For example, the html
documentation for the entire java&colon.* hierarchy from JDK 1.2 is roughly
35 Mb in size, whereas the inf file generated by this tool for the same
hierarchy is only 5 Mb in size.
:li.The viewer is extremely lightweight and fast to load.  In order to view
an html document, you must use a web browser.  Today's most popular browsers,
Netscape and Internet Explorer are multi-megabyte monsters, sometimes
requiring 10 or more Mb of memory to run.  In contrast, the iview inf viewer
for Windows NT uses only 3 Mb of memory to view the full swing documentation.
It also loads much more quickly.  Even lean and fast browsers like Opera are
not as efficient as a special-purpose viewer like the INF viewer.
:li.Saving the best for last - INF files are searchable by the viewer.  You
can search the entire INF file, and even other INF files from within the
viewer.  This cannot be done with html - some kind of search engine is
required, and it is invariably slow and hard to set up, and takes up even
more memory.  This was actually my main motivation for generating javadoc
documentation in INF format - no more browsing through endless package trees
looking for that one class that I can't quite remember the name of.
:eol.

:p.To view INF files on os/2, one simply runs the view program, for example
:xmp.
view jdk12_java.inf
:exmp.
or double-clicks on them from the Workplace Shell.  For Windows, there are
two viewers.  The first, called oview, seems to be a Windows 3.1 program.  In
any case, it does not accept long filenames, and so will not work well with
the naming scheme I've chosen for the JDK documentation I've generated.
However, it is easily availabe from the Hobbes archive site&colon.
:xmp.
ftp&colon.//hobbes.nmsu.edu/pub/windows/win_inf.zip
:exmp.

The second, called iview, is available from IBM.  One place you can get it is
as part of the Object Rexx package.  It is also freely available from the
Developer Connection web site.  You only need guest access to get it, so it
is available to all.  The URL is&colon.
:xmp.
http&colon.//service2.boulder.ibm.com/devcon/showcase/cat/iview.htm
:exmp.

:p.One question you might be wondering is, why go with OS/2 help format,
instead of the more common Windows one?  Well, the first reason is I still
use OS/2 for my own Java development, so it's more useful for me personally.
Also, there is a native INF viewer for Windows, but Microsoft has never seen
fit to make a HLP viewer for OS/2.  However, the main reason is technical.
IPF documenation is a simple, text-based tagging format very similar to html.
In fact, many of the tags are identical.  Windows help format however, is
based on a bizarre misuse of the RTF document interchange format, which is
complex, and difficult to deal with.  I can't imagine what Microsoft was
thinking when they came up with this garbage, but there's no way I'm going to
waste my time trying to figure it out.  Life's too short to put up with that
crap!

:p.I've already used this tool to create INF documentation for JDK 1.2 APIs,
including Swing.  It should probably be available at the same place you got
this file, if not it's certainly on hobbes somewhere.  As you'll see in the
:link reftype=hd refid='Usage'.Usage:elink. section, it is possible to make
your own Javadoc documentation link with these files, so that links to your
classes' base classes will work.  If you think you can use this tool, head on
to the next section, :link reftype=hd
refid='Installation'.Installation:elink.

.********************************************************************************
:h1 name='Installation'.Installation
.********************************************************************************
:font facename='Tms Rmn' size=24x24.Installation:font facename='default' size=0x0.

:p.Installation is very simple.  Simply place the file IPFDoclet.class on
your classpath.  Also, there are several bitmap files shipped with this
archive.  These are needed when you compile the ipf source file to an inf
file.  They are only needed if you specify the -graphics option on the
javadoc command line.  These files are only needed at ipf compile time, not
when you are viewing the inf file - they are incorporated into the inf file
by the compiler.

:p.:link reftype=hd refid='Usage'.Next Section&colon. Usage:elink.

.********************************************************************************
:h1 name='Usage'.Usage
.********************************************************************************
:font facename='Tms Rmn' size=24x24.Usage:font facename='default' size=0x0.

:p.There are two steps to using this doclet.  The first is to run javadoc on
your source files to generate the ipf source code.  The second is to compile
the ipf source code to an inf file.  In order to do the second step, you will
have to have the IPFC compiler installed on your machine.  This comes as part
of the OS/2 Toolkit, which comes with the VisualAge for C++ compiler, and
also the Developer Connection CD series.  It is also available with the (now
obsolete) Borland compilers, which is the cheapest place to get it if you can
find an old copy.  There are instructions in the toolkit on how to install
and use the IPFC compiler.

:p.First of all, I will assume you are familiar with the use of javadoc to
generate documentation from your source code.  You normally run it with a
command line like&colon.
:xmp.
javadoc package1 package2 package3
:exmp.
:p.or&colon.
:xmp.
javadoc @packages
:exmp.
:p.where :hp1.packages:ehp1. is a file containing a list of all the packages
you want to document.  You may also specify individual class names, but I don't
recommend this, as it doesn't work out quite as nicely.

:p.In order to use the IPFDoclet, you must add the -doclet parameter to the
javadoc command line, for example&colon.
:xmp.
javadoc -doclet IPFDoclet @packages
:exmp.
:p.For this to work, the IPFDoclet.class file must be on the classpath.

:p.The IPFDoclet adds several command line options to javadoc.  They are
documented here&colon.

:parml tsize=15 break=fit compact.
:pt.-f <file>
:pd.Specifies the output file name.  For example, when compiling the JDK 1.2
base documentation, I specify "-f jdk12_base.ipf".  It's best to use the
extension IPF for the output file.
:pt.-title "title"
:pd.Specifies the title for the INF file.  The title is displayed in the
window frame when viewing the INF file.  If you do not specify it, a default
value will be used, since otherwise IPFC will give a compile-time warning.
:pt.-graphics
:pd.Requests that graphics be used in the IPF generated.  This will cause a
few graphic files to be used for headings in the class documentation.  This
generally looks better than without the graphics, but makes the file a bit
bigger.  If you specify this option, you will need the bmp files included in
this package to be in the current directory when you compile the IPF file.
:pt.-map <file>
:pd.See below for a description of the mapfile.  By default, it is assumed to
be in the current directory and to have the name javadoc.map.  There's no
real reason to change the name, but you might want to point to an existing
map file in another directory.
:eparml.

:p.The map file is used to allow a form of incremental javadoc generation.
Whenever IPFDoclet finds a link to a class or package that is not part of the
documentation it is generating, it needs to know what INF file that class or
package can be found in.  For example, in the hierarchy trees for each class,
there will always be, at least, a link to java.lang.Object.  The
documentation for this is normally found in jdk12_base.inf, a file that I
have generated for you already (available from hobbes archive site).
However, javadoc has no way of knowing this.

:p.So, to get around this problem, the mapping file has information in it
that lets IPFDoclet find classes in already generated INF files.  Included in
this package is a javadoc.map file that contains information for all of the
INF documentation I have prepared for you.  You should make sure that this
file is in the current directory whenever you run javadoc.  Each time you run
javadoc, it will update this file with any new classes you have processed.
So, you can split your javadoc documentation over several different files,
but the links between them should still work.  The links will be properly set
up even if you have not already downloaded and installed the other INF files.
Once you install them, the next time you view your own INF files, the links
will become active.  You do not have to recompile.

:p.Once you have the ipf file, you have to compile it.  If you have IPFC set
up properly, this is as simple as typing&colon.
:xmp.
ifpc /inf myfile.ipf
:exmp.
:p.At the end of this process, you will have your inf file!  Don't be surprised
if you see a lot of error messages from the compiler, especially messages
about font tags in tables.  These are to be expected, and won't affect the
output.  I may try to clean these up in a future version.

:p.One tip you may not know.  Once you have your inf file, you can invoke it
and do a search from the command line.  For example,
:xmp.
view jdk12_swing.inf JButton
:exmp.
:p.will open the jdk12_swing file, and automatically go to the JButton class
documentation.  The EPM and X2 editors use this facility to provide context
sensitive help - you can now easily add the JDK documentation to these
editors.

:p.:link reftype=hd refid='Enhancing IPFDoclet'.Next Section&colon. Enhancing IPFDoclet:elink.

.********************************************************************************
:h1 name='Enhancing IPFDoclet'.Enhancing IPFDoclet
.********************************************************************************
:font facename='Tms Rmn' size=24x24.Enhancing IPFDoclet :font facename='default' size=0x0.

:p.I have tried my best to make the output of IPFDoclet complete, and also to
make it look nice.  For example, Sun uses a lot of html tagging in it's
javadoc source - obviously this won't work in IPF.  However, the doclet
attempts to translate most of the common tags into IPF equivalents so, for
example, lists, <code> tags, etc. should all come out ok.

:p.However, I'm sure I've missed a few.  Also, the output generated does not
include all the information that the standard doclet provides.  For example,
there is no section in the summary listing methods inherited from base
classes, and there is no deprecated section.  This was a choice on my part -
I don't find I use those sections that much, so I didn't bother to put them
in.  However, if you want to, or want to change the format of the output,
I've included the complete source to IPFDoclet.  You are free to modify it as
you wish.

:p.The source isn't exactly the greatest example of object-oriented
programming that I've ever written.  In fact, it's not object-oriented at
all, all the methods are static, and there's only one class, IPFDoclet.
However, I've provided javadoc comments for all the methods, and there are
liberal comments through the text.  It shouldn't be too hard to figure out.

:p.:link reftype=hd database='IPFDoclet.inf' refid='IPFDoclet'.Click here to
link to the javadoc documentation for IPFDoclet:elink.
:euserdoc.
