/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.servlet.ServletException;
import org.apache.ajp.Ajp13;
import org.apache.ajp.tomcat4.Ajp13Connector;
import org.apache.ajp.tomcat4.Ajp13InputStream;
import org.apache.ajp.tomcat4.Ajp13Logger;
import org.apache.ajp.tomcat4.Ajp13OutputStream;
import org.apache.ajp.tomcat4.Ajp13Request;
import org.apache.ajp.tomcat4.Ajp13Response;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.http.BaseRequest;

final class Ajp13Processor
implements Lifecycle,
Runnable {
    private Ajp13Logger logger = new Ajp13Logger();
    private BaseRequest ajpRequest = new BaseRequest();
    private boolean available = false;
    private Ajp13Connector connector = null;
    private int debug = 0;
    private int id = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private Ajp13Request request = null;
    private Ajp13Response response = null;
    protected StringManager sm = StringManager.getManager((String)"org.apache.ajp.tomcat4");
    private Socket socket = null;
    private boolean started = false;
    private Bool stopped = new Bool(true);
    private Bool handlingRequest = new Bool(false);
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();

    public Ajp13Processor(Ajp13Connector connector, int id) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.id = id;
        this.request = (Ajp13Request)connector.createRequest();
        this.request.setConnector(connector);
        this.request.setConnector(connector);
        this.response = (Ajp13Response)connector.createResponse();
        this.response.setConnector(connector);
        this.threadName = "Ajp13Processor[" + connector.getPort() + "][" + id + "]";
        this.logger.setConnector(connector);
        this.logger.setName(this.threadName);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
        if (this.debug > 0 && socket != null) {
            this.logger.log(" An incoming request is being assigned");
        }
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        if (this.debug > 0 && socket != null) {
            this.logger.log("  The incoming request has been awaited");
        }
        return socket;
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    private void parseConnection(Socket socket) throws IOException, ServletException {
        if (this.debug >= 2) {
            this.logger.log("  parseConnection: address=" + socket.getInetAddress() + ", port=" + this.connector.getPort());
        }
        this.request.setServerPort(this.connector.getPort());
        this.request.setSocket(socket);
    }

    private void process(Socket socket) {
        Ajp13 ajp13 = new Ajp13();
        ajp13.setDebug(this.debug);
        Ajp13InputStream input = new Ajp13InputStream(ajp13);
        Ajp13OutputStream output = new Ajp13OutputStream(ajp13);
        this.response.setAjp13(ajp13);
        try {
            ajp13.setSocket(socket);
        }
        catch (IOException e) {
            this.logger.log("process: ajp13.setSocket", e);
        }
        boolean moreRequests = true;
        String expectedSecret = this.connector.getSecret();
        boolean needAuth = expectedSecret != null;
        while (moreRequests && !this.stopped.value()) {
            int status = 0;
            try {
                status = ajp13.receiveNextRequest(this.ajpRequest);
            }
            catch (IOException e) {
                this.logger.log("process: ajp13.receiveNextRequest", e);
            }
            if (needAuth) {
                String connSecret = ajp13.getSecret();
                if (connSecret == null) {
                    this.logger.log("Connection without password, tomcat is configured to require one");
                    break;
                }
                if (!connSecret.equals(expectedSecret)) {
                    this.logger.log("Connection with wrong password");
                    break;
                }
                needAuth = false;
            }
            if (this.stopped.value()) {
                if (this.debug <= 0) break;
                this.logger.log("process:  received request, but we're stopped");
                break;
            }
            if (status == -2 || status != 200) break;
            try {
                this.handlingRequest.set(true);
                this.request.setAjpRequest(this.ajpRequest);
                this.request.setResponse((Response)this.response);
                this.request.setStream((InputStream)((Object)input));
                this.response.setRequest((Request)this.request);
                this.response.setStream(output);
                if (this.debug > 0) {
                    this.logger.log("invoking...");
                }
                this.connector.getContainer().invoke((Request)this.request, (Response)this.response);
                if (this.debug > 0) {
                    this.logger.log("done invoking, finishing request/response....");
                }
                this.response.finishResponse();
                this.request.finishRequest();
                if (this.debug > 0) {
                    this.logger.log("finished handling request.");
                }
            }
            catch (Exception e) {
                this.logger.log("process: invoke", e);
            }
            this.ajpRequest.recycle();
            this.request.recycle();
            this.response.recycle();
            ajp13.recycle();
            this.handlingRequest.set(false);
        }
        try {
            ajp13.close();
        }
        catch (IOException e) {
            this.logger.log("process: ajp13.close", e);
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            this.logger.log("process: socket.close", e);
        }
        socket = null;
        if (this.debug > 0) {
            this.logger.log("process:  done");
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        while (!this.stopped.value()) {
            Socket socket = this.await();
            if (socket == null) continue;
            this.process(socket);
            this.connector.recycle(this);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("ajp13Processor.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("ajp13Processor.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    private void threadStart() {
        this.logger.log(this.sm.getString("ajp13Processor.starting"));
        this.stopped.set(false);
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.debug > 0) {
            this.logger.log(" Background thread has been started");
        }
    }

    private void threadStop() {
        this.logger.log(this.sm.getString("ajp13Processor.stopping"));
        this.stopped.set(true);
        this.assign(null);
        Object object = this.threadSync;
        synchronized (object) {
            try {
                if (this.handlingRequest.value()) {
                    if (this.debug > 0) {
                        this.logger.log("currentling handling a request, so waiting....");
                    }
                    this.threadSync.wait(5000L);
                } else if (this.debug > 0) {
                    this.logger.log("not currently handling a request, not waiting.");
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }

    private class Bool {
        private boolean b = false;

        Bool() {
        }

        Bool(boolean b) {
            this.b = b;
        }

        synchronized void set(boolean b) {
            this.b = b;
        }

        synchronized boolean value() {
            return this.b;
        }
    }
}

