/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.catalina.startup.UserConfig;
import org.apache.catalina.startup.UserDatabase;

public final class HomesUserDatabase
implements UserDatabase {
    private Hashtable homes = new Hashtable();
    private UserConfig userConfig = null;

    public String getHome(String user) {
        return (String)this.homes.get(user);
    }

    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    public Enumeration getUsers() {
        return this.homes.keys();
    }

    private void init() {
        String homeBase = this.userConfig.getHomeBase();
        File homeBaseDir = new File(homeBase);
        if (!homeBaseDir.exists() || !homeBaseDir.isDirectory()) {
            return;
        }
        String[] homeBaseFiles = homeBaseDir.list();
        int i = 0;
        while (i < homeBaseFiles.length) {
            File homeDir = new File(homeBaseDir, homeBaseFiles[i]);
            if (homeDir.isDirectory() && homeDir.canRead()) {
                this.homes.put(homeBaseFiles[i], homeDir.toString());
            }
            ++i;
        }
    }

    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
        this.init();
    }
}

