/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import org.apache.tomcat.util.buf.TimeStamp;
import org.apache.tomcat.util.threads.Reaper;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public final class Expirer
implements ThreadPoolRunnable {
    private int checkInterval = 60;
    private Reaper reaper;
    ExpireCallback expireCallback;
    static final int INITIAL_SIZE = 8;
    TimeStamp[] managedObjs = new TimeStamp[8];
    int managedLen = this.managedObjs.length;
    int managedCount = 0;
    private static final int dL = 0;

    public void addManagedObject(TimeStamp ts) {
        TimeStamp[] timeStampArray = this.managedObjs;
        synchronized (timeStampArray) {
            if (this.managedCount >= this.managedLen) {
                TimeStamp[] newA = new TimeStamp[2 * this.managedLen];
                System.arraycopy(this.managedObjs, 0, newA, 0, this.managedLen);
                this.managedObjs = newA;
                this.managedLen = 2 * this.managedLen;
            }
            this.managedObjs[this.managedCount] = ts;
            ++this.managedCount;
        }
    }

    private void debug(String s) {
        System.out.println("Expirer: " + s);
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public Object[] getInitData() {
        return null;
    }

    public void removeManagedObject(TimeStamp ts) {
        int i = 0;
        while (i < this.managedCount) {
            if (ts == this.managedObjs[i]) {
                TimeStamp[] timeStampArray = this.managedObjs;
                synchronized (timeStampArray) {
                    this.managedObjs[i] = this.managedObjs[this.managedCount - 1];
                    --this.managedCount;
                }
                return;
            }
            ++i;
        }
    }

    public void runIt(Object[] td) {
        long timeNow = System.currentTimeMillis();
        int i = 0;
        while (i < this.managedCount) {
            long timeIdle;
            long maxInactiveInterval;
            TimeStamp ts = this.managedObjs[i];
            if (ts != null && ts.isValid() && (maxInactiveInterval = ts.getMaxInactiveInterval()) >= 0L && (timeIdle = timeNow - ts.getLastAccessedTime()) >= maxInactiveInterval && this.expireCallback != null) {
                this.expireCallback.expired(ts);
            }
            ++i;
        }
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setExpireCallback(ExpireCallback cb) {
        this.expireCallback = cb;
    }

    public void start() {
        if (this.reaper == null) {
            this.reaper = new Reaper("Expirer");
            this.reaper.addCallback(this, this.checkInterval * 1000);
        }
        this.reaper.startReaper();
    }

    public void stop() {
        this.reaper.stopReaper();
    }

    public static interface ExpireCallback {
        public void expired(TimeStamp var1);
    }
}

