/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.sample.filechooser;

import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.sample.filechooser.FileChooserBeanGUI;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class FileChooserBean
extends JPanel {
    JButton chooseFileBtn;
    JTextField fileTextField;
    String chooserTitle;
    String approveTitle;
    FileFilter filter;
    boolean acceptFiles = true;
    boolean acceptDirs = true;

    public FileChooserBean() {
        this.initGui();
    }

    public void initGui() {
        new FileChooserBeanGUI().createGui(this);
    }

    public void addDocumentListener(DocumentListener dl) {
        this.fileTextField.getDocument().addDocumentListener(dl);
    }

    public void removeDocumentListener(DocumentListener dl) {
        this.fileTextField.getDocument().removeDocumentListener(dl);
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.fileTextField.setToolTipText(text);
    }

    public void setAcceptFiles(boolean acceptFiles) {
        this.acceptFiles = acceptFiles;
    }

    public boolean getAcceptFiles() {
        return this.acceptFiles;
    }

    public void setAcceptDirs(boolean acceptDirs) {
        this.acceptDirs = acceptDirs;
    }

    public boolean getAcceptDirs() {
        return this.acceptDirs;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setApproveTitle(String approveTitle) {
        this.approveTitle = approveTitle;
    }

    public String getApproveTitle() {
        return this.approveTitle;
    }

    public void setChooserTitle(String chooserTitle) {
        this.chooserTitle = chooserTitle;
    }

    public String getChooserTitle() {
        return this.chooserTitle;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public String getText() {
        return this.fileTextField.getText();
    }

    public void setText(String fileOrDir) {
        this.fileTextField.setText(fileOrDir);
    }

    public static void main(String[] args) {
        ApplicationHelper.Singleton().createFrameOn(new FileChooserBean()).show();
    }

    public void chooseFileBtn_actionPerformed(ActionEvent var0) {
        int result;
        JFileChooser fc = new JFileChooser(this.fileTextField.getText());
        if (this.getAcceptDirs() && this.getAcceptFiles()) {
            fc.setFileSelectionMode(2);
        } else if (this.getAcceptDirs() && !this.getAcceptFiles()) {
            fc.setFileSelectionMode(1);
        } else if (!this.getAcceptDirs() && this.getAcceptFiles()) {
            fc.setFileSelectionMode(0);
        }
        fc.setDialogTitle(this.getChooserTitle());
        if (this.filter != null) {
            fc.setFileFilter(this.filter);
        }
        if ((result = fc.showDialog(this, this.getApproveTitle())) == 0) {
            this.fileTextField.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }
}

