/*
 * Decompiled with CFR 0.152.
 */
package JCollections;

import JCollections.JArray;
import JCollections.JCollection;
import JCollections.JIterationFunc;
import JCollections.JSet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class JCollectionImp
implements JCollection,
Serializable {
    public abstract void add(Object var1);

    public abstract void rem(Object var1);

    public abstract int size();

    public abstract Enumeration enumerate();

    public void remAll() {
        this.minus(this);
    }

    public Object find(Object o) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj == null || !obj.equals(o)) continue;
            return o;
        }
        return null;
    }

    public Object findByIdentity(Object o) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj != o) continue;
            return o;
        }
        return null;
    }

    public void union(JCollection toAdd) {
        toAdd.forAll(new JIterationFunc(){

            public boolean func(Object o) {
                JCollectionImp.this.add(o);
                return false;
            }
        });
    }

    public void minus(JCollection toRemove) {
        toRemove.forAll(new JIterationFunc(){

            public boolean func(Object o) {
                JCollectionImp.this.rem(o);
                return false;
            }
        });
    }

    public boolean forAll(JIterationFunc jf) {
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!jf.func(obj)) continue;
            return true;
        }
        return false;
    }

    public void addAll(JCollection toAdd) {
        Enumeration en = toAdd.enumerate();
        while (en.hasMoreElements()) {
            this.add(en.nextElement());
        }
    }

    public void addAll(Enumeration en) {
        while (en.hasMoreElements()) {
            this.add(en.nextElement());
        }
    }

    public void addAll(Iterator en) {
        while (en.hasNext()) {
            this.add(en.next());
        }
    }

    public void addAll(Object[] o) {
        int n = 0;
        while (n < o.length) {
            this.add(o[n]);
            ++n;
        }
    }

    public JSet asSet() {
        JSet set = new JSet(this.size());
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            set.add(obj);
        }
        return set;
    }

    public JArray asJArray() {
        JArray set = new JArray(this.size() + 1);
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            set.add(obj);
        }
        return set;
    }

    public boolean contains(Object o) {
        return this.find(o) != null;
    }

    public Object[] asObjectArray() {
        Object[] res = new Object[this.size()];
        Enumeration e = this.enumerate();
        int n = 0;
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            res[n] = obj;
            ++n;
        }
        return res;
    }

    public Vector asVector() {
        Vector set = new Vector(this.size());
        Enumeration e = this.enumerate();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            set.addElement(obj);
        }
        return set;
    }
}

