/*
 * Decompiled with CFR 0.152.
 */
package Jack;

import JCollections.IntTable;
import Jack.ISymbolTranslator;
import Jack.PNonTermSet;
import Jack.PRuleBase;
import Jack.PSymbolTree;
import de.netcomputing.util.Tracer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class PSymbolNode
implements Serializable {
    static final long serialVersionUID = 7162125431330845065L;
    static int EMPTY = -1;
    static int ROOT = -2;
    transient IntTable connections = new IntTable(3);
    transient PSymbolTree otherTree = null;
    int id = EMPTY;
    int le = 0;
    boolean copyUp = false;
    static String empty = "";

    PSymbolNode() {
    }

    public void storeTo(DataOutput out, IntTable storedToID) {
        try {
            out.writeInt(this.hashCode());
            storedToID.put(this.hashCode(), Boolean.TRUE);
            if (this.otherTree == null) {
                out.writeByte(0);
            } else if (storedToID.fastGet(this.otherTree.hashCode()) != null) {
                out.writeByte(1);
                out.writeInt(this.otherTree.hashCode());
            } else {
                out.writeByte(2);
                this.otherTree.storeTo(out, storedToID);
            }
            if (this.connections == null) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                out.writeInt(this.connections.numberOfElements);
                out.writeInt(this.connections.keys.length);
                int n = 0;
                while (n < this.connections.keys.length) {
                    if (this.connections.keyAt(n) < 0) {
                        out.writeByte(3);
                    } else {
                        if (this.connections.valueAt(n) == null) {
                            out.writeByte(0);
                        } else if (storedToID.fastGet(this.connections.valueAt(n).hashCode()) != null) {
                            out.writeByte(1);
                            out.writeInt(this.connections.valueAt(n).hashCode());
                        } else {
                            out.writeByte(2);
                            ((PSymbolNode)this.connections.valueAt(n)).storeTo(out, storedToID);
                        }
                        out.writeInt(this.connections.keyAt(n));
                    }
                    ++n;
                }
            }
            out.writeInt(this.id);
            out.writeInt(this.le);
            out.writeBoolean(this.copyUp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFrom(DataInput in, IntTable storedToID) {
        try {
            int hcode = in.readInt();
            storedToID.put(hcode, this);
            byte sw = in.readByte();
            switch (sw) {
                case 0: {
                    this.otherTree = null;
                    break;
                }
                case 1: {
                    this.otherTree = (PSymbolTree)storedToID.fastGet(in.readInt());
                    break;
                }
                case 2: {
                    this.otherTree = new PSymbolTree();
                    this.otherTree.loadFrom(in, storedToID);
                }
            }
            sw = in.readByte();
            if (sw == 0) {
                this.connections = null;
            } else {
                int nelem = in.readInt();
                int len = in.readInt();
                this.connections = new IntTable(len);
                this.connections.numberOfElements = nelem;
                int n = 0;
                while (n < len) {
                    sw = in.readByte();
                    Object val = null;
                    switch (sw) {
                        case 0: {
                            int key = in.readInt();
                            this.connections.setKeyValuePrivileged(n, key, val);
                            break;
                        }
                        case 1: {
                            int code = in.readInt();
                            val = storedToID.fastGet(code);
                            int key = in.readInt();
                            this.connections.setKeyValuePrivileged(n, key, val);
                            break;
                        }
                        case 2: {
                            val = new PSymbolNode();
                            ((PSymbolNode)val).loadFrom(in, storedToID);
                            int key = in.readInt();
                            this.connections.setKeyValuePrivileged(n, key, val);
                            break;
                        }
                    }
                    ++n;
                }
            }
            this.id = in.readInt();
            this.le = in.readInt();
            this.copyUp = in.readBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        Tracer.This.println("PSymbolNode::readObject");
    }

    private void writeObject(ObjectOutputStream oo) throws IOException {
        oo.defaultWriteObject();
        Tracer.This.println("PSymbolNode::writeObject");
    }

    public PSymbolNode(int _id) {
        this.id = _id;
    }

    boolean isValidRuleEnd() {
        return this.id > 0;
    }

    boolean hasNonTerms() {
        return this.otherTree != null;
    }

    PSymbolNode match(int i) {
        return (PSymbolNode)this.connections.fastGet(i);
    }

    PNonTermSet computeNTSet(PRuleBase prb) {
        int[] e = this.connections.keys();
        PNonTermSet result = new PNonTermSet();
        int n = 0;
        while (n < e.length) {
            if (prb.isLeftHand(e[n])) {
                result.add(e[n]);
            }
            ++n;
        }
        return result;
    }

    int[] keys() {
        return this.connections.keys();
    }

    void printKeys(ISymbolTranslator st) {
        int[] e = this.keys();
        int n = 0;
        while (n < e.length) {
            Tracer.This.println(st.symbolFor(e[n]));
            ++n;
        }
    }
}

