/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import JCollections.JCollection;
import Jxe.AttributedTextLine;
import Jxe.TextDocument;
import Jxe.highlighters.JavaHighlighter;
import de.netcomputing.util.Tracer;
import java.awt.Point;
import java.io.File;
import java.io.InputStream;
import java.util.Vector;

public class DocumentStream
extends InputStream {
    public int docX;
    public int docY;
    TextDocument doc;
    boolean inComment = false;
    boolean inSlashComment = false;

    public static Vector ScanClassDefs(TextDocument doc) {
        DocumentStream ds = new DocumentStream(doc, 0, 0);
        return ds.findClassDefs();
    }

    public static StringBuffer FindJavaDoc(File file2, int y) {
        try {
            return new DocumentStream(new TextDocument(file2), 0, y + 1).findPrevJavaDoc();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            return new StringBuffer();
        }
    }

    public static String ScanClassDefFor(int actLine, TextDocument doc) {
        Vector v = DocumentStream.ScanClassDefs(doc);
        int n = v.size() - 1;
        while (n >= 0) {
            Object[] o = (Object[])v.elementAt(n);
            if ((Integer)o[0] < actLine) {
                return o[1].toString();
            }
            --n;
        }
        return null;
    }

    public static String ScanPackage(File f) {
        if (!f.getName().endsWith(".java") || !f.exists()) {
            return "";
        }
        return DocumentStream.ScanPackage(new TextDocument(f));
    }

    /*
     * WARNING - void declaration
     */
    public static int ScanLineForFirstInmportStatement(TextDocument doc) {
        String s;
        DocumentStream ds = new DocumentStream(doc, 0, 0);
        StringBuffer token = new StringBuffer(50);
        while (ds.readJavaToken(token) && !(s = token.toString()).equals("class") && !s.equals("interface")) {
            void var3_3;
            if (var3_3.equals("import")) {
                return ds.posY();
            }
            if (var3_3.equals("package")) {
                return ds.posY() + 1;
            }
            token.setLength(0);
        }
        return ds.posY();
    }

    /*
     * WARNING - void declaration
     */
    public static String ScanPackage(TextDocument doc) {
        String s;
        doc.insertLine(0, new AttributedTextLine("     "));
        DocumentStream ds = new DocumentStream(doc, 0, 0);
        StringBuffer token = new StringBuffer(200);
        String result = "";
        while (ds.readJavaToken(token) && !(s = token.toString()).equals("class") && !s.equals("interface")) {
            void var3_4;
            if (var3_4.equals("import")) {
                doc.remLineAt(0);
                return "";
            }
            if (var3_4.equals("package")) {
                int y = ds.docY;
                StringBuffer pack = new StringBuffer(30);
                do {
                    token.setLength(0);
                    if (!ds.readJavaToken(token)) {
                        doc.remLineAt(0);
                        return null;
                    }
                    if (token.toString().equals(";") || y != ds.docY) continue;
                    pack.append(token);
                } while (!token.toString().equals(";") && y == ds.docY);
                result = s = pack.toString();
                doc.remLineAt(0);
                return result;
            }
            token.setLength(0);
        }
        doc.remLineAt(0);
        return result;
    }

    public static String ScanImports(TextDocument doc, JCollection addTo) {
        return DocumentStream.ScanImports(doc, addTo, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String ScanImports(TextDocument doc, JCollection addTo, boolean exact) {
        String s;
        DocumentStream ds = new DocumentStream(doc, 0, 0);
        StringBuffer token = new StringBuffer(200);
        String result = null;
        while (ds.readJavaToken(token) && !(s = token.toString()).equals("class") && !s.equals("interface")) {
            StringBuffer pack;
            int y;
            void var5_6;
            if (var5_6.equals("import")) {
                y = ds.docY;
                pack = new StringBuffer(30);
                do {
                    token.setLength(0);
                    if (!ds.readJavaToken(token)) {
                        return null;
                    }
                    if (token.toString().equals(";") || y != ds.docY) continue;
                    pack.append(token);
                } while (!token.toString().equals(";") && y == ds.docY);
                if (!exact) {
                    if (pack.charAt(pack.length() - 1) != '*') {
                        int i = pack.toString().lastIndexOf(46);
                        if (i >= 0) {
                            s = pack.toString().substring(0, i);
                        }
                    } else {
                        pack.setLength(pack.length() - 2);
                        s = pack.toString();
                    }
                } else {
                    s = pack.toString();
                }
                addTo.add(s);
            } else if (s.equals("package")) {
                y = ds.docY;
                pack = new StringBuffer(30);
                do {
                    token.setLength(0);
                    if (!ds.readJavaToken(token)) {
                        return null;
                    }
                    if (token.toString().equals(";") || y != ds.docY) continue;
                    pack.append(token);
                } while (!token.toString().equals(";") && y == ds.docY);
                s = pack.toString();
                addTo.add(s);
                result = s;
            }
            token.setLength(0);
        }
        addTo.add("java.lang");
        return result;
    }

    public DocumentStream(TextDocument td, int posX, int posY) {
        this.doc = td;
        this.setPosition(posX, posY);
    }

    public StringBuffer findPrevJavaDoc() {
        StringBuffer res = new StringBuffer(200);
        return this.findPrevJavaDoc(res);
    }

    public StringBuffer findPrevJavaDoc(StringBuffer res) {
        int c = 0;
        int pc = 0;
        int ppc = 0;
        int orgY = this.posY();
        int lastLine = -1;
        int firstLine = 0;
        while ((c = this.readBackward()) >= 0) {
            if (pc == 47 && c == 42) {
                lastLine = this.posY();
            }
            if (ppc == 42 && pc == 42 && c == 47 && lastLine > 0) {
                firstLine = this.posY();
                break;
            }
            ppc = pc;
            pc = c;
        }
        if (Math.abs(lastLine - orgY) > 5) {
            return res;
        }
        boolean prevWasEmpty = false;
        int n = firstLine + 1;
        while (n >= 0 && n < this.doc.size() && n < lastLine) {
            String actLine = this.doc.lineAt(n).toString();
            int idx = actLine.indexOf(42);
            if (idx >= 0) {
                actLine = actLine.substring(idx + 1);
            }
            if ((actLine = actLine.trim()).startsWith("@")) {
                String wrd = "";
                idx = actLine.indexOf(32);
                if (idx < 0) {
                    idx = actLine.length();
                }
                wrd = actLine.substring(1, idx);
                actLine = "<br><strong>" + wrd + "</strong>" + actLine.substring(idx);
            }
            if (actLine.length() == 0) {
                actLine = null;
            } else {
                prevWasEmpty = false;
            }
            if (actLine != null) {
                if (n != lastLine - 1) {
                    res.append(actLine + " \n");
                } else {
                    res.append(actLine);
                }
            }
            ++n;
        }
        return res;
    }

    int findAboveFunHeaderLine(int startLine) {
        if (this.doc.getHighlighter() instanceof JavaHighlighter) {
            ((JavaHighlighter)this.doc.getHighlighter()).setDoc(this.doc);
            ((JavaHighlighter)this.doc.getHighlighter()).computeKlaDepth();
        }
        int n = startLine;
        while (n >= 0 && n < this.doc.size()) {
            if (this.doc.lineAt((int)n).kldepth == 1) break;
            --n;
        }
        if (n < 0) {
            return -1;
        }
        return n;
    }

    public Point searchFunctionHeader() {
        int line = this.posY();
        if ((line = this.findAboveFunHeaderLine(line)) < 0) {
            return null;
        }
        this.docY = line;
        this.docX = this.doc.lineAt(line).size();
        int ch = 0;
        int style = 0;
        do {
            ch = this.readBackwardWithStyle();
        } while ((style = ch >> 8) == JavaHighlighter.COMMENT || style == JavaHighlighter.LINECOMMENT || (ch &= 0xFF) != 125 && ch != 59 && ch != 255);
        this.read();
        this.read();
        if (ch < 0) {
            return null;
        }
        return new Point(this.docX, this.docY);
    }

    public TextDocument getDoc() {
        return this.doc;
    }

    public void setPosition(int x, int y) {
        this.docX = x;
        this.docY = y;
        this.inComment = false;
        this.inSlashComment = false;
    }

    public boolean readJavaToken(StringBuffer result) {
        return this.readJavaToken(result, false);
    }

    public Vector findClassDefs() {
        Vector<Object[]> result = new Vector<Object[]>(4);
        StringBuffer res = new StringBuffer(1000);
        String pack = "";
        do {
            res.setLength(0);
            this.readJavaToken(res, false);
            if (res.length() == 7 && res.charAt(0) == 'p' && "package".equals(res.toString())) {
                StringBuffer ptmp = new StringBuffer(30);
                int y = this.docY;
                do {
                    res.setLength(0);
                    if (!this.readJavaToken(res)) {
                        return null;
                    }
                    if (res.toString().equals(";") || y != this.docY) continue;
                    ptmp.append(res);
                } while (!res.toString().equals(";") && y == this.docY);
                pack = ptmp.toString();
                continue;
            }
            if (res.length() != 5 || res.charAt(0) != 'c' || !"class".equals(res.toString())) continue;
            res.setLength(0);
            Integer i = new Integer(this.posY());
            this.readJavaToken(res, false);
            if (res.length() <= 0 || !Character.isJavaIdentifierStart(res.charAt(0))) continue;
            if (pack.length() > 0) {
                result.addElement(new Object[]{i, pack + "." + res.toString()});
                continue;
            }
            result.addElement(new Object[]{i, res.toString()});
        } while (res.length() > 0);
        return result;
    }

    public boolean readJavaToken(StringBuffer result, boolean treatCommentsAsCode) {
        int len = result.length();
        if (!this.readToken(result) || result.length() == len) {
            return false;
        }
        int currLine = this.posY();
        if (!treatCommentsAsCode && result.charAt(len) == '/') {
            if (this.peekRight() == 42) {
                char c;
                result.append((char)this.read());
                do {
                    c = (char)this.read();
                    result.append(c);
                } while ((c != '*' || this.peekRight() != 47) && c >= '\u0000');
                result.append((char)this.read());
            } else if (this.peekRight() == 47) {
                int y = this.docY;
                while (y == this.docY && this.peekRight() >= 0) {
                    result.append((char)this.read());
                }
                this.readBackward();
            }
        } else {
            char ce = result.charAt(len);
            if (ce == '\"' || ce == '\'') {
                char c;
                char prev = ce;
                boolean n = false;
                do {
                    c = (char)this.read();
                    result.append(c);
                    prev = c;
                } while (c != '\uffff' && (c != ce || prev == '\\') && this.posY() == currLine);
                c = (char)this.read();
                result.append(c);
                this.readBackward();
            }
        }
        return this.peekRight() >= 0;
    }

    public boolean readToken(StringBuffer result) {
        this.skipWS();
        int c = this.read();
        if (Character.isJavaIdentifierStart((char)c)) {
            result.append((char)c);
            char peek = (char)this.peekRight();
            while (peek == '[' || peek == ']' || Character.isJavaIdentifierPart(peek)) {
                result.append((char)this.read());
                peek = (char)this.peekRight();
            }
        } else if (c >= 0) {
            result.append((char)c);
        }
        return c >= 0;
    }

    public void skipWS() {
        while (Character.isSpace((char)this.peekRight())) {
            this.read();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public void skipWSBackward() {
        block3: {
            char c;
            int c2;
            block2: {
                c2 = 32;
                if (!true) break block2;
                c = this.peekLeft();
                c2 = c;
                if (!Character.isSpace(c)) break block3;
            }
            do {
                this.readBackward();
                c = this.peekLeft();
                c2 = c;
            } while (Character.isSpace(c));
        }
    }

    public int peekRight() {
        int c = this.read();
        if (c >= 0) {
            this.readBackward();
        }
        return c;
    }

    public int endY() {
        return this.doc.size();
    }

    public int lastXSize() {
        return this.doc.lineAt(this.endY() - 1).size();
    }

    public int docStart() {
        return 0;
    }

    public int firstXStart() {
        return 0;
    }

    public int readIgnoreComments() {
        int res = 0;
        if (this.inComment) {
            int prev = 0;
            do {
                if ((res = this.read()) == 47 && prev == 42) {
                    this.inComment = false;
                    return this.readIgnoreComments();
                }
                if (res == 10) {
                    return res;
                }
                prev = res;
            } while (res >= 0);
            this.inComment = false;
            return res;
        }
        if (this.inSlashComment) {
            while (res != 10 && res >= 0) {
                res = this.read();
            }
            this.inSlashComment = false;
            return res;
        }
        res = this.read();
        if (res == 47) {
            int next = this.peekRight();
            if (next == 47) {
                this.inSlashComment = true;
                return this.readIgnoreComments();
            }
            if (next == 42) {
                this.inComment = true;
                this.read();
                return this.readIgnoreComments();
            }
        }
        return res;
    }

    public int readWithStyle() {
        if (this.docY >= this.endY() || this.docY == this.endY() - 1 && this.docX >= this.lastXSize()) {
            return -1;
        }
        if (this.docX >= this.doc.lineAt(this.docY).size()) {
            ++this.docY;
            if (this.docY >= this.doc.size()) {
                return -1;
            }
            this.docX = 0;
            return 10;
        }
        if (this.docX >= 0 && this.docY >= 0) {
            return (this.doc.styleAt(this.docX, this.docY) << 8) + this.doc.charAt(this.docX++, this.docY);
        }
        ++this.docX;
        return -1;
    }

    public int read() {
        if (this.docY >= this.endY() || this.docY == this.endY() - 1 && this.docX >= this.lastXSize()) {
            return -1;
        }
        if (this.docY < 0 || this.docX >= this.doc.lineAt(this.docY).size()) {
            ++this.docY;
            if (this.docY >= this.doc.size()) {
                return -1;
            }
            this.docX = 0;
            return 10;
        }
        if (this.docX >= 0 && this.docY >= 0) {
            return this.doc.charAt(this.docX++, this.docY);
        }
        ++this.docX;
        return -1;
    }

    public int readBackwardWithStyle() {
        if (this.docY < this.docStart() || this.docY == this.docStart() && this.docX < this.firstXStart()) {
            return -1;
        }
        if (this.docX <= 0) {
            --this.docY;
            if (this.docY < 0) {
                return -1;
            }
            this.docX = this.doc.lineAt(this.docY).size();
            return 10;
        }
        --this.docX;
        return (this.doc.styleAt(this.docX, this.docY) << 8) + this.doc.charAt(this.docX, this.docY);
    }

    public int readBackward() {
        if (this.docY < this.docStart() || this.docY == this.docStart() && this.docX < this.firstXStart()) {
            return -1;
        }
        if (this.docX <= 0) {
            --this.docY;
            if (this.docY < 0) {
                return -1;
            }
            this.docX = this.doc.lineAt(this.docY).size();
            return 10;
        }
        return this.doc.charAt(--this.docX, this.docY);
    }

    public char peekLeft() {
        this.readBackward();
        if (this.docY >= 0) {
            char result = this.doc.charAt(this.docX, this.docY);
            this.read();
            return result;
        }
        this.read();
        return '\uffff';
    }

    public char peekStyleLeft() {
        this.readBackward();
        if (this.docY >= 0) {
            char result = this.doc.styleAt(this.docX, this.docY);
            this.read();
            return result;
        }
        this.read();
        return '\u0000';
    }

    public int posX() {
        return this.docX;
    }

    public int posY() {
        return this.docY;
    }

    /*
     * WARNING - void declaration
     */
    public boolean findNext(String s, boolean ignoreCase, boolean wholeWord) {
        int c;
        if (s.length() == 0) {
            return true;
        }
        int sIdx = 0;
        char prevC = this.peekLeft();
        while ((c = this.read()) != -1 && sIdx < s.length()) {
            int n;
            void var5_6;
            if (var5_6 == s.charAt(sIdx) || ignoreCase && Character.toUpperCase((char)var5_6) == Character.toUpperCase(s.charAt(sIdx))) {
                if (sIdx == 0 && wholeWord && Character.isJavaIdentifierPart(prevC)) {
                    n = 0;
                    while (n < sIdx) {
                        this.readBackward();
                        ++n;
                    }
                    sIdx = 0;
                } else {
                    ++sIdx;
                }
            } else {
                n = 0;
                while (n < sIdx) {
                    this.readBackward();
                    ++n;
                }
                sIdx = 0;
            }
            if (wholeWord && sIdx >= s.length() && Character.isJavaIdentifierPart((char)this.peekRight())) {
                n = 0;
                while (n < sIdx) {
                    this.readBackward();
                    ++n;
                }
                sIdx = 0;
            }
            prevC = var5_6;
        }
        this.readBackward();
        return sIdx == s.length();
    }

    /*
     * WARNING - void declaration
     */
    public boolean findPrev(String s, boolean ignoreCase, boolean wholeWord) {
        int c;
        if (s.length() == 0) {
            return true;
        }
        int sIdx = s.length() - 1;
        int prevC = this.peekRight();
        while ((c = this.readBackward()) != -1 && sIdx >= 0) {
            void var5_6;
            sIdx = var5_6 == s.charAt(sIdx) || ignoreCase && Character.toUpperCase((char)var5_6) == Character.toUpperCase(s.charAt(sIdx)) ? (wholeWord && s.length() - 1 == sIdx && Character.isJavaIdentifierPart((char)prevC) ? s.length() - 1 : --sIdx) : s.length() - 1;
            if (sIdx < 0 && wholeWord && Character.isJavaIdentifierPart(this.peekLeft())) {
                sIdx = s.length() - 1;
            }
            prevC = var5_6;
        }
        if (this.docY >= 0) {
            this.read();
        }
        return sIdx == -1;
    }

    public int available() {
        int oldX = this.docX;
        int oldY = this.docY;
        int result = 0;
        while (this.read() != -1) {
            ++result;
        }
        this.docX = oldX;
        this.docY = oldY;
        return result;
    }

    public static void main(String[] arg) {
        TextDocument doc = new TextDocument();
        doc.init(null);
        doc.coreLoad(new File("g:\\j11\\classes11\\JWidgets\\JApplication.java"));
        Vector v = DocumentStream.ScanClassDefs(doc);
        int n = 0;
        while (n < v.size()) {
            Tracer.This.println(((Object[])v.elementAt(n))[1]);
            ++n;
        }
    }
}

