/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import JCollections.JUnsafeTable;
import Jxe.AttributedTextLine;
import Jxe.EditCanvas;
import Jxe.EditorExtension;
import Jxe.JXEOptions;
import Jxe.KeyHook;
import Jxe.KeyboardEvent;
import Jxe.TextDocument;
import JxeExtensions.ExtAppAction;
import JxeExtensions.ExtCommentSelection;
import JxeExtensions.ExtCopy;
import JxeExtensions.ExtCutCopy;
import JxeExtensions.ExtDelBackward;
import JxeExtensions.ExtDelCurrentLine;
import JxeExtensions.ExtDelForward;
import JxeExtensions.ExtEnd;
import JxeExtensions.ExtHome;
import JxeExtensions.ExtInsertEvt;
import JxeExtensions.ExtInsertString;
import JxeExtensions.ExtInsertTab;
import JxeExtensions.ExtLineCommentSelection;
import JxeExtensions.ExtLoad;
import JxeExtensions.ExtMarkBraces;
import JxeExtensions.ExtMoveCursor;
import JxeExtensions.ExtPaste;
import JxeExtensions.ExtRedo;
import JxeExtensions.ExtRefresh;
import JxeExtensions.ExtReturnAutoIndent;
import JxeExtensions.ExtSaveQuick;
import JxeExtensions.ExtStandardWordLeft;
import JxeExtensions.ExtStandardWordRight;
import JxeExtensions.ExtUnInsertTab;
import JxeExtensions.ExtUndo;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.application.IEditorHost;
import de.netcomputing.anyj.debugger.communication.BreakPoint;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IActor;
import de.netcomputing.anyj.jwidgets.IBuilderInstanceCreator;
import de.netcomputing.anyj.jwidgets.IPopupGetter;
import de.netcomputing.anyj.jwidgets.ISelectionProvider;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.JWScrollPane;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.ScrollerPanel;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.ServiceRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import netcomputing.tools.Platforms;
import plugins.DebuggerPlugin;

public class EditPanel
extends JWScrollPane
implements KeyListener,
IActor,
IBuilderInstanceCreator,
MouseMotionListener,
MouseListener,
ISelectionProvider {
    private EditCanvas ec;
    KeyHook keyHook;
    public static JUnsafeTable keyMap;
    int leftOffset = 10;
    Binder keyBinder = new Binder(this);
    Binder mouseBinder = new Binder(this);
    boolean once = false;
    boolean useBlit = false;
    boolean keypress = false;
    public static Dimension defaultSize;
    static char[] markerBuf;
    static Font markerFont;

    public void setMouseSelectable(boolean b) {
        this.ec.canSelectWithMouse = b;
    }

    public Binder binder() {
        return this.ec.binder();
    }

    public Binder binderKeyEvent() {
        return this.keyBinder;
    }

    public Binder binderMouseClick() {
        return this.mouseBinder;
    }

    public void setKeyHook(KeyHook keyHook) {
        this.keyHook = keyHook;
    }

    public KeyHook getKeyHook() {
        return this.keyHook;
    }

    public void initForBuilder() {
        this.init();
    }

    public int getLineHeight() {
        return this.ec.getLineHeight();
    }

    public Point docXYToScreen(int x, int y) {
        return this.ec.docXYToScreen(x, y);
    }

    protected void initCanvas() {
        this.ec = new EditCanvas();
        this.ec.par = this;
        this.add(this.ec);
    }

    public boolean isOpaque() {
        return false;
    }

    public EditCanvas getEditCanvas() {
        return this.ec;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void disableEditing() {
        this.setKeyHook(new KeyHook(){

            public boolean shouldProcessEvent(KeyEvent ke) {
                return false;
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
    }

    public void refreshFonts() {
        this.setFont(JXEOptions.StyleTable[0].font);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void init() {
        this.initCanvas();
        super.init();
        this.setBackground(JXEOptions.EditorBG);
        this.setForeground(Color.black);
        this.setLayout(new BorderLayout());
        this.ec.init();
        this.scrollbarVert().setLineIncrement(10);
        this.spv.setEditorMode(true);
        try {
            this.sph.addKeyListener(this);
            this.spv.addKeyListener(this);
            this.ec.addKeyListener(this);
            this.addKeyListener(this);
        }
        catch (Error ex) {
            this.sph.addKeyListener(this);
            this.spv.addKeyListener(this);
            this.ec.addKeyListener(this);
            this.addKeyListener(this);
        }
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        if (this.ec.font != null) {
            this.ec.calcSizeMap(Toolkit.getDefaultToolkit().getFontMetrics(this.ec.font));
        }
        this.spv.getSbar().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                ((EditPanel)EditPanel.this).ec.drawLineNos = true;
                EditPanel.this.ec.repaint();
            }

            public void mouseReleased(MouseEvent ev) {
                EditPanel.this.ec.repaint();
            }
        });
    }

    public Object actionMenuKey(Object arg, Object sen) {
        ((KeyEvent)arg).consume();
        return this.ec.actionMenuKey(arg, sen);
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.requestFocus();
    }

    public void pastFirstPaint() {
        if (this.ec.getDocument() != null && !this.once) {
            this.once = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditPanel.this.checkComponentValues();
                    EditPanel.this.ec.adjustPosition(EditPanel.this.ec.getDocument().cX(), EditPanel.this.ec.getDocument().cY());
                    EditPanel.this.repaint();
                    EditPanel.this.useBlit = true;
                }
            });
        }
    }

    protected void repaintComponent() {
        if (this.useBlit) {
            super.repaintComponent();
            if (this.comp.preferredSize().height < this.getHeight()) {
                this.repaint(0, this.comp.preferredSize().height, this.getWidth(), this.getHeight());
            }
            return;
        }
        int diffY = this.yOff() - this.prevY;
        int diffX = this.xOff() - this.prevX;
        if (diffX == 0 && diffY == 0) {
            return;
        }
        this.comp.repaint();
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public Object[] getDataSelection() {
        return this.ec.getDataSelection();
    }

    public void setPopUpGetter(IPopupGetter pg) {
        this.ec.popUpGetter = pg;
    }

    public void mouseClicked(MouseEvent e) {
        EditApp.SetLastSelectionProvider(this);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        JWMenuBar.ResetMenu();
        if (this.ec.canSelectWithMouse) {
            this.ec.getDocument().unsetSelection();
            Point pos = new Point();
            this.ec.characterFromXY(e.getX(), e.getY(), pos);
            this.ec.getDocument().moveCursorAbs(0, pos.y);
            this.ec.getDocument().moveCursorAbs(pos.x, pos.y);
            this.ec.getDocument().setSelectingPoint(0, pos.y);
            this.ec.dragMode = 3;
            this.ec.getDocument().setSelection(0, pos.y, 0, pos.y + 1);
            this.ec.requestFocus();
        } else {
            int idx = (this.ec.pixPos + e.getY()) / this.ec.charH;
            this.binderMouseClick().notifyTargets(new Point(0, idx));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.ec.canSelectWithMouse) {
            this.ec.mouseReleased(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.ec.canSelectWithMouse) {
            this.ec.dragMode = 3;
            this.ec.mouseDragged(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void setInitOffsets(int x, int y) {
        this.ec.setOffsetX(x);
        this.ec.setOffsetY(y);
    }

    public static void initKeyMap() {
        if (keyMap != null) {
            return;
        }
        keyMap = new JUnsafeTable();
        keyMap.put(new KeyboardEvent(false, false, false, false, 9), new ExtInsertTab());
        keyMap.put(new KeyboardEvent(false, false, false, false, 27), new ExtInsertString(""));
        keyMap.put(new KeyboardEvent(false, false, false, false, 10), new ExtReturnAutoIndent());
        keyMap.put(new KeyboardEvent(false, true, false, false, 36), new ExtHome());
        keyMap.put(new KeyboardEvent(true, true, false, false, 36), new ExtHome());
        keyMap.put(new KeyboardEvent(false, true, false, false, 35), new ExtEnd());
        keyMap.put(new KeyboardEvent(false, true, false, false, 75), new ExtDelCurrentLine());
        keyMap.put(new KeyboardEvent(true, true, false, false, 35), new ExtEnd());
        keyMap.put(new KeyboardEvent(false, true, false, false, 90), new ExtUndo());
        keyMap.put(new KeyboardEvent(false, false, true, false, 8), new ExtUndo());
        keyMap.put(new KeyboardEvent(false, true, false, false, 89), new ExtRedo());
        keyMap.put(new KeyboardEvent(true, true, false, false, 90), new ExtRedo());
        keyMap.put(new KeyboardEvent(false, false, false, false, 8), new ExtDelBackward());
        keyMap.put(new KeyboardEvent(false, false, false, false, 127), new ExtDelForward());
        keyMap.put(new KeyboardEvent(false, true, false, false, 82), new ExtRefresh());
        EditorExtension ed = new ExtInsertTab();
        keyMap.put(new KeyboardEvent(false, false, false, false, 9), ed);
        ed = new ExtUnInsertTab();
        keyMap.put(new KeyboardEvent(true, false, false, false, 9), ed);
        ed = new ExtCopy();
        keyMap.put(new KeyboardEvent(false, true, false, false, 155), ed);
        keyMap.put(new KeyboardEvent(false, true, false, false, 67), ed);
        ed = new ExtPaste();
        keyMap.put(new KeyboardEvent(true, false, false, false, 155), ed);
        keyMap.put(new KeyboardEvent(false, true, false, false, 86), ed);
        ed = new ExtCutCopy();
        keyMap.put(new KeyboardEvent(false, true, false, false, 88), ed);
        keyMap.put(new KeyboardEvent(true, false, false, false, 127), ed);
        ed = new ExtMoveCursor("up");
        keyMap.put(new KeyboardEvent(false, false, false, false, 38), ed);
        ed = new ExtMoveCursor("down");
        keyMap.put(new KeyboardEvent(false, false, false, false, 40), ed);
        ed = new ExtMoveCursor("left");
        keyMap.put(new KeyboardEvent(false, false, false, false, 37), ed);
        ed = new ExtMoveCursor("right");
        keyMap.put(new KeyboardEvent(false, false, false, false, 39), ed);
        ed = new ExtStandardWordRight();
        keyMap.put(new KeyboardEvent(false, true, false, false, 39), ed);
        keyMap.put(new KeyboardEvent(true, true, false, false, 39), ed);
        ed = new ExtStandardWordLeft();
        keyMap.put(new KeyboardEvent(false, true, false, false, 37), ed);
        keyMap.put(new KeyboardEvent(true, true, false, false, 37), ed);
        keyMap.put(new KeyboardEvent(false, true, false, false, 69), new ExtMarkBraces());
        keyMap.put(new KeyboardEvent(false, true, false, false, 77), new ExtCommentSelection());
        keyMap.put(new KeyboardEvent(false, true, false, false, 47), new ExtLineCommentSelection());
        keyMap.put(new KeyboardEvent(true, true, false, false, 47), new ExtLineCommentSelection());
        ed = new ExtSaveQuick();
        keyMap.put(new KeyboardEvent(false, true, false, false, 83), ed);
        ed = new ExtLoad();
        keyMap.put(new KeyboardEvent(false, true, false, false, 79), ed);
        keyMap.put(new KeyboardEvent(false, false, false, false, 114), new ExtAppAction("findNext"));
        keyMap.put(new KeyboardEvent(false, false, true, false, 115), new ExtAppAction("closeCurrentWindow"));
        keyMap.put(new KeyboardEvent(true, false, false, false, 114), new ExtAppAction("findPrev"));
        keyMap.put(new KeyboardEvent(false, false, false, false, 120), new ExtAppAction("toggleBreakpoint"));
        keyMap.put(new KeyboardEvent(false, true, false, false, 70), new ExtAppAction("localFind"));
        keyMap.put(new KeyboardEvent(false, false, true, false, 114), new ExtAppAction("localFind"));
        keyMap.put(new KeyboardEvent(false, false, false, false, 112), new ExtAppAction("findInIndex"));
        keyMap.put(new KeyboardEvent(false, true, false, false, 71), new ExtAppAction("gotoLineNumber"));
        keyMap.put(new KeyboardEvent(false, true, false, false, 32), new ExtAppAction("requestCompletion"));
        keyMap.put(new KeyboardEvent(false, true, false, false, 9), new ExtAppAction("requestCompletion"));
        keyMap.put(new KeyboardEvent(false, true, false, false, 68), new ExtAppAction("findInDir"));
        keyMap.put(new KeyboardEvent(false, false, false, false, 20), new ExtInsertString(""));
        if (Platforms.IsReallyLinux()) {
            keyMap.put(new KeyboardEvent(false, false, false, false, 123), new ExtInsertString("{"));
        }
    }

    public void requestFocus() {
        EditApp.SetLastSelectionProvider(this);
        this.ec.requestFocus();
    }

    public void add(PopupMenu pop) {
        this.ec.add(pop);
    }

    public void setDocument(TextDocument _doc) {
        _doc.setView(this.ec);
        _doc.binder = this.ec.getDocument().binder;
        _doc.binder.setOwner(_doc);
        this.ec.doc = _doc;
    }

    public boolean action(Event e, Object arg) {
        return e.target == this.ec && arg.equals("editScroll");
    }

    public void _checkLayout() {
        Dimension par = this.size();
        Dimension sl = this.spv.getPreferredSize();
        Dimension sb = this.sph.getPreferredSize();
        this.sph.setBounds(1, par.height - sb.height - 1, par.width - sl.width - 2, sb.height);
        this.spv.setBounds(par.width - sl.width - 1, 1, sl.width, par.height - 2 - sb.height);
        this.comp.setBounds(1 + this.leftOffset, 1, par.width - sl.width - 2 - this.leftOffset, par.height - sb.height - 2);
    }

    public void propagateAction(String selector, Object arg, Object sender) {
        IEditorHost host = EditFrame.Host().findEditHost(this);
        if (host != null) {
            NCApplication.PerformAction(host.getCurrentEditFrame(), selector, arg, sender);
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (KeyboardEvent.KEYDEBUG) {
            Tracer.This.println("keyPressed on EditPanel");
        }
        if (evt.isConsumed() || ServiceRegistry.LastKeyWasShortCut) {
            this.keypress = true;
            return;
        }
        if (evt.getKeyCode() > 0 || evt.getKeyChar() >= ' ') {
            this.keyTypeAction(evt);
            this.keypress = true;
        } else {
            this.keypress = false;
        }
    }

    public void keyTypeAction(KeyEvent evt) {
        EditorExtension ext;
        if (EditApp.MenuOpen || evt.getSource() instanceof JMenu || evt.getSource() instanceof JMenuBar || evt.getKeyCode() == 0 && evt.getKeyCode() == 32) {
            EditApp.App.getMainMenu().getSelectionModel().setSelectedIndex(-1);
            evt.consume();
            Tracer.This.println("Eaten");
            return;
        }
        if (KeyboardEvent.KEYDEBUG) {
            Tracer.This.println("processing on EditPanel");
        }
        if (this.keyHook != null && !this.keyHook.shouldProcessEvent(evt)) {
            Tracer.This.println("event eaten by keyHook");
            return;
        }
        if (Platforms.IsJDK14() && (evt.isConsumed() || evt.getKeyCode() == 0 && evt.getKeyChar() == ',')) {
            Tracer.This.println("event consumed");
            return;
        }
        TextDocument doc = this.ec.getDocument();
        int key = evt.getKeyCode();
        if (key == 16 || key == 18 || key == 20 || key == 17 || evt.isConsumed()) {
            if (KeyboardEvent.KEYDEBUG) {
                Tracer.This.println("event eaten here" + evt);
                Tracer.This.println("\t\t" + (key == 16));
                Tracer.This.println("\t\t" + (key == 18));
                Tracer.This.println("\t\t" + (key == 17));
                Tracer.This.println("\t\t" + evt.isConsumed());
            }
            return;
        }
        KeyboardEvent ke = new KeyboardEvent(evt);
        System.out.println("DBG:" + evt.getKeyChar());
        this.keyBinder.notifyTargets(evt);
        int oldSX = doc.selStartX();
        int oldSY = doc.selStartY();
        int oldEX = doc.selEndX();
        int oldEY = doc.selEndY();
        if (evt.isShiftDown()) {
            if (!doc.hasSelection()) {
                doc.setSelectingStartX(doc.cX());
                doc.setSelectingStartY(doc.cY());
            }
        } else {
            doc.isSelecting = false;
        }
        if (!((ext = (EditorExtension)keyMap.get(ke)) != null || evt.isControlDown() && (!evt.isShiftDown() || evt.getKeyCode() != 38 && evt.getKeyCode() != 40) || evt.isAltDown() || key != 37 && key != 39 && key != 38 && key != 40 && key != 34 && key != 33 && key != 34 && key != 36 && key != 35)) {
            switch (key) {
                case 36: {
                    if (evt.isControlDown()) {
                        doc.moveCursorAbs(0, 0);
                        break;
                    }
                    if (doc.cX() <= doc.getFirstCharX(doc.cY()) && doc.cX() != 0) {
                        doc.moveCursorAbs(0, doc.cY());
                        break;
                    }
                    doc.moveCursorAbs(doc.getFirstCharX(doc.cY()), doc.cY());
                    break;
                }
                case 35: {
                    if (evt.isControlDown()) {
                        doc.moveCursorAbs(doc.lineAt(doc.size() - 1).size(), doc.size() - 1);
                        break;
                    }
                    if (doc.cX() != doc.getLastCharX(doc.cY()) + 1) {
                        doc.moveCursorAbs(doc.getLastCharX(doc.cY()) + 1, doc.cY());
                        break;
                    }
                    doc.moveCursorAbs(doc.lineAt(doc.cY()).size(), doc.cY());
                    break;
                }
                case 33: {
                    doc.pageUp();
                    break;
                }
                case 34: {
                    doc.pageDown();
                    break;
                }
                case 38: {
                    doc.moveCursor(0, -1);
                    break;
                }
                case 40: {
                    doc.moveCursor(0, 1);
                    break;
                }
                case 37: {
                    doc.moveCursor(-1, 0);
                    break;
                }
                case 39: {
                    doc.moveCursor(1, 0);
                }
            }
            if (!evt.isShiftDown()) {
                doc.unsetSelection();
                doc.setSelectingStartX(-1);
                doc.setSelectingStartY(-1);
            }
            evt.consume();
        } else {
            ext = (EditorExtension)keyMap.get(ke);
            if (evt.getKeyChar() == '\uffff' && ext instanceof ExtInsertEvt) {
                return;
            }
            if (!evt.isConsumed()) {
                if (!(ext != null || evt.getKeyChar() < ' ' || evt.getKeyChar() >= '\u0100' || Character.toUpperCase(evt.getKeyChar()) >= 'A' && Character.toUpperCase(evt.getKeyChar()) <= 'Z' && evt.isAltDown() || (ext = (EditorExtension)keyMap.get(ke)) != null)) {
                    KeyboardEvent newKE = new KeyboardEvent(evt);
                    ext = new ExtInsertEvt();
                    keyMap.put(newKE, ext);
                }
                if (ext != null) {
                    doc.markUndoDiff();
                    evt.consume();
                    if (!ext.action(doc, ke)) {
                        if (this.keyHook != null) {
                            this.keyHook.keyTyped(evt);
                        }
                        if (Platforms.IsLinux()) {
                            Toolkit.getDefaultToolkit().sync();
                        }
                        return;
                    }
                } else {
                    return;
                }
            }
        }
        if (oldSX != doc.selStartX() || oldSY != doc.selStartY() || oldEX != doc.selEndX() || oldEY != doc.selEndY()) {
            doc.tv.lockUpdate(false);
        } else if (evt.isShiftDown()) {
            doc.tv.lockUpdate(false);
            if (evt.isControlDown() && (evt.getKeyCode() == 38 || evt.getKeyCode() == 40)) {
                if (doc.getSelectingStartY() > doc.cY()) {
                    doc.setSelection(0, doc.getSelectingStartY(), 0, doc.cY());
                } else {
                    doc.setSelection(0, doc.getSelectingStartY(), 0, doc.cY());
                }
            } else {
                doc.setSelection(doc.getSelectingStartX(), doc.getSelectingStartY(), doc.cX(), doc.cY());
            }
        }
        if (this.keyHook != null) {
            this.keyHook.keyTyped(evt);
        }
        evt.consume();
        if (Platforms.IsLinux()) {
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public void keyReleased(KeyEvent ke) {
        if (ke.isConsumed()) {
            return;
        }
        if (KeyboardEvent.KEYDEBUG) {
            Tracer.This.println("keyreleased on EditPanel:" + ke);
        }
        if (Platforms.IsReallyLinux() && ke.getKeyCode() == 9 && ke.isShiftDown() && !ke.isConsumed()) {
            if (KeyboardEvent.KEYDEBUG) {
                Tracer.This.println("SHIFT TAB RELEASED");
            }
            this.keyTypeAction(ke);
        }
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.isConsumed()) {
            return;
        }
        if (KeyboardEvent.KEYDEBUG) {
            Tracer.This.println("keytyped on EditPanel:" + ke);
        }
        if (!this.keypress && ke.getKeyChar() >= ' ' && !ServiceRegistry.LastKeyWasShortCut) {
            this.keyTypeAction(ke);
        }
        this.keypress = false;
    }

    public Dimension getPreferredSize() {
        return defaultSize;
    }

    public Dimension getMinimumSize() {
        return defaultSize;
    }

    public TextDocument getDocument() {
        return this.ec.getDocument();
    }

    void drawMarkers(Graphics g, boolean clearBack) {
        if (EditApp.App != null && EditApp.App.isInitalizing) {
            return;
        }
        TextDocument doc = this.getDocument();
        char[] cc = new char[]{'-'};
        int first = this.ec.pixPos;
        int left = 3;
        Dimension d = this.getSize();
        int tmp = this.ec.pixPos + d.height;
        int max = Math.min(tmp, doc.size() * this.ec.charH);
        g.clipRect(0, 2, 2 * this.ec.charW, d.height - 4 - ScrollerPanel.BARSIZE);
        g.setColor(Color.red);
        g.setFont(markerFont);
        int y = this.ec.pixPos;
        while (y < max) {
            AttributedTextLine li = doc.lineAt(y / this.ec.charH);
            g.clearRect(left, y - this.ec.pixPos + (this.ec.charH - this.ec.pixPos % this.ec.charH) - this.ec.charH, Math.max(8, this.ec.charW), Math.max(8, this.ec.charH));
            if (DebuggerPlugin.This() != null && doc.getFile() != null) {
                BreakPoint bp = DebuggerPlugin.This().getBreakPoint(doc.getFile().getAbsolutePath(), y / this.ec.charH);
                if (bp != null) {
                    Image im = null;
                    im = bp.getEnabled() ? NCApplication.GetImage("/de/netcomputing/anyj/images/bp.gif") : NCApplication.GetImage("/de/netcomputing/anyj/images/bpdis.gif");
                    g.drawImage(im, left, y - this.ec.pixPos + (this.ec.charH - this.ec.pixPos % this.ec.charH) - this.ec.charH + (this.ec.charH - 8) / 2, this);
                } else {
                    g.clearRect(left, y - this.ec.pixPos + (this.ec.charH - this.ec.pixPos % this.ec.charH) - this.ec.charH, this.ec.charW, this.ec.charH);
                }
            } else if (li.marker > ' ' || li.marker == '\u0001' || li.marker == '\u0002') {
                EditPanel.markerBuf[0] = li.marker == '\u0001' ? 45 : (li.marker == '\u0002' ? 43 : li.marker);
                g.drawChars(markerBuf, 0, 1, left, y - this.ec.pixPos + (this.ec.charH - this.ec.pixPos % this.ec.charH));
            } else if (li.mark != null) {
                g.drawChars(cc, 0, 1, left, y - this.ec.pixPos + (this.ec.charH - this.ec.pixPos % this.ec.charH));
            }
            y += this.ec.charH;
        }
    }

    public void jwPaint(Graphics g) {
        super.jwPaint(g);
        this.drawMarkers(g, true);
    }

    public void setFont(Font f) {
        this.ec.font = f;
        if (this.ec.getDocument() != null) {
            this.ec.getDocument().styles = JXEOptions.StyleTable;
        }
        this.ec.updateFontMetrics();
        this.ec.repaintAll();
        this.checkComponentValues();
        this.ec.calcSizeMap(this.getFontMetrics(f));
    }

    static {
        defaultSize = new Dimension(640, 200);
        markerBuf = new char[1];
        markerFont = new Font(JXEOptions.Monospaced, 1, 16);
    }
}

