/*
 * Decompiled with CFR 0.152.
 */
package Jxe.completers;

import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import Jxe.completers.BasicMLCompleter;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.dtd.DTD;
import de.netcomputing.util.dtd.DTDAny;
import de.netcomputing.util.dtd.DTDContainer;
import de.netcomputing.util.dtd.DTDElement;
import de.netcomputing.util.dtd.DTDItem;
import de.netcomputing.util.dtd.DTDName;
import de.netcomputing.util.dtd.DTDParser;
import editapp.EditApp;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class XmlCompleter
extends BasicMLCompleter {
    File dtdFile;
    HashMap elemOrWhatEverToComment = new HashMap(100);
    DTD dtd;
    DTDParser parser;
    static Object noDTD = new Object();

    public void setDtd(File dtdFile) {
        this.dtdFile = dtdFile;
        try {
            this.parser = new DTDParser(dtdFile);
            this.dtd = this.parser.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.parseDtd();
    }

    protected boolean shouldAddTag(int nestCount, String tag) {
        return nestCount == 0 && !tag.endsWith("/");
    }

    public File getDtd() {
        return this.dtdFile;
    }

    public void setContext(TextDocument doc) {
        if (doc.completionEngineContext instanceof XmlCompletionContext) {
            XmlCompletionContext ctx = (XmlCompletionContext)doc.completionEngineContext;
            this.dtdFile = ctx.dtdFile;
            this.elemOrWhatEverToComment = ctx.elemOrWhatEverToComment;
            this.dtd = ctx.dtd;
            this.parser = ctx.parser;
        } else if (doc.completionEngineContext == noDTD) {
            this.dtdFile = null;
            this.elemOrWhatEverToComment = null;
            this.dtd = null;
            this.parser = null;
        } else {
            this.findAndLoadDtd(doc);
        }
    }

    protected void findAndLoadDtd(TextDocument doc) {
        try {
            VFile dtdFile;
            DocumentStream ds = new DocumentStream(doc, 0, 0);
            if (ds.findNext("!DOCTYPE", true, true) && ds.findNext(".dtd", true, false)) {
                StringBuffer dtdName = new StringBuffer();
                char c = '\u0000';
                while ((c = (char)ds.readBackward()) > '\u0000' && c != '/' && c != '\\' && c != '\"' && c != '\'') {
                    dtdName.insert(0, c);
                }
                dtdFile = new VFile("#staticdata/dtds/" + dtdName);
                Tracer.This.println("DTD LOOKUP:" + dtdName);
                if (!dtdFile.exists()) {
                    if (EditFrame.Host().getCurrentEditFrame() != null) {
                        EditFrame.Host().setStatusText(EditFrame.Host().getCurrentEditFrame(), "File " + dtdFile.getAbsolutePath() + " not found, no assistance");
                    }
                    doc.completionEngineContext = noDTD;
                    dtdFile = null;
                    this.elemOrWhatEverToComment = null;
                    this.dtd = null;
                    this.parser = null;
                    return;
                }
            } else {
                if (EditFrame.Host().getCurrentEditFrame() != null) {
                    EditFrame.Host().setStatusText(EditFrame.Host().getCurrentEditFrame(), "!DOCTYPE not found, no assistance (please copy dtd file to [anyj]/bin/dtds)");
                }
                doc.completionEngineContext = noDTD;
                this.dtdFile = null;
                this.elemOrWhatEverToComment = null;
                this.dtd = null;
                this.parser = null;
                return;
            }
            this.setDtd(dtdFile);
            XmlCompletionContext ctx = new XmlCompletionContext();
            ctx.dtdFile = this.dtdFile;
            ctx.elemOrWhatEverToComment = this.elemOrWhatEverToComment;
            ctx.dtd = this.dtd;
            ctx.parser = this.parser;
            doc.completionEngineContext = ctx;
        }
        catch (Exception ex) {
            doc.completionEngineContext = noDTD;
            this.dtdFile = null;
            this.elemOrWhatEverToComment = null;
            this.dtd = null;
            this.parser = null;
            ex.printStackTrace(Tracer.This);
        }
    }

    public Vector findAttributesFor(String tagName) {
        if (this.dtd == null) {
            return null;
        }
        DTDElement elem = (DTDElement)this.dtd.elements.get(tagName);
        if (elem == null) {
            return null;
        }
        Vector v = new Vector(elem.attributes.keySet());
        return v;
    }

    public Vector findSubTagsFor(String tagName) {
        if (this.dtd == null) {
            return null;
        }
        DTDElement elem = (DTDElement)this.dtd.elements.get(tagName);
        if (elem == null) {
            return null;
        }
        DTDItem it = elem.content;
        Vector res = new Vector(10);
        if (it instanceof DTDContainer) {
            DTDContainer cnt = (DTDContainer)it;
            this.expandContainer(res, cnt, 0, new HashSet());
        } else if (it instanceof DTDAny) {
            res.addAll(this.dtd.elements.keySet());
        }
        return res;
    }

    void expandContainer(Vector res, DTDContainer cont, int count, HashSet checked) {
        if (count > 5) {
            return;
        }
        Vector v = cont.getItemsVec();
        int i = 0;
        while (i < v.size()) {
            DTDItem it = (DTDItem)v.get(i);
            if (it instanceof DTDContainer) {
                if (!checked.contains(it)) {
                    checked.add(it);
                    this.expandContainer(res, (DTDContainer)it, count + 1, checked);
                }
            } else if (it instanceof DTDName) {
                res.add(((DTDName)it).value);
            }
            ++i;
        }
    }

    public void parseDtd() {
        TextDocument doc = new TextDocument(this.dtdFile);
        DocumentStream ds = new DocumentStream(doc, 0, 0);
        StringBuffer tok = new StringBuffer(100);
        StringBuffer lastComment = new StringBuffer(100);
        while (true) {
            if (tok.length() > 0) {
                int i = 0;
                while (i < tok.length()) {
                    if (Character.isLetter(tok.charAt(i))) {
                        tok.setLength(0);
                        break;
                    }
                    ++i;
                }
            }
            if (!ds.readToken(tok)) break;
            String token = tok.toString();
            if (token.indexOf("<!ELEMENT") >= 0) {
                tok.setLength(0);
                ds.readToken(tok);
                String elementName = tok.toString();
                while (!Character.isWhitespace((char)ds.peekRight())) {
                    elementName = elementName + (char)ds.read();
                }
                String comment = NCStringUtilities.Replace(lastComment.toString(), "<", "&lt;");
                comment = NCStringUtilities.Replace(comment, ">", "&gt;");
                comment = NCStringUtilities.Replace(comment, "  ", "&nbsp;");
                comment = NCStringUtilities.Replace(comment, "\n", "<br>");
                comment = "<html><h3>Element " + elementName + "</h3>" + comment + "</html";
                this.elemOrWhatEverToComment.put(elementName, comment);
                tok.setLength(0);
                continue;
            }
            if (token.indexOf("<!--") < 0) continue;
            lastComment.setLength(0);
            lastComment.append(token.substring(token.indexOf("<!--") + 4));
            lastComment.append(" ");
            int c = ds.read();
            while ((c != 45 || ds.peekRight() != 62) && c >= 0) {
                lastComment.append((char)c);
                c = ds.read();
            }
            tok.setLength(0);
        }
    }

    public Vector completeOnTagOpen(TextDocument doc) {
        Vector v = this.findLastOpenTags(doc);
        if (v.size() > 0) {
            String tag = v.get(0).toString();
            if (tag.endsWith(">")) {
                tag = tag.substring(0, tag.length() - 1);
            }
            if (!this.existsTag(tag) && (tag = v.get(1).toString()).endsWith(">")) {
                tag = tag.substring(0, tag.length() - 1);
            }
            Tracer.This.println("DETECT TAG:" + tag);
            Tracer.This.println("SIZE:" + v.size());
            if (!this.existsTag(tag)) {
                return this.findTopLevelTags();
            }
            return this.findSubTagsFor(tag);
        }
        return this.findTopLevelTags();
    }

    public boolean existsTag(String tag) {
        if (this.dtd == null) {
            return false;
        }
        return this.dtd.elements.get(tag) != null;
    }

    public Vector findTopLevelTags() {
        Vector res = new Vector(20);
        if (this.dtd != null) {
            res.addAll(this.dtd.elements.keySet());
        }
        return res;
    }

    protected void showTagDoc(final String tag) {
        if (this.elemOrWhatEverToComment.get(tag) != null) {
            EditApp.App.doLazy(new Runnable(){

                public void run() {
                    EditApp.App.agent.createAndShowTempFile(XmlCompleter.this.elemOrWhatEverToComment.get(tag).toString());
                }
            });
        }
    }

    public Vector keyTyped(StringBuffer typedContext, KeyEvent e, TextDocument doc) {
        Vector res = this.internalKeyTyped(typedContext, e, doc);
        if (res != null) {
            res.add("zzzzzzz");
        }
        return res;
    }

    public boolean canComplete() {
        return this.dtd != null;
    }

    public Vector internalKeyTyped(StringBuffer typedContext, KeyEvent e, TextDocument doc) {
        this.setContext(doc);
        if (!this.canComplete()) {
            return super.keyTyped(typedContext, e, doc);
        }
        if (typedContext.length() >= 1) {
            if (typedContext.charAt(typedContext.length() - 1) == '/' && doc.cX() > 1 && doc.charAt(doc.cX() - 2, doc.cY()) == '<') {
                typedContext.setLength(0);
                return this.findLastOpenTags(doc);
            }
            if (typedContext.charAt(typedContext.length() - 1) == '<') {
                return this.completeOnTagOpen(doc);
            }
            if (typedContext.charAt(typedContext.length() - 1) == '=') {
                typedContext.setLength(0);
                return null;
            }
        }
        if (e.getKeyCode() == 32 && !e.isControlDown() && !e.isAltDown()) {
            String tag = this.findIfInTag(doc);
            if (tag == null) {
                return null;
            }
            typedContext.setLength(0);
            this.showTagDoc(tag);
            return this.findAttributesFor(tag);
        }
        typedContext.setLength(0);
        return null;
    }

    public Vector explicitCompletionRequest(TextDocument doc) {
        Vector res = this.internalExplicitCompletionRequest(doc);
        if (res != null && res.size() == 1) {
            res.add("zzzzzzz");
        }
        return res;
    }

    public Vector internalExplicitCompletionRequest(TextDocument doc) {
        this.setContext(doc);
        if (!this.canComplete()) {
            return super.explicitCompletionRequest(doc);
        }
        String compWord = doc.completionWordAsString();
        if (compWord.equals("<")) {
            return this.completeOnTagOpen(doc);
        }
        String tag = this.findIfInTag(doc);
        if (tag == null) {
            return super.explicitCompletionRequest(doc);
        }
        this.showTagDoc(tag);
        return this.completeOnTagOpen(doc);
    }

    public void clientCompleted(String match) {
        this.showTagDoc(match);
    }

    public static void main(String[] args) {
        XmlCompleter cp = new XmlCompleter();
        cp.setDtd(new File("D:\\work\\anyj\\incoming\\dtd\\weblogic-ejb-jar.dtd"));
        Vector v = cp.findAttributesFor("entity-descriptor");
        int i = 0;
        while (i < v.size()) {
            System.out.println("   " + v.get(i));
            ++i;
        }
        System.out.println("SUBTAGS entity-descriptor");
        v = cp.findSubTagsFor("entity-descriptor");
        int i2 = 0;
        while (i2 < v.size()) {
            System.out.println("   " + v.get(i2));
            ++i2;
        }
        System.exit(-1);
    }

    static class XmlCompletionContext {
        File dtdFile;
        HashMap elemOrWhatEverToComment = new HashMap(100);
        DTD dtd;
        DTDParser parser;

        XmlCompletionContext() {
        }
    }
}

