/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import Jxe.TextDocument;
import Jxe.highlighters.JavaHighlighter;
import de.netcomputing.anyj.AJExtractMethodGUI;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCEditor;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.anyj.parsing.ExtractMethod;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AJExtractMethod
extends NCPanel {
    JTextField nameTxt;
    JRadioButton privateRadio;
    JRadioButton protectedRadio;
    JRadioButton publicRadio;
    NCEditor editor;
    NCTreeBean argList;
    NCButton downBtn;
    NCButton upBtn;
    NCButton cancelBtn;
    NCButton applyBtn;
    ButtonGroup grp;
    TextDocument doc;
    ExtractMethod em;

    public static void DoExtractMethod(TextDocument doc) {
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Extract Method", true);
        AJExtractMethod ajem = new AJExtractMethod();
        dlg.getContentPane().add(ajem);
        ajem.init(doc);
        dlg.pack();
        dlg.setSize(640, 400);
        ApplicationHelper.Singleton().centerWindow(dlg);
        ajem.getRootPane().setDefaultButton(ajem.applyBtn);
        dlg.setVisible(true);
    }

    public AJExtractMethod() {
        this.initGui();
        this.grp = new ButtonGroup();
        this.grp.add(this.publicRadio);
        this.grp.add(this.protectedRadio);
        this.grp.add(this.privateRadio);
        this.argList.addTarget(this, "actionListSel");
        DocumentListener tl = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                AJExtractMethod.this.updatePreview();
            }

            public void removeUpdate(DocumentEvent e) {
                AJExtractMethod.this.updatePreview();
            }

            public void changedUpdate(DocumentEvent e) {
                AJExtractMethod.this.updatePreview();
            }
        };
        this.nameTxt.getDocument().addDocumentListener(tl);
        this.validateButtons();
        this.nameTxt.requestFocus();
        this.nameTxt.selectAll();
    }

    public Object actionListSel(Object arg, Object sen) {
        this.validateButtons();
        return null;
    }

    void validateButtons() {
        int i = this.argList.getSelectionIndex();
        this.upBtn.setEnabled(i > 0);
        this.downBtn.setEnabled(i >= 0 && i < this.argList.listSize() - 1);
    }

    public void initGui() {
        new AJExtractMethodGUI().createGui(this);
        this.editor.setEnabled(true);
    }

    TextDocument updatePreview() {
        String modif = "";
        if (this.privateRadio.isSelected()) {
            modif = "private ";
        } else if (this.publicRadio.isSelected()) {
            modif = "public ";
        } else if (this.protectedRadio.isSelected()) {
            modif = "protected ";
        }
        TextDocument doc = this.em.prepareDocument(this.nameTxt.getText(), modif);
        this.editor.setDocument(doc);
        this.editor.getDocument().setReadOnly(true);
        doc.setHighlighter(new JavaHighlighter());
        doc.highlightAll();
        doc.setHiLightWord(this.nameTxt.getText());
        doc.setHilightWordMatchCase(true);
        this.editor.repaint();
        return doc;
    }

    public void init(TextDocument aDoc) {
        try {
            this.doc = aDoc;
            this.em = new ExtractMethod(this.doc);
            this.em.parseAndInit();
            this.updatePreview();
            int i = 0;
            while (i < this.em.getArgList().size()) {
                this.argList.addLine(this.em.getArgList().get(i));
                ++i;
            }
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace();
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void protectedRadio_itemStateChanged(ItemEvent var0) {
        this.updatePreview();
    }

    public void publicRadio_itemStateChanged(ItemEvent var0) {
        this.updatePreview();
    }

    public void privateRadio_itemStateChanged(ItemEvent var0) {
        this.updatePreview();
    }

    public void downBtn_actionPerformed(ActionEvent var0) {
        this.argList.moveSelDown();
        this.updateArgList();
        this.updatePreview();
    }

    public void upBtn_actionPerformed(ActionEvent var0) {
        this.argList.moveSelUp();
        this.updateArgList();
        this.updatePreview();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((JDialog)this.getTopLevelAncestor()).dispose();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        this.em.doInsert(this.updatePreview());
        ((JDialog)this.getTopLevelAncestor()).dispose();
    }

    void updateArgList() {
        Vector v = this.em.getArgList();
        v.setSize(0);
        int i = 0;
        while (i < this.argList.listSize()) {
            v.addElement(((BasicListItem)this.argList.at(i)).getDisplayString());
            ++i;
        }
    }
}

