/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JWVFile.VFile;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJDeploymentMultiplexer;
import de.netcomputing.anyj.AJNewWorkspaceDialogGUI;
import de.netcomputing.anyj.AJRunDebug;
import de.netcomputing.anyj.application.JDialog;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import jxeplugins.FileSetupEntry;
import jxeplugins.IApplicationWizard;

public class AJNewWorkspaceDialog
extends NCPanel
implements WindowListener {
    NCButton okBtn;
    NCButton cancelBtn;
    PropertyFileSel locationTxt;
    JTextArea description;
    NCTreeBean listPanel;
    public static boolean BeSilent = false;

    public static AJNewWorkspaceDialog CreateFrame(boolean show) {
        JFrame frame = new JFrame();
        AJNewWorkspaceDialog panel = new AJNewWorkspaceDialog();
        frame.getContentPane().add("Center", panel);
        frame.addWindowListener(panel);
        frame.pack();
        frame.setVisible(show);
        return panel;
    }

    public static AJNewWorkspaceDialog CreateDialog(Frame parent, boolean modal, boolean show) {
        JDialog dialog = new JDialog(parent, modal);
        AJNewWorkspaceDialog panel = new AJNewWorkspaceDialog();
        dialog.getContentPane().add("Center", panel);
        dialog.addWindowListener(panel);
        dialog.pack();
        dialog.setVisible(show);
        return panel;
    }

    public AJNewWorkspaceDialog() {
        this.initGui();
    }

    public void initGui() {
        new AJNewWorkspaceDialogGUI().createGui(this);
        this.okBtn.setMnemonic('O');
        this.cancelBtn.setMnemonic('C');
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public JDialog getDialog() {
        return (JDialog)this.getTopLevelAncestor();
    }

    public void init() {
        this.okBtn.setEnabled(false);
        this.locationTxt.setText("");
        this.locationTxt.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                AJNewWorkspaceDialog.this.okBtn.setEnabled(AJNewWorkspaceDialog.this.isOKEnabled());
            }
        });
        this.locationTxt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AJNewWorkspaceDialog.this.okBtn.setEnabled(AJNewWorkspaceDialog.this.isOKEnabled());
            }
        });
        this.listPanel.addTarget(this, "actionSelChange");
        this.cancelBtn.addTarget(this, "actionCancel");
        this.okBtn.addTarget(this, "actionOk");
        ((Window)this.getFrame()).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Window)AJNewWorkspaceDialog.this.getFrame()).dispose();
            }
        });
        this.fillTemplateBox();
        this.okBtn.setDefaultCapable(true);
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.okBtn);
        }
    }

    public void fillTemplateBox() {
        Vector v = EditApp.App.getRegisteredWizards();
        int n = 0;
        while (n < v.size()) {
            final IApplicationWizard wiz = (IApplicationWizard)v.elementAt(n);
            this.listPanel.addItem(new ListItem(wiz){

                public String getDisplayString() {
                    return wiz.getName();
                }

                public Image getImage() {
                    return wiz.getSmallIconImage();
                }
            });
            ++n;
        }
    }

    public boolean isOKEnabled() {
        return this.listPanel.getSelectedItem() != null && this.locationTxt.getText().trim().length() > 0;
    }

    public Object actionOk(Object arg, Object sen) {
        ((Window)this.getFrame()).dispose();
        new Thread(){

            public void run() {
                String dir = AJNewWorkspaceDialog.this.locationTxt.getText().trim();
                String newDir = AJNewWorkspaceDialog.prepareWorkspace(dir);
                if (newDir == null) {
                    return;
                }
                ListItem item = (ListItem)AJNewWorkspaceDialog.this.listPanel.getSelectedItem();
                try {
                    new File(newDir).mkdirs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Confirm.UnModalMsg(EditApp.App.mainFrame, "Can't create", new String[]{"Unable to create the project's directory"});
                }
                if (item != null) {
                    boolean doCopy = item.getDisplayString().equals(EditApp.App.getName());
                    IApplicationWizard wiz = (IApplicationWizard)item.wrappedObject();
                    AJNewWorkspaceDialog.this.okBtn.setEnabled(false);
                    AJNewWorkspaceDialog.this.listPanel.setEnabled(false);
                    AJNewWorkspaceDialog.this.locationTxt.setEnabled(false);
                    AJNewWorkspaceDialog.createWSpaceFromWiz(newDir, wiz, doCopy);
                } else {
                    Confirm.UnModalMsg(EditApp.App.mainFrame, "No Selection", new String[]{"No valid project selected."});
                    AJNewWorkspaceDialog.this.description.setText("no selection");
                }
            }
        }.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean CreateWSpaceFromWiz(String newDir, IApplicationWizard wiz, boolean doCopy) {
        block3: {
            try {
                BeSilent = true;
                String s = AJNewWorkspaceDialog.prepareWorkspace(newDir);
                if (s == null) break block3;
                AJNewWorkspaceDialog.createWSpaceFromWiz(newDir, wiz, doCopy);
                boolean bl = true;
                Object var6_5 = null;
                BeSilent = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                BeSilent = false;
                throw throwable;
            }
        }
        Object var6_6 = null;
        BeSilent = false;
        return false;
    }

    static void createWSpaceFromWiz(String newDir, IApplicationWizard wiz, boolean doCopy) {
        String name = VFile.NameWithExtension(newDir);
        EditApp.App.changeProject(new File(newDir));
        EditApp.vstst = System.currentTimeMillis();
        FileSetupEntry fse = EditApp.App.getOptionsFor(newDir);
        fse = fse == null ? new FileSetupEntry() : fse.createCopy();
        fse.path = newDir;
        fse.isVisible = true;
        fse.doScan = false;
        fse.checkForChanges = false;
        fse.readOnly = false;
        fse.scanClasses = false;
        EditApp.App.addFileSetupEntry(fse, false, true);
        EditApp.App.setDebugOptions(null, fse.path, "java", null);
        if (!doCopy) {
            AJRunDebug.This.reset();
            AJDeploymentMultiplexer.This.reset();
            AJCompileAndBuild.This.reset();
        }
        if (!doCopy) {
            AJCompileAndBuild.This.getOutputTxt().setText("($workspaceDir)" + File.separator + "classes");
            AJCompileAndBuild.This.getClasspathTxt().setText(AJCompileAndBuild.This.getClasspathTxt().getText() + File.pathSeparator + "($outputdir)");
        }
        EditApp.App.setDebugClasspath("($classpath)");
        wiz.createProject(VFile.RemoveLast(newDir), name, EditApp.App, EditApp.App.getMainWindow());
        if (!doCopy) {
            AJCompileAndBuild.This.applyBtn_actionPerformed(null);
        }
        EditApp.App.setCompileClasspath(VFile.StripDoubleSeps(EditApp.App.getCompileClasspath(), File.pathSeparatorChar).toString());
        AJRunDebug.This.applyBtn_actionPerformed(null);
        AJCompileAndBuild.This.applyBtn_actionPerformed(null);
        EditApp.App.binderApplication().notifyTargets("ScanSourceChanged");
        EditApp.App.binderApplication().notifyTargets("VisibleSourceChanged");
        EditApp.App.jol.showProject();
    }

    static String prepareWorkspace(String dir) {
        String res;
        while (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String newDir = dir;
        String name = VFile.NameWithExtension(newDir);
        if (name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        if (name.endsWith(File.separator)) {
            name = name.substring(0, name.length() - 1);
        }
        if (new File(dir).exists() && !(res = Confirm.DoModal(EditApp.App.mainFrame, null, "Directory exists !", new String[]{"The directory " + dir + " already exists.", "The name of the workspace will be the last folder of", "the given path.", "Ensure you are not overwriting an existing project", "or create one in the wrong place by accident."}, new String[]{"Create anyway", "Abort"})).equals("Create anyway")) {
            return null;
        }
        if (newDir != null) {
            new File(newDir).mkdirs();
        }
        return newDir;
    }

    public Object actionCancel(Object arg, Object sen) {
        ((Window)this.getFrame()).dispose();
        return null;
    }

    public void setDir(String s) {
        this.locationTxt.setText(s);
    }

    public Object actionSelChange(Object arg, Object sen) {
        ListItem item = (ListItem)this.listPanel.getSelectedItem();
        if (item != null) {
            IApplicationWizard wiz = (IApplicationWizard)item.wrappedObject();
            this.description.setText(wiz.getDescription());
        } else {
            this.description.setText("no selection");
        }
        this.okBtn.setEnabled(this.isOKEnabled());
        return null;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }
}

