/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.DirIterator;
import JCollections.JArray;
import JCollections.JIterationFunc;
import JCollections.JUnsafeTable;
import JWVFile.VFile;
import Jxe.DocumentStream;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.AJMountDirPanel;
import de.netcomputing.anyj.AJWSpaceOptionsGUI;
import de.netcomputing.anyj.application.JDialog;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.SourceBase;
import editapp.ToolActionSetup;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import jxeplugins.FileSetupEntry;
import jxeplugins.JEBasicService;
import netcomputing.tools.PropWriter;
import plugins.JavacPlugin;

public class AJWSpaceOptions
extends NCPanel {
    PropertyFileSel fileTxt;
    NCButton removeBtn;
    NCButton cancelBtn;
    NCButton applyBtn;
    NCButton addBtn;
    NCButton sortBtn;
    JLabel dirLabel;
    NCCheckBox readOnlyChk;
    NCCheckBox scanChk;
    NCCheckBox visibleChk;
    NCCheckBox scanClassChk;
    NCCheckBox checkChk;
    NCButton downBtn;
    NCButton upBtn;
    NCTreeBean listPanel;
    Vector dirs = new Vector();
    public FileSetupEntry currSel = null;
    public static AJWSpaceOptions This;
    boolean direction;
    JUnsafeTable entryMap = new JUnsafeTable(300);

    public AJWSpaceOptions() {
        This = this;
        this.initGui();
    }

    public void initGui() {
        new AJWSpaceOptionsGUI().createGui(this);
        this.init();
        this.removeBtn.setMnemonic('R');
        this.addBtn.setMnemonic('A');
        this.applyBtn.setMnemonic('O');
        this.cancelBtn.setMnemonic('C');
        JEBasicService ser = null;
        ser = new JEBasicService("DirProperties", "Add to ClassPath", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (selection instanceof File && (((File)selection).isDirectory() || ((File)selection).getName().endsWith(".jar"))) {
                    String selString = ((File)selection).getAbsolutePath();
                    String cp = JavacPlugin.This().getClasspath().toUpperCase();
                    Vector v = NCFileUtilities.GetPathAsVector(cp);
                    this.setChecked(v.contains(selString.toUpperCase()));
                    return true;
                }
                return false;
            }

            public boolean isCheckable() {
                return true;
            }

            public boolean getShowInList() {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                String cp = JavacPlugin.This().getClasspath();
                String selString = ((File)selection).getAbsolutePath();
                if (this.isChecked()) {
                    Vector v = NCFileUtilities.GetPathAsVector(cp);
                    Vector v1 = NCFileUtilities.GetPathAsVector(cp.toUpperCase());
                    int idx = v1.indexOf(selString.toUpperCase());
                    if (idx >= 0) {
                        v.remove(idx);
                    }
                    String s = NCFileUtilities.GetVectorAsPath(v);
                    EditApp.App.setCompileClasspath(s);
                    this.setChecked(false);
                } else {
                    EditApp.App.addToCompileClasspath(((File)selection).getAbsolutePath());
                    this.setChecked(true);
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("DirProperties", "Add to SourcePath [Compile on Build]", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (selection instanceof File && ((File)selection).isDirectory()) {
                    String dir = ((File)selection).getAbsolutePath();
                    FileSetupEntry fse = AJWSpaceOptions.this.getOptionsFor(dir);
                    if (fse == null) {
                        return false;
                    }
                    if (fse.checkForChanges && !fse.path.equals(((File)selection).getAbsolutePath())) {
                        return false;
                    }
                    this.setChecked(fse.checkForChanges);
                    return true;
                }
                return false;
            }

            public boolean isCheckable() {
                return true;
            }

            public boolean getShowInList() {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJWSpaceOptions.this.addToSourcePathServiceUtility(this, selection, false);
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("DirProperties", "Add to SourcePath and Parse", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (selection instanceof File && ((File)selection).isDirectory()) {
                    String dir = ((File)selection).getAbsolutePath();
                    FileSetupEntry fse = AJWSpaceOptions.this.getOptionsFor(dir);
                    if (fse == null) {
                        return false;
                    }
                    if (fse.checkForChanges && !fse.path.equals(((File)selection).getAbsolutePath())) {
                        return false;
                    }
                    this.setChecked(fse.checkForChanges && fse.doScan);
                    return true;
                }
                return false;
            }

            public boolean isCheckable() {
                return true;
            }

            public boolean getShowInList() {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJWSpaceOptions.this.addToSourcePathServiceUtility(this, selection, true);
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("DirProperties", "Parse for Completion", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (selection instanceof File && (((File)selection).isDirectory() || ((File)selection).getName().endsWith(".jar"))) {
                    String dir = ((File)selection).getAbsolutePath();
                    FileSetupEntry fse = AJWSpaceOptions.this.getOptionsFor(dir);
                    if (fse == null) {
                        return false;
                    }
                    this.setChecked(fse.doScan());
                    return true;
                }
                return false;
            }

            public boolean isCheckable() {
                return true;
            }

            public boolean getShowInList() {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                String dir = ((File)selection).getAbsolutePath();
                FileSetupEntry fse = AJWSpaceOptions.this.getOptionsFor(dir);
                if (fse == null) {
                    return;
                }
                if (fse.path.equals(dir)) {
                    int i = AJWSpaceOptions.this.listPanel.findStringIgnoreCase(fse.path);
                    if (i >= 0) {
                        AJWSpaceOptions.this.listPanel.setSelectionIndex(i);
                        AJWSpaceOptions.this.listPanel.notifyTargets();
                        AJWSpaceOptions.this.scanChk.setSelected(!AJWSpaceOptions.this.scanChk.isSelected());
                    }
                    AJWSpaceOptions.this.actionApply(null, null);
                } else {
                    boolean bl = !(fse = fse.createCopy()).doScan();
                    fse.doScan = bl;
                    fse.path = dir;
                    fse.isVisible = false;
                    AJWSpaceOptions.this.addFileSetupEntry(fse, false, true);
                }
                this.setChecked(fse.doScan());
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("DirProperties", "Derive from parent", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (selection instanceof File && ((File)selection).isDirectory()) {
                    String dir = ((File)selection).getAbsolutePath();
                    FileSetupEntry fse = AJWSpaceOptions.this.getOptionsFor(dir);
                    if (fse == null) {
                        return false;
                    }
                    return fse.path.equals(dir) && !fse.isVisible;
                }
                return false;
            }

            public boolean getShowInList() {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                AJWSpaceOptions.this.remFileSetupEntry(((File)selection).getAbsolutePath(), false);
            }
        };
        EditApp.ServReg.addService(ser);
        this.actionListSel(null, null);
    }

    void addToSourcePathServiceUtility(final JEBasicService serv, final Object selection, final boolean alsoParse) {
        JWidgetsUtil.AddJob(new Runnable(){

            public void run() {
                String dir = ((File)selection).getAbsolutePath();
                FileSetupEntry fse = AJWSpaceOptions.this.getOptionsFor(dir);
                if (fse == null) {
                    return;
                }
                if (!fse.checkForChanges && AJWSpaceOptions.this.checkDirIsSourceRootInteractive(dir)) {
                    return;
                }
                if (fse.path.equals(dir)) {
                    int i = AJWSpaceOptions.this.listPanel.findStringIgnoreCase(fse.path);
                    if (i >= 0) {
                        AJWSpaceOptions.this.listPanel.setSelectionIndex(i);
                        AJWSpaceOptions.this.listPanel.notifyTargets();
                        AJWSpaceOptions.this.checkChk.setSelected(!serv.isChecked());
                        if (alsoParse) {
                            AJWSpaceOptions.this.scanChk.setSelected(!serv.isChecked());
                        }
                    }
                    AJWSpaceOptions.this.actionApply(null, null);
                } else {
                    fse = fse.createCopy();
                    if (alsoParse) {
                        fse.doScan = !serv.isChecked();
                    }
                    fse.checkForChanges = !serv.isChecked();
                    fse.path = dir;
                    fse.isVisible = false;
                    AJWSpaceOptions.this.addFileSetupEntry(fse, false, true);
                }
                if (alsoParse) {
                    serv.setChecked(fse.checkForChanges && fse.doScan);
                } else {
                    serv.setChecked(fse.checkForChanges);
                }
            }
        });
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public boolean isApplied() {
        return !this.applyBtn.isEnabled();
    }

    public void init() {
        this.fileTxt.setText("");
        this.upBtn.addTarget(this, "actionUp");
        this.downBtn.addTarget(this, "actionDown");
        this.sortBtn.addTarget(this, "actionSort");
        this.removeBtn.addTarget(this, "actionRemoveDir");
        this.listPanel.addKeyListener(new KeyFilter(127, this, "actionRemoveDir"));
        this.listPanel.addKeyListener(new KeyFilter(155, this, "actionChooseDirAndAdd"));
        this.applyBtn.addTarget(this, "actionApply");
        this.cancelBtn.addTarget(this, "actionCancel");
        this.listPanel.addTarget(this, "actionListSel");
        this.setApplyEnabled(false);
        this.setBackground(JWColor.For("background"));
        this.scanChk.addTarget(this, "actionChkChanged");
        this.readOnlyChk.addTarget(this, "actionChkChanged");
        this.scanClassChk.addTarget(this, "actionChkChanged");
        this.visibleChk.addTarget(this, "actionChkChanged");
        this.checkChk.addTarget(this, "actionChkChanged");
        this.listPanel.setPopUpGetter(EditApp.ServReg);
        this.listPanel.clear();
        this.removeBtn.setEnabled(false);
        this.setName("hidworkspace_options");
        this.freeMem();
        this.actionListSel(null, null);
    }

    public String getPossiblePackageFor(File dir, File toExclude) {
        return this.getPossiblePackageFor(dir, toExclude, true);
    }

    public String getPossiblePackageFor(File dir, File toExclude, boolean onlyScanable) {
        if (!dir.isDirectory()) {
            return null;
        }
        String result = "";
        try {
            Vector v = this.getDependencyCheckedDirs();
            int i = 0;
            while (i < v.size()) {
                String compdir = (String)v.get(i);
                if (dir.getAbsolutePath().startsWith(compdir)) {
                    String pack = dir.getAbsolutePath().substring(compdir.length());
                    while (pack.startsWith(File.separator) && pack.length() > 0) {
                        pack = pack.substring(1);
                    }
                    while (pack.endsWith(File.separator) && pack.length() > 0) {
                        pack = pack.substring(0, pack.length() - 1);
                    }
                    pack = pack.replace(File.separatorChar, '.');
                    return pack;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        String[] s = dir.list();
        if (s != null && s.length > 1) {
            int n = 0;
            while (n < s.length) {
                if (s[n].endsWith(".java") && !new File(dir, s[n]).equals(toExclude)) {
                    String pack = DocumentStream.ScanPackage(new File(dir.getAbsolutePath() + File.separator + s[n]));
                    return pack;
                }
                ++n;
            }
        }
        String dirname = dir.getAbsolutePath().toUpperCase();
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry entry = (FileSetupEntry)this.dirs.elementAt(n);
            if (entry.isVisible && (entry.doScan() || !onlyScanable) && dirname.startsWith(entry.path.toUpperCase())) {
                String pack = dir.getAbsolutePath().substring(entry.path.length());
                while (pack.length() > 0 && pack.startsWith(File.separator)) {
                    pack = pack.substring(1);
                }
                while (pack.length() > 0 && pack.endsWith(File.separator)) {
                    pack = pack.substring(0, pack.length() - 1);
                }
                pack = VFile.StripDoubleSeps(pack, File.separatorChar).toString();
                if ((pack = pack.replace(File.separatorChar, '.')).startsWith("source.")) {
                    pack = pack.substring("source.".length());
                }
                if (pack.startsWith("src.")) {
                    pack = pack.substring("src.".length());
                }
                return pack;
            }
            ++n;
        }
        if (onlyScanable) {
            return this.getPossiblePackageFor(dir, toExclude, false);
        }
        return "";
    }

    void setApplyEnabled(boolean b) {
        this.applyBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
        if (b && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.applyBtn);
        }
    }

    public Object actionToolSetup(Object arg, Object sen) {
        ToolActionSetup.EditTools((Window)this.getFrame());
        return null;
    }

    public Object actionSort(Object arg, Object sen) {
        this.listPanel.setSelectionIndex(-1);
        Vector v = this.listPanel.getList();
        if (this.direction) {
            JArray.QuickSort(new JArray(v), JArray.StringSortFunc());
        } else {
            JArray.QuickSort(new JArray(v), JArray.StringSortFuncInverse());
        }
        this.direction = !this.direction;
        this.listPanel.repaint();
        return null;
    }

    public Object actionUp(Object arg, Object sen) {
        if (this.listPanel.getSelectedObject() != null) {
            this.readFrom((FileSetupEntry)this.listPanel.getSelectedObject());
            this.listPanel.moveSelUp();
            this.setApplyEnabled(true);
        }
        return null;
    }

    public Object actionDown(Object arg, Object sen) {
        if (this.listPanel.getSelectedObject() != null) {
            this.readFrom((FileSetupEntry)this.listPanel.getSelectedObject());
            this.listPanel.moveSelDown();
            this.setApplyEnabled(true);
        }
        return null;
    }

    public void setAndClearProjectDirs(Vector newDirs) {
        JUnsafeTable alreadyIn = new JUnsafeTable(31);
        this.dirs = new Vector(newDirs.size() + 4);
        int n = 0;
        while (n < newDirs.size()) {
            if (alreadyIn.get(((FileSetupEntry)newDirs.elementAt((int)n)).path) == null) {
                this.dirs.addElement(newDirs.elementAt(n));
                alreadyIn.put(((FileSetupEntry)newDirs.elementAt((int)n)).path, Boolean.TRUE);
            }
            ++n;
        }
        this.readDirs();
        this.applyDirChanges(false);
    }

    public void readDirs() {
        Vector<FileSetupEntry> v = new Vector<FileSetupEntry>(this.dirs.size());
        int n = 0;
        while (n < this.dirs.size()) {
            v.addElement(((FileSetupEntry)this.dirs.elementAt(n)).createCopy());
            ++n;
        }
        this.listPanel.setList(v, 0.0, -1);
    }

    void writeDirs() {
        this.dirs = this.listPanel.getList();
        this.readDirs();
    }

    void addCurrentDir() {
        String sel = this.fileTxt.getText().trim();
        sel = VFile.GetOSCapitalization(sel);
        while (sel.length() > 3 && sel.endsWith(File.separator)) {
            sel = sel.substring(0, sel.length() - 1);
        }
        this.fileTxt.setText(sel);
        FileSetupEntry entry = new FileSetupEntry();
        entry.path = sel;
        this.addFileSetupEntry(entry, true, false);
        this.setApplyEnabled(true);
        this.listPanel.binder().notifyTargets(this.listPanel);
        this.selectOptionsFor(entry.path);
    }

    public Object actionChooseDirAndAdd(Object a, Object s) {
        String currentSel = this.fileTxt.getText().trim();
        this.listPanel.setSelectionIndex(-1);
        this.listPanel.notifyTargets();
        File sel = AJDirSelector.SelectDirModal((Window)this.getFrame(), null, "Please select a Directory", null, currentSel, ".zip;.jar");
        if (sel != null) {
            this.fileTxt.setText(sel.getAbsolutePath());
            this.addCurrentDir();
        }
        return null;
    }

    public Object actionChkChanged(Object a, Object s) {
        if (this.listPanel.getSelectionIndex() >= 0) {
            this.listPanel.repaint();
            this.setApplyEnabled(true);
        }
        return null;
    }

    public Object actionListSel(Object a, Object s) {
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        this.currSel = (FileSetupEntry)this.listPanel.getSelectedItem();
        if (this.currSel != null) {
            this.dirLabel.setText(this.currSel.path);
        } else {
            this.dirLabel.setText("");
        }
        NCCheckBox[] checks = new NCCheckBox[]{this.scanChk, this.readOnlyChk, this.scanClassChk, this.visibleChk, this.checkChk};
        if (this.currSel != null) {
            this.readFrom(this.currSel);
            int i = this.listPanel.getSelectionIndex();
            this.upBtn.setEnabled(i > 0);
            this.downBtn.setEnabled(i < this.listPanel.listSize() - 1);
            this.writeTo(this.currSel);
            int n = 0;
            while (n < checks.length) {
                checks[n].setEnabled(true);
                ++n;
            }
            if (this.currSel.path.endsWith(".jar") || this.currSel.path.endsWith(".zip")) {
                this.readOnlyChk.setEnabled(false);
                this.scanClassChk.setEnabled(false);
                this.scanClassChk.setSelected(true);
                this.checkChk.setSelected(false);
                this.checkChk.setEnabled(false);
            }
            this.removeBtn.setEnabled(true);
        } else {
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
            int n = 0;
            while (n < checks.length) {
                checks[n].setEnabled(false);
                ++n;
            }
            this.removeBtn.setEnabled(false);
        }
        return null;
    }

    public Object actionCancel(Object a, Object s) {
        this.readDirs();
        this.setApplyEnabled(false);
        this.selectOptionsFor(this.fileTxt.getText());
        this.actionListSel(null, null);
        return null;
    }

    public Object actionRemoveDir(Object a, Object s) {
        if (this.listPanel.getSelectedObject() != null) {
            this.listPanel.removeItemRepainting(this.listPanel.getSelectedItem());
            this.currSel = (FileSetupEntry)this.listPanel.getSelectedObject();
            if (this.currSel != null) {
                this.readFrom(this.currSel);
            }
            this.setApplyEnabled(true);
        }
        return null;
    }

    public boolean remFileSetupEntry(String dir, boolean subDirs) {
        this.actionApply(null, null);
        this.readDirs();
        int i = -1;
        i = !subDirs ? this.listPanel.findStringIgnoreCase(dir) : this.listPanel.findStringIgnoreCaseStarting(dir, 0);
        if (i >= 0) {
            this.dirs.removeElementAt(i);
            this.currSel = null;
            this.readDirs();
            this.actionApply(null, null);
            this.rebuildEntryMap();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDirIsSourceRootInteractive(final String path) {
        final JDialog conf = Confirm.UnModalMsg(EditApp.App.getMainWindow(), "Please Wait", new String[]{"Checking if directory is a valid SourceRoot ...      "}, new String[0]);
        final Object lock = new Object();
        final boolean[] abort = new boolean[]{false};
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
                Vector msg = NCFileUtilities.IsSourceRootDir(path, abort);
                conf.dispose();
                String[] msgString = new String[msg.size() + 4];
                msgString[0] = "Some file's package does not match the directory.";
                msgString[1] = "e.g. 'foo.bar.myclass should be located in";
                msgString[2] = "[mounted directory]/foo/bar/myclass.java.";
                msgString[3] = "";
                int i = 0;
                while (i < msg.size()) {
                    msgString[i + 4] = (String)msg.get(i);
                    ++i;
                }
                if (abort[0]) {
                    String res = Confirm.DoModal(EditApp.App.getMainWindow(), null, "Please specify a valid Source-Root", msgString, new String[]{"Cancel", "Mount Anyway"});
                    if (!"Cancel".equals(res)) {
                        abort[0] = false;
                    }
                } else if (msg.size() > 0) {
                    Confirm.ModalConfirm("Warning !", msgString);
                }
                Object object = lock;
                synchronized (object) {
                    try {
                        lock.notify();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                }
            }
        }.start();
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        return abort[0];
    }

    public void addFileSetupEntry(FileSetupEntry entry, boolean check, boolean autoApply) {
        while (entry.path != null && entry.path.endsWith(File.separator)) {
            entry.path = entry.path.substring(0, entry.path.length() - 1);
        }
        if (check && !entry.path.endsWith(".jar") && !entry.path.endsWith(".zip")) {
            String res = AJMountDirPanel.DoModal();
            Tracer.This.println("KULLE:1");
            if (res == null) {
                return;
            }
            entry.readOnly = false;
            entry.isVisible = true;
            if (res == null) {
                return;
            }
            if (res.equals("dir")) {
                entry.doScan = false;
                entry.scanClasses = false;
                entry.checkForChanges = false;
            } else if (res.equals("lib")) {
                entry.doScan = true;
                entry.scanClasses = false;
                entry.checkForChanges = false;
            } else if (res.equals("src")) {
                if (this.checkDirIsSourceRootInteractive(entry.path)) {
                    return;
                }
                entry.doScan = true;
                entry.scanClasses = false;
                entry.checkForChanges = true;
            }
        } else if (check) {
            entry.doScan = true;
            entry.isVisible = true;
        }
        this.listPanel.addItemRepainting(entry);
        int i = this.listPanel.findStringIgnoreCase(entry.path);
        if (i >= 0) {
            this.listPanel.setSelectionIndex(i);
            this.listPanel.notifyTargets();
        }
        this.currSel = null;
        if (autoApply) {
            this.actionApply(null, null);
        } else {
            this.setApplyEnabled(true);
        }
        this.rebuildEntryMap();
    }

    public Vector getUnscannedDirsFuzzy() {
        Vector v = this.dirs;
        Vector<ListItem> result = new Vector<ListItem>(7);
        int n = 0;
        while (n < v.size()) {
            FileSetupEntry fse = (FileSetupEntry)v.elementAt(n);
            if (fse.doScan()) {
                File first;
                File path;
                if (fse.path.endsWith(".jar") || fse.path.endsWith(".zip")) {
                    if (SourceBase.This().definitionsInFile(fse.path).size() == 0) {
                        result.addElement(new ListItem(new File(fse.path)));
                    }
                } else if (fse.scanClasses) {
                    path = new File(fse.path);
                    first = this.findFirstFileEnding(path, ".class");
                    if (first != null && SourceBase.This().definitionsInFile(first.getAbsolutePath()).size() == 0) {
                        result.addElement(new ListItem(path));
                    }
                } else {
                    path = new File(fse.path);
                    first = this.findFirstFileEnding(path, ".java");
                    if (first != null && SourceBase.This().definitionsInFile(first.getAbsolutePath()).size() == 0) {
                        result.addElement(new ListItem(path));
                    }
                }
            }
            ++n;
        }
        return result;
    }

    public void readFrom(FileSetupEntry fse) {
        this.scanChk.setPressed(fse.doScan());
        this.visibleChk.setPressed(!fse.isVisible);
        this.checkChk.setPressed(fse.checkForChanges);
        this.readOnlyChk.setPressed(fse.readOnly);
        this.fileTxt.setText(fse.path);
        this.scanClassChk.setPressed(fse.scanClasses);
    }

    public void writeTo(FileSetupEntry fse) {
        boolean notify = false;
        if (fse.doScan() != this.scanChk.isPressed()) {
            notify = true;
        }
        fse.doScan = this.scanChk.isPressed();
        fse.readOnly = this.readOnlyChk.isPressed();
        fse.scanClasses = this.scanClassChk.isPressed();
        fse.isVisible = !this.visibleChk.isPressed();
        fse.checkForChanges = this.checkChk.isPressed();
        if (!fse.path.equals(this.fileTxt.getText())) {
            notify = true;
            this.listPanel.repaint();
        }
    }

    void notifyScanableSourceChanged() {
        this.getApplication().binderApplication().notifyTargets("ScanSourceChanged");
    }

    void notifyVisibleSourceChanged() {
        this.getApplication().binderApplication().notifyTargets("VisibleSourceChanged");
    }

    public Object actionOpenSourceIndexer(Object a, Object s) {
        ((EditApp)this.getApplication()).indexerFrame.show();
        return null;
    }

    Vector compareSettings(Vector old, Vector newDirs) {
        Hashtable<String, FileSetupEntry> ht = new Hashtable<String, FileSetupEntry>(31);
        Hashtable<String, FileSetupEntry> htNew = new Hashtable<String, FileSetupEntry>(31);
        Vector<FileSetupEntry> removed = new Vector<FileSetupEntry>(31);
        Vector<FileSetupEntry> added = new Vector<FileSetupEntry>(31);
        int n = 0;
        while (n < old.size()) {
            FileSetupEntry fse = (FileSetupEntry)old.elementAt(n);
            ht.put(fse.path, fse);
            ++n;
        }
        int n2 = 0;
        while (n2 < newDirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)newDirs.elementAt(n2);
            htNew.put(fse.path, fse);
            if (ht.get(fse.path) == null && fse.doScan()) {
                added.addElement(fse);
                Tracer.This.println("added * " + fse.path);
            } else if (fse.doScan() && !((FileSetupEntry)ht.get(fse.path)).doScan()) {
                added.addElement(fse);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < old.size()) {
            FileSetupEntry fse = (FileSetupEntry)old.elementAt(n3);
            if (htNew.get(fse.path) == null) {
                removed.addElement(fse);
                Tracer.This.println("removed * " + fse.path);
            }
            ++n3;
        }
        return added;
    }

    public File findFirstFileEnding(File dir, final String endsWith) {
        final File[] jfile = new File[]{null};
        DirIterator.Iterate(dir, new JIterationFunc(){

            public boolean func(Object o) {
                File f = (File)o;
                String s = f.getAbsolutePath();
                if (s.endsWith(endsWith)) {
                    jfile[0] = f;
                    return true;
                }
                return false;
            }
        }, true, new FilenameFilter(){

            public boolean accept(File dir1, String name) {
                return name.endsWith(endsWith);
            }
        });
        return jfile[0];
    }

    public void checkNewEntriesSettings(FileSetupEntry fse) {
        if (fse.path.endsWith(".jar") || fse.path.endsWith(".zip")) {
            fse.scanClasses = false;
            fse.doScan = true;
            fse.readOnly = true;
            fse.checkForChanges = false;
            return;
        }
        final int[] issrc = new int[]{0};
        File[] jfile = new File[]{null};
        DirIterator.Iterate(new File(fse.path), new JIterationFunc(){

            public boolean func(Object o) {
                File f = (File)o;
                String s = f.getAbsolutePath();
                if (s.endsWith(".java")) {
                    issrc[0] = issrc[0] | 1;
                    return true;
                }
                if ((issrc[0] & 2) == 0 && s.endsWith(".class")) {
                    issrc[0] = issrc[0] | 2;
                }
                return false;
            }
        }, true, new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }
        });
        if ((issrc[0] & 1) != 1 || fse.scanClasses) {
            // empty if block
        }
        if ((issrc[0] & 1) != 1 || !fse.doScan()) {
            // empty if block
        }
        if (issrc[0] != 2 || !fse.scanClasses) {
            // empty if block
        }
        if (issrc[0] != 2 || !fse.doScan()) {
            // empty if block
        }
    }

    public void processAdded(Vector added) {
        Vector<ListItem> newFiles = new Vector<ListItem>(added.size() + 4);
        int n = 0;
        while (n < added.size()) {
            FileSetupEntry fse = (FileSetupEntry)added.elementAt(n);
            this.checkNewEntriesSettings(fse);
            newFiles.addElement(new ListItem(new File(fse.path)));
            ++n;
        }
        if (EditApp.AutoScan) {
            EditApp.App.scanAsynchronous(newFiles, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object applyDirChanges(boolean rescan) {
        Vector prevDirs = new Vector(this.dirs.size() + 5);
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            EditApp.currentProject.compileExtern = true;
            this.writeDirs();
            Vector added = this.compareSettings(prevDirs, this.dirs);
            this.notifyScanableSourceChanged();
            this.notifyVisibleSourceChanged();
            SourceBase.This().filteredIndex = null;
            this.rebuildEntryMap();
            EditApp.App.binderApplication().notifyTargets("rebuildIndex");
            if (rescan && EditApp.AutoScan) {
                this.processAdded(added);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getFrame().setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
        this.getFrame().setCursor(Cursor.getDefaultCursor());
        this.setApplyEnabled(false);
        this.listPanel.setSelectedString(this.fileTxt.getText());
        return null;
    }

    public Object actionApply(Object a, Object s) {
        Vector<FileSetupEntry> prevDirs = new Vector<FileSetupEntry>(this.dirs.size() + 5);
        if (a != null || s != null) {
            int n = 0;
            while (n < this.dirs.size()) {
                prevDirs.addElement(((FileSetupEntry)this.dirs.elementAt(n)).createCopy());
                ++n;
            }
        }
        this.applyDirChanges(true);
        this.actionListSel(null, null);
        return null;
    }

    public String normalizeDir(String dir) {
        return VFile.GetOSCapitalization(dir);
    }

    public void rebuildEntryMap() {
        this.entryMap.clear();
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)this.dirs.elementAt(n);
            fse.path = this.normalizeDir(fse.path);
            this.entryMap.put(fse.path.toUpperCase(), this.dirs.elementAt(n));
            ++n;
        }
    }

    public void selectOptionsFor(String pathOrFile) {
        FileSetupEntry fse = this.getOptionsFor(pathOrFile);
        if (fse == null) {
            return;
        }
        this.listPanel.setSelectedString(fse.path);
        this.actionListSel(null, null);
    }

    public FileSetupEntry getOptionsFor(String pathOrFile) {
        String toSearch = pathOrFile.toUpperCase();
        FileSetupEntry result = null;
        int i = 0;
        while (toSearch.length() > 0 && (i = toSearch.lastIndexOf(File.separator)) >= 0) {
            result = (FileSetupEntry)this.entryMap.get(toSearch);
            if (result != null) {
                return result;
            }
            toSearch = toSearch.substring(0, i);
        }
        return result;
    }

    public Vector getAllDirs() {
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        Vector<String> res = new Vector<String>(this.dirs.size());
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)this.dirs.elementAt(n);
            res.addElement(fse.path);
            ++n;
        }
        return res;
    }

    public Vector getVisibleDirs() {
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        Vector<String> res = new Vector<String>(this.dirs.size());
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)this.dirs.elementAt(n);
            if (fse.isVisible) {
                res.addElement(fse.path);
            }
            ++n;
        }
        return res;
    }

    public Vector getScanableFiles() {
        Vector v;
        HashSet set = new HashSet(4000);
        Vector baseDirs = this.getScanableDirs();
        int i = 0;
        while (i < baseDirs.size()) {
            v = DirIterator.DirContent(new File((String)baseDirs.get(i)), ".java");
            set.addAll(v);
            ++i;
        }
        v = new Vector(set);
        int i2 = 0;
        while (i2 < v.size()) {
            File javaFile = (File)v.get(i2);
            FileSetupEntry fse = EditApp.App.getOptionsFor(javaFile.getAbsolutePath());
            if (fse == null || !fse.doScan() || javaFile.getAbsolutePath().endsWith(")")) {
                set.remove(javaFile);
            }
            ++i2;
        }
        v = new Vector(set);
        return v;
    }

    public Vector getScanableDirs() {
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        Vector<String> res = new Vector<String>(this.dirs.size());
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)this.dirs.elementAt(n);
            if (fse.doScan()) {
                res.addElement(fse.path);
            }
            ++n;
        }
        return res;
    }

    public Vector getDependencyCheckedDirs() {
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        Vector<String> res = new Vector<String>(this.dirs.size());
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)this.dirs.elementAt(n);
            if (fse.checkForChanges) {
                res.addElement(fse.path);
            }
            ++n;
        }
        return res;
    }

    public void loadProperty(PropWriter pw) throws Exception {
        DataInputStream o = pw.getStream("FileSetupPanel");
        int cnt = o.readInt();
        this.dirs.removeAllElements();
        int n = 0;
        while (n < cnt) {
            FileSetupEntry fse = FileSetupEntry.ReadFrom(o);
            fse.path = VFile.GetOSCapitalization(fse.path);
            while (fse.path.length() > 3 && fse.path.endsWith(File.separator)) {
                fse.path = fse.path.substring(0, fse.path.length() - 1);
            }
            this.dirs.addElement(fse);
            ++n;
        }
        this.readDirs();
        this.notifyScanableSourceChanged();
        this.notifyVisibleSourceChanged();
        this.rebuildEntryMap();
        this.actionListSel(null, null);
    }

    public void storeProperty(PropWriter pw) throws Exception {
        DataOutputStream o = pw.createStream("FileSetupPanel");
        if (this.currSel != null) {
            this.writeTo(this.currSel);
        }
        o.writeInt(this.dirs.size());
        int n = 0;
        while (n < this.dirs.size()) {
            FileSetupEntry fse = (FileSetupEntry)this.dirs.elementAt(n);
            fse.writeTo(o);
            ++n;
        }
    }

    public void addBtn_actionPerformed(ActionEvent var0) {
        JWidgetsUtil.AddJob(new Runnable(){

            public void run() {
                AJWSpaceOptions.this.addCurrentDir();
            }
        });
    }
}

