/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import JCollections.JArray;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import de.netcomputing.anyj.debugger.MyInterpreter;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.Win32Util;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import koala.dynamicjava.interpreter.InterpreterException;

public class RemoteInterpreter {
    public static RemoteInterpreter interpreter = new RemoteInterpreter();
    public static MyInterpreter treeInterpreter = new MyInterpreter();
    ObjectReference remoteInterpreter;
    ObjectReference remoteTreeInterpreter;
    VirtualMachine lastVM;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void InitLocalInterpreter() {
        try {
            String dir = System.getProperty("nc.currdir");
            if (dir != null) {
                Win32Util.setCurrentDir(dir);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    void setVariable(String name, short val) {
        treeInterpreter.setVariable(name, new Short(val));
    }

    void setVariable(String name, boolean val) {
        treeInterpreter.setVariable(name, new Boolean(val));
    }

    void setVariable(String name, byte val) {
        treeInterpreter.setVariable(name, new Byte(val));
    }

    void setVariable(String name, char val) {
        treeInterpreter.setVariable(name, new Character(val));
    }

    void setVariable(String name, int val) {
        treeInterpreter.setVariable(name, new Integer(val));
    }

    void setVariable(String name, long val) {
        treeInterpreter.setVariable(name, new Long(val));
    }

    void setVariable(String name, float val) {
        treeInterpreter.setVariable(name, new Float(val));
    }

    void setVariable(String name, double val) {
        treeInterpreter.setVariable(name, new Double(val));
    }

    void setVariable(String name, Object val) {
        treeInterpreter.setVariable(name, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object interpret(final String toRun) {
        final Object[] res = new Object[]{null};
        final Object lock = new Object();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object object;
                System.out.println("RUNNING INT");
                try {
                    try {
                        String tmptoRun = RemoteInterpreter.this.replaceThisCalls(toRun);
                        res[0] = treeInterpreter.interpret(new StringReader(tmptoRun), "selection");
                    }
                    catch (InterpreterException e) {
                        e.printStackTrace();
                        res[0] = e;
                        Object var4_4 = null;
                        Object object3 = lock;
                        synchronized (object3) {
                            lock.notifyAll();
                            return;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        res[0] = e;
                        Object var4_5 = null;
                        Object object4 = lock;
                        synchronized (object4) {
                            lock.notifyAll();
                            return;
                        }
                    }
                    Object var4_3 = null;
                    object = lock;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    Object object2 = lock;
                    synchronized (object2) {
                        lock.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (object) {
                    lock.notifyAll();
                    return;
                }
            }
        }.start();
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(5000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return res[0];
    }

    public Object getCollectionView(Value val, ThreadReference thread) {
        try {
            com.sun.jdi.Method m = (com.sun.jdi.Method)this.remoteInterpreter.referenceType().methodsByName("view").get(0);
            ArrayList<Value> l = new ArrayList<Value>();
            l.add(val);
            return this.remoteInterpreter.invokeMethod(thread, m, l, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object[] view(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Object[] res = new Object[map.size()];
            Iterator it = map.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                Object[] mp;
                mp = new Object[]{it.next(), map.get(mp[0])};
                res[i++] = mp;
            }
            return res;
        }
        if (o instanceof Collection) {
            Collection cl = (Collection)o;
            Object[] res = new Object[cl.size()];
            Iterator it = cl.iterator();
            int i = 0;
            while (it.hasNext()) {
                res[i++] = it.next();
            }
            return res;
        }
        return null;
    }

    public String createInterpreterString(TextDocument doc) {
        String toRun = doc.getSelectionAsString();
        JArray arr = new JArray(20);
        String pack = DocumentStream.ScanImports(doc, arr, true);
        int n = 0;
        while (n < arr.size()) {
            if (arr.at(n).toString().equals("java.lang")) {
                toRun = "import java.lang.*;\n" + toRun;
            } else if (!arr.at(n).equals(pack)) {
                toRun = "import " + arr.at(n) + ";\n" + toRun;
            }
            ++n;
        }
        if (pack != null) {
            toRun = "package " + pack + ";\n" + toRun;
        }
        if (!(toRun = toRun.trim()).endsWith(";")) {
            toRun = toRun + ";";
        }
        return toRun;
    }

    public void initRemoteInterpreter(VirtualMachine vm) {
        if (this.remoteInterpreter == null || this.lastVM != vm) {
            this.lastVM = vm;
            ClassType me2 = this.findClazz(vm, "de.netcomputing.anyj.debugger.RemoteInterpreter");
            Field field = me2.fieldByName("interpreter");
            try {
                this.remoteInterpreter = (ObjectReference)me2.getValue(field);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            field = me2.fieldByName("treeInterpreter");
            try {
                this.remoteTreeInterpreter = (ObjectReference)me2.getValue(field);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ClassType findClazz(VirtualMachine vm, String name) {
        List l = vm.allClasses();
        int i = 0;
        while (i < l.size()) {
            ClassType cl;
            if (l.get(i) instanceof ClassType && (cl = (ClassType)l.get(i)).name().equals(name)) {
                return cl;
            }
            ++i;
        }
        return null;
    }

    public Object interpretSelection(HashMap values, TextDocument doc, ThreadReference thread, VirtualMachine vm) {
        String toRun = this.createInterpreterString(doc);
        HashSet<String> refVars = new HashSet<String>();
        DocumentStream ds = new DocumentStream(doc.getSelection(), 0, 0);
        StringBuffer sb = new StringBuffer(10);
        while (ds.readJavaToken(sb)) {
            refVars.add(sb.toString());
            sb.setLength(0);
        }
        refVars.add("this_internal");
        Iterator it = refVars.iterator();
        while (it.hasNext()) {
            String cur = it.next().toString();
            if (values.get(cur) == null) continue;
            this.defineVariable(thread, vm, cur, (Value)values.get(cur));
        }
        com.sun.jdi.Method m = (com.sun.jdi.Method)this.remoteInterpreter.referenceType().methodsByName("interpret").get(0);
        ArrayList<StringReference> l = new ArrayList<StringReference>();
        l.add(vm.mirrorOf(toRun));
        Value result = null;
        try {
            result = this.remoteInterpreter.invokeMethod(thread, m, l, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            m = (com.sun.jdi.Method)this.remoteTreeInterpreter.referenceType().methodsByName("reset").get(0);
            l = new ArrayList();
            this.remoteTreeInterpreter.invokeMethod(thread, m, l, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void resetRemote() {
    }

    com.sun.jdi.Method findMethod(ObjectReference val, String name, String signature) {
        List l = val.referenceType().methodsByName(name);
        int i = 0;
        while (i < l.size()) {
            com.sun.jdi.Method m = (com.sun.jdi.Method)l.get(i);
            if (m.signature().equals(signature)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public void defineVariable(ThreadReference thread, VirtualMachine vm, String name, Value value) {
        if (value == null) {
            return;
        }
        try {
            if (value instanceof ShortValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;S)V", name, value);
            } else if (value instanceof BooleanValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;Z)V", name, value);
            } else if (value instanceof ByteValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;B)V", name, value);
            } else if (value instanceof CharValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;C)V", name, value);
            } else if (value instanceof IntegerValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;I)V", name, value);
            } else if (value instanceof LongValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;J)V", name, value);
            } else if (value instanceof FloatValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;F)V", name, value);
            } else if (value instanceof DoubleValue) {
                this.defineInternal(thread, vm, "(Ljava/lang/String;D)V", name, value);
            } else {
                this.defineInternal(thread, vm, "(Ljava/lang/String;Ljava/lang/Object;)V", name, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void defineInternal(ThreadReference thread, VirtualMachine vm, String sig, String name, Object value) {
        com.sun.jdi.Method m = this.findMethod(this.remoteTreeInterpreter, "defineVariable", sig);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(vm.mirrorOf(name));
        l.add(value);
        try {
            this.remoteTreeInterpreter.invokeMethod(thread, m, l, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    String replaceThisCalls(String toRun) {
        String res = "";
        String methCtx = "";
        int lastCharPrevCtx = 32;
        boolean ignoreNext = false;
        int i = 0;
        while (i < toRun.length()) {
            if (toRun.charAt(i) == '(') {
                if (lastCharPrevCtx != 46) {
                    if (!ignoreNext) {
                        while (res.endsWith(" ") || res.endsWith("\t")) {
                            res = res.substring(0, res.length() - 1);
                        }
                        res = res.substring(0, res.length() - methCtx.length()) + "this_internal." + methCtx;
                    } else {
                        ignoreNext = false;
                    }
                }
                methCtx = "";
                lastCharPrevCtx = 32;
            } else if (Character.isJavaIdentifierPart(toRun.charAt(i))) {
                methCtx = methCtx + toRun.charAt(i);
            } else if (toRun.charAt(i) > ' ') {
                if ("this".equals(methCtx)) {
                    while (res.endsWith(" ") || res.endsWith("\t")) {
                        res = res.substring(0, res.length() - 1);
                    }
                    res = res.substring(0, res.length() - methCtx.length()) + "this_internal";
                }
                methCtx = "";
                lastCharPrevCtx = toRun.charAt(i);
            } else {
                if ("new".equals(methCtx)) {
                    ignoreNext = true;
                }
                if ("throw".equals(methCtx)) {
                    ignoreNext = true;
                }
            }
            res = res + toRun.charAt(i);
            ++i;
        }
        return res;
    }

    public static void main(String[] args) {
        RemoteInterpreter.InitLocalInterpreter();
        try {
            String[] newArgs = new String[args.length - 1];
            int i = 1;
            while (i < args.length) {
                newArgs[i - 1] = args[i];
                ++i;
            }
            Class<?> clz = Class.forName(args[0]);
            Method mm = clz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = RemoteInterpreter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            mm.invoke(clz, new Object[]{newArgs});
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ((InvocationTargetException)ex).printStackTrace();
            }
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

