/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.ButtonDecorator;
import de.netcomputing.anyj.jwidgets.ColorRect;
import de.netcomputing.anyj.jwidgets.GenericButton;
import de.netcomputing.anyj.jwidgets.ImageVisual;
import de.netcomputing.anyj.jwidgets.JWArrowVisual;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.RoundBorder;
import de.netcomputing.anyj.jwidgets.SwingScrollbuttonDecorator;
import de.netcomputing.anyj.jwidgets.TextVisual;
import de.netcomputing.anyj.jwidgets.VisualLayout;
import java.awt.Color;

public class ButtonFactory {
    public static NCCheckBox CheckBox(String label) {
        return new NCCheckBox(label);
    }

    static GenericButton ColorButton(Color c) {
        GenericButton gb = new GenericButton();
        gb.stateVisual[GenericButton.INACTIVE] = new ButtonDecorator(gb, new ColorRect(gb, c));
        gb.enableHighlighting(false);
        gb.initVisuals();
        return gb;
    }

    public static NCButton TextButton(String label) {
        return new NCButton(label);
    }

    public static GenericButton SwingArrowButton(int dir, int w, int h) {
        GenericButton p = new GenericButton();
        p.stateVisual[GenericButton.INACTIVE] = new SwingScrollbuttonDecorator(p, new JWArrowVisual(dir, Color.black, JWColor.For("background"), w - 3, h - 3));
        p.stateVisual[GenericButton.ACTIVE] = new SwingScrollbuttonDecorator(p, new JWArrowVisual(dir, Color.black, JWColor.For("background.-"), w - 3, h - 3));
        ((SwingScrollbuttonDecorator)p.stateVisual[GenericButton.ACTIVE]).highlightColor = JWColor.For("background.-");
        ((SwingScrollbuttonDecorator)p.stateVisual[GenericButton.ACTIVE]).darkShadowColor = JWColor.For("background.-");
        p.enableHighlighting(false);
        p.init();
        return p;
    }

    public static GenericButton BorderedArrowButton(int dir, int w, int h) {
        GenericButton p = new GenericButton();
        JWArrowVisual v = new JWArrowVisual(dir, Color.black, JWColor.For("background"), w - 1, h - 1, 2, 1);
        v.border = true;
        p.stateVisual[GenericButton.INACTIVE] = v;
        v = new JWArrowVisual(dir, Color.black, JWColor.For("background"), w, h - 1, 2, 1);
        v.border = true;
        p.stateVisual[GenericButton.ACTIVE] = v;
        p.enableHighlighting(false);
        p.init();
        return p;
    }

    public static GenericButton BorderedButton(String img, String label) {
        GenericButton p = new GenericButton();
        p.stateVisual[GenericButton.HIGHLIGHT] = new VisualLayout(p, new RoundBorder(p, new ImageVisual(p, NCApplication.GetImage(img))), 0.5f, 1.0f, new TextVisual(p, label, p.getFont()), 0.5f, -0.1f);
        p.stateVisual[GenericButton.ACTIVE] = p.stateVisual[GenericButton.HIGHLIGHT];
        p.stateVisual[GenericButton.INACTIVE] = p.stateVisual[GenericButton.HIGHLIGHT].clone("pressed");
        p.enableHighlighting(true);
        p.init();
        return p;
    }

    public static GenericButton BorderedButton(String img) {
        GenericButton p = new GenericButton();
        p.stateVisual[GenericButton.INACTIVE] = new ButtonDecorator(p, new ImageVisual(p, NCApplication.GetImage(img)));
        p.enableHighlighting(false);
        p.init();
        return p;
    }

    public static GenericButton BorderedPressButton(String img, String label) {
        GenericButton p = ButtonFactory.BorderedButton(img, label);
        p.isPushButton(false);
        return p;
    }

    static {
        NCApplication.PutImage("im-CheckTrue", "buttons/check0.gif");
        NCApplication.PutImage("im-CheckFalse", "buttons/check1.gif");
    }
}

