/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.ColorRect;
import de.netcomputing.anyj.jwidgets.IVisual;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class ColoredTextRect
extends ColorRect {
    boolean isGrayed = false;
    boolean isHigh = false;
    String label;
    public boolean drawBack = true;
    public boolean drawFocus = false;
    Dimension dim = new Dimension(0, 0);

    public ColoredTextRect(Component par, String text, Color col) {
        super(par, col);
        this.color = col;
        this.label = text;
    }

    public ColoredTextRect(Component par, String text, Color col, boolean drawBG) {
        this(par, text, col);
        this.drawBack = drawBG;
    }

    public ColoredTextRect(Component par, String text, Color col, int w, int h) {
        this(par, text, col);
        this.dim = new Dimension(w, h);
    }

    public void paint(Graphics g, int _w, int _h) {
        if (this.drawBack) {
            super.paint(g, _w, _h);
        }
        int w = g.getFontMetrics(this.parent.getFont()).stringWidth(this.label);
        int asc = g.getFontMetrics(this.parent.getFont()).getAscent();
        int h = g.getFontMetrics(this.parent.getFont()).getHeight();
        int x = _w > w ? (_w - w) / 2 : 3;
        int y = (_h - h) / 2 + asc - 1;
        if (this.isHigh) {
            g.setColor(JWColor.For("selection.fg"));
        } else if (this.isGrayed) {
            g.setColor(JWColor.For("background.++"));
        } else {
            g.setColor(JWColor.For("label.text"));
        }
        if (this.isGrayed) {
            g.drawString(this.label, x + 1, y + 1);
            g.setColor(JWColor.For("background.--"));
            g.drawString(this.label, x, y);
        } else {
            g.drawString(this.label, x, y);
        }
        if (this.drawFocus) {
            g.setColor(Color.gray);
            g.drawRect(x - 3, y - asc, w + 6, h);
        }
    }

    public Dimension preferredSize() {
        return new Dimension(this.dim.width, this.dim.height);
    }

    public IVisual clone(String kind) {
        ColoredTextRect v = null;
        try {
            v = (ColoredTextRect)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(Tracer.This);
        }
        if (kind.equals("grayed")) {
            v.isGrayed = true;
        } else if (kind.equals("highlighted")) {
            v.drawFocus = true;
        }
        v.label = this.label;
        return v;
    }
}

