/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JUnsafeTable;
import de.netcomputing.anyj.jwidgets.ArrayTool;
import de.netcomputing.anyj.jwidgets.IB_ContainerCreator;
import de.netcomputing.anyj.jwidgets.IClassCreator;
import de.netcomputing.anyj.jwidgets.MethInvoker;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.Component;

public class CompCreator {
    public static boolean shouldCache = true;
    static JUnsafeTable jibCache = new JUnsafeTable(20);

    public static Component CreateInstance(IClassCreator cc, Object[] data) {
        data = ArrayTool.DeepArrayCopy(data);
        Object[] methods = (Object[])data[0];
        Object[] args = (Object[])data[1];
        int n = 0;
        while (n < methods.length) {
            MethInvoker.invoke(cc, methods[n], (Object)args);
            ++n;
        }
        return (Component)args[0];
    }

    public static Component CreateFromJIB(IClassCreator cc, String file2) {
        Object[] pan = ArrayTool.LoadArray(file2);
        pan = (Object[])ArrayTool.DecodeArray(pan);
        Component c = CompCreator.CreateInstance(cc, pan);
        return c;
    }

    public static Component CreateFromJIBFile(IClassCreator cc, String file2) {
        Object[] pan = ArrayTool.LoadArrayFromFile(file2);
        pan = (Object[])ArrayTool.DecodeArray(pan);
        Component c = CompCreator.CreateInstance(cc, pan);
        return c;
    }

    public static void ClearCache() {
        jibCache = new JUnsafeTable(10);
    }

    public static void BuildFromFileIn(NCPanel jp, IClassCreator cc, String file2) {
        Object[] pan = null;
        file2 = file2.toLowerCase();
        if (shouldCache) {
            pan = (Object[])jibCache.get(file2);
        }
        long time = System.currentTimeMillis();
        if (pan == null) {
            pan = ArrayTool.LoadArray(file2);
            NCApplication.Pln("" + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
            pan = (Object[])ArrayTool.DecodeArray(pan);
            time = System.currentTimeMillis();
            if (shouldCache) {
                jibCache.put(file2, pan);
            }
        } else {
            NCApplication.Pln("loading cached .jib");
        }
        time = System.currentTimeMillis();
        new IB_ContainerCreator().buildIn(cc, jp, (Object[])pan[1]);
    }

    public static void BuildFromStringIn(NCPanel jp, IClassCreator cc, String jibString) {
        Object[] pan = ArrayTool.LoadFromString(jibString);
        pan = (Object[])ArrayTool.DecodeArray(pan);
        new IB_ContainerCreator().buildIn(cc, jp, (Object[])pan[1]);
    }
}

