/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JArray;
import de.netcomputing.anyj.jwidgets.DirDiffResult;
import de.netcomputing.anyj.jwidgets.DirNode;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import java.io.File;

public class DiffDirNode
extends DirNode {
    DirDiffResult desc;

    public DiffDirNode(File f, DirDiffResult desc) {
        super(f);
        this.desc = desc;
        this.computeImage();
    }

    public boolean accept(File dir, String name) {
        return this.desc.getFilter().accept(dir, name);
    }

    void constructContent() {
        String nettoMyFile = this.file.getPath();
        File addFi = new File(this.desc.getDiffRoot() + File.separator + nettoMyFile);
        Object[] files = addFi.list(this);
        if (files == null) {
            files = new String[]{};
        }
        JArray arr = new JArray(files.length + 1);
        arr.addAll(files);
        File remFi = new File(this.desc.getDiffBRoot() + File.separator + nettoMyFile);
        files = remFi.list(this);
        int i = 0;
        while (files != null && i < files.length) {
            if (this.desc.getRemoved().contains(nettoMyFile + File.separator + (String)files[i])) {
                arr.add(files[i]);
            } else if (new File(remFi, (String)files[i]).isDirectory() && !arr.contains(files[i])) {
                arr.add(this.constructSubNode(this.file, (String)files[i]));
            }
            ++i;
        }
        JArray.QuickSort(arr, JArray.UpperCaseStringSortFunc());
        int n = 0;
        while (n < arr.size()) {
            if (arr.at(n) instanceof String) {
                DirNode dn = this.constructSubNode(this.file, arr.at(n).toString());
                if (dn != null) {
                    arr.setAt(n, dn);
                } else {
                    arr.remAt(n);
                    --n;
                }
            }
            ++n;
        }
        this.cont = new IListItem[arr.size()];
        int n2 = 0;
        while (n2 < arr.size()) {
            this.cont[n2] = (IListItem)arr.at(n2);
            this.cont[n2].setDepth(this.getDepth() + 1);
            ++n2;
        }
        if (this.cont == null) {
            this.cont = new IListItem[0];
        }
    }

    protected DirNode constructSubNode(File file2, String name) {
        File fi = new File(file2, name);
        return new DiffDirNode(fi, this.desc);
    }

    protected void computeImage() {
        if (this.desc == null) {
            return;
        }
        boolean isDir = false;
        File f = new File(this.desc.getDiffRoot() + File.separator + this.file.getPath());
        File f1 = new File(this.desc.getDiffBRoot() + File.separator + this.file.getPath());
        boolean bl = isDir = f.isDirectory() || f1.isDirectory();
        if (isDir) {
            if (!this.desc.hasChange(this.file.getPath())) {
                this.im = NCApplication.GetImage("dir.gif");
                this.openImage = NCApplication.GetImage("diropen.gif");
            } else {
                this.im = NCApplication.GetImage("/de/netcomputing/anyj/images/folderdiff.gif");
                this.openImage = NCApplication.GetImage("/de/netcomputing/anyj/images/opendiff.gif");
            }
            this.hasContent = true;
        } else {
            this.hasContent = false;
            switch (this.desc.getDiffType(this.file.getPath())) {
                case 68: {
                    this.im = NCApplication.GetImage("/de/netcomputing/anyj/images/filediff.gif");
                    break;
                }
                case 43: {
                    this.im = NCApplication.GetImage("/de/netcomputing/anyj/images/fileplus.gif");
                    break;
                }
                case 45: {
                    this.im = NCApplication.GetImage("/de/netcomputing/anyj/images/fileminus.gif");
                    break;
                }
                default: {
                    this.im = NCApplication.GetImage("/de/netcomputing/anyj/images/file.gif");
                }
            }
        }
    }

    public int getDiffType() {
        return this.desc.getDiffType(this.file.getPath());
    }

    public DirDiffResult getDesc() {
        return this.desc;
    }

    public String getDisplayString() {
        if (this.display == null) {
            this.display = this.getDepth() == 1 ? this.file.getPath() : this.file.getName();
        }
        return this.display;
    }
}

