/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.ButtonDecorator;
import de.netcomputing.anyj.jwidgets.ColorRect;
import de.netcomputing.anyj.jwidgets.GenericButton;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import netcomputing.tools.PropWriter;

public class JWColorPalette
extends NCPanel {
    int wb;
    int hb;
    GenericButton selected;
    Hashtable ht = new Hashtable();
    GenericButton[] buttons;
    public static int SIZE = 64;

    static GenericButton ColorButton(Color c) {
        GenericButton gb = new GenericButton();
        gb.stateVisual[GenericButton.INACTIVE] = new ButtonDecorator(gb, new ColorRect(gb, c));
        gb.enableHighlighting(false);
        gb.isPushButton(false);
        gb.initVisuals();
        return gb;
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(SIZE / 16, 16, 0, 0));
        this.buttons = new GenericButton[SIZE];
        int n = 0;
        while (n < SIZE) {
            Color col = new Color(n * 4 % 256, n * 8 % 256, n * 16 % 256);
            this.selected = JWColorPalette.ColorButton(col);
            this.add((Component)this.selected, n);
            this.ht.put(this.selected, col);
            this.buttons[n] = this.selected;
            ++n;
        }
        this.validate();
        this.selected = (GenericButton)this.getComponent(0);
        this.selected.setPressed(true);
        this.notifyTargets();
    }

    public void storeProperty(PropWriter pw) throws Exception {
        DataOutputStream dos = pw.createStream(this.getClass().getName());
        int n = 0;
        while (n < this.buttons.length) {
            Color col = (Color)this.ht.get(this.buttons[n]);
            dos.writeInt(col.getRGB());
            ++n;
        }
    }

    public void loadProperty(PropWriter pw) throws Exception {
        DataInputStream dis = pw.getStream(this.getClass().getName());
        int n = 0;
        while (n < this.buttons.length) {
            Color col = new Color(dis.readInt());
            this.buttons[n].stateVisual[GenericButton.INACTIVE] = new ButtonDecorator(this.buttons[n], new ColorRect(this.buttons[n], col));
            this.buttons[n].stateVisual[GenericButton.ACTIVE] = null;
            this.buttons[n].initVisuals();
            this.buttons[n].repaint();
            this.ht.put(this.buttons[n], col);
            ++n;
        }
    }

    public boolean action(String selector, IValue val, Object sender) {
        if (selector.equals("color")) {
            Color c = (Color)val.value();
            this.setSelectionToColor(c);
            return true;
        }
        return false;
    }

    public void setSelectionToColor(Color c) {
        this.selected.stateVisual[GenericButton.INACTIVE] = new ButtonDecorator(this.selected, new ColorRect(this.selected, c));
        this.selected.stateVisual[GenericButton.ACTIVE] = null;
        this.selected.initVisuals();
        this.selected.repaint();
        this.ht.put(this.selected, c);
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof GenericButton) {
            GenericButton gb = (GenericButton)e.target;
            if (gb == this.selected) {
                this.selected.setPressed(true);
            } else {
                this.selected.setPressed(false);
                this.selected = gb;
                this.notifyTargets();
            }
            return true;
        }
        return false;
    }

    public Color selection() {
        return (Color)this.ht.get(this.selected);
    }

    void notifyTargets() {
        this.binder().notifyTargets(this.selection());
    }
}

