/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class JWMenuItem
extends ListItem {
    static Color menuSelectionColor = JWColor.For("menuselection.bg");
    static Color menuSelectionTextColor = JWColor.For("menuselection.fg");
    Object actionTarget;
    String action;
    public Object userData;
    boolean isEnabled = true;
    boolean isHorz = false;
    String shortCutString = " ";

    public JWMenuItem(Object o) {
        super(o);
    }

    public JWMenuItem(Object o, Object target, String action) {
        super(o);
        this.actionTarget = target;
        this.action = action;
    }

    public JWMenuItem(Object o, int d) {
        super(o, d);
    }

    public JWMenuItem(Object o, Image _im) {
        super(o, _im);
    }

    public JWMenuItem(Object o, Image _im, JWMenuItem[] contents) {
        super(o, _im, contents);
    }

    public JWMenuItem(Object o, JWMenuItem[] contents) {
        super(o, contents);
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setActionTarget(Object actionTarget) {
        this.actionTarget = actionTarget;
    }

    public Object getActionTarget() {
        return this.actionTarget;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setShortCutString(String shortCutString) {
        this.shortCutString = shortCutString;
    }

    public String getShortCutString() {
        if (this.shortCutString.equals(" ")) {
            int i = this.getDisplayString().indexOf("::");
            if (i >= 0) {
                String newObject = this.getDisplayString().substring(0, i);
                this.shortCutString = this.getDisplayString().substring(i + 2);
                this.object = newObject;
            } else {
                this.shortCutString = "";
            }
        }
        return this.shortCutString;
    }

    public void paint(Graphics g, NCPanel sender, boolean selected, boolean isExpanded, int index) {
        Image im;
        this.imWidth = this.getImage() != null ? this.getImage().getWidth(sender) : 0;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int height = this.heightIn(sender);
        int imHeight = this.getImageHeight(sender);
        int stringWidth = fm.stringWidth(this.getDisplayString());
        int stringHeight = fm.getHeight();
        int stringAscent = fm.getAscent();
        int xoff = 0;
        int imoff = 0;
        int textoff = 0;
        int selHeight = stringHeight;
        Image image = im = isExpanded ? this.getOpenImage() : this.getImage();
        if (imHeight > stringHeight) {
            imoff = 0;
            textoff = (imHeight - stringHeight) / 2;
        } else {
            textoff = 0;
            imoff = (stringHeight - imHeight) / 2;
        }
        if (im != null && imHeight > 0) {
            g.drawImage(im, -4, imoff, sender);
            xoff += 14;
        } else {
            xoff += 14;
        }
        if (selected && this.isEnabled) {
            g.setColor(this.getSelectionColor());
            g.fillRect(xoff, textoff - 2, stringWidth + 7, selHeight + 2 + 2);
            g.setColor(this.getSelectionForeground());
            g.drawString(this.getDisplayString().trim(), 3 + xoff, stringAscent + textoff);
            g.setColor(Color.black);
            g.drawRect(xoff, textoff - 2, stringWidth + 7, selHeight + 2 + 2);
        } else if (!this.isEnabled) {
            g.setColor(JWColor.For("background.++"));
            g.drawString(this.getDisplayString().trim(), 3 + xoff + 1, stringAscent + textoff + 1);
            g.setColor(JWColor.For("background.--"));
            g.drawString(this.getDisplayString().trim(), 3 + xoff, stringAscent + textoff);
        } else {
            g.setColor(sender.getForeground());
            g.drawString(this.getDisplayString().trim(), 3 + xoff, stringAscent + textoff);
        }
    }

    public Color getSelectionColor() {
        return menuSelectionColor;
    }

    public Color getSelectionForeground() {
        return menuSelectionTextColor;
    }

    public void paintMenu(Graphics g, NCPanel sender, boolean selected, int maxWidth) {
        this.paint(g, sender, selected, false, -1);
        Object tmp = this.object;
        this.object = this.getShortCutString();
        if (((String)this.object).length() == 0) {
            this.object = tmp;
            return;
        }
        int w = g.getFontMetrics().stringWidth((String)this.object);
        Image prev = this.im;
        this.im = null;
        g.translate(maxWidth - w - 8, 0);
        this.paint(g, sender, false, false, -1);
        this.im = prev;
        this.object = tmp;
        g.translate(-maxWidth + w + 8, 0);
    }

    public void setIsHorz(boolean isHorz) {
        this.isHorz = isHorz;
    }

    public boolean getIsHorz() {
        return this.isHorz;
    }

    public int widthIn(Component comp) {
        String toMeasure = this.getDisplayString() + 4 + this.getShortCutString();
        if (this.isHorz) {
            return 24 + comp.getFontMetrics(comp.getFont()).stringWidth(toMeasure);
        }
        return 32 + comp.getFontMetrics(comp.getFont()).stringWidth(toMeasure);
    }
}

