/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.AJIDEOptions;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWScrollable;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.ScrollerPanel;
import de.netcomputing.util.DelayedJobThread;
import de.netcomputing.util.Tracer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JWScrollPane
extends NCPanel {
    public static int SCROLLBARS_AS_NEEDED = 1;
    static int edge = 1;
    protected JComponent comp;
    protected JComponent overlayedComponent;
    public ScrollerPanel spv;
    public ScrollerPanel sph;
    protected int prevX;
    protected int prevY;
    protected int prevExH;
    protected int prevExV;
    protected int prevW;
    protected int prevH;
    protected int flags;
    int gridX = 1;
    int gridY = 1;
    protected boolean hhidden;
    protected boolean vhidden;
    static DelayedJobThread repainter = new DelayedJobThread();
    RepaintMeJob job = new RepaintMeJob();

    public JWScrollPane() {
        try {
            this.addMWListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    SwingUtilities.invokeLater(new Runnable(this, e){
                        private final /* synthetic */ MouseWheelEvent val$e;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$e = val$e;
                        }

                        public void run() {
                            if (AJIDEOptions.This != null) {
                                1.access$000(this.this$1).scrollYTo(1.access$000(this.this$1).yOff() + this.val$e.getWheelRotation() * (1 + AJIDEOptions.This.getMouseWheelAmount()) * 1.access$000(this.this$1).getHeight() / 14);
                            } else {
                                1.access$000(this.this$1).scrollYTo(1.access$000(this.this$1).yOff() + this.val$e.getWheelRotation() * 5 * 1.access$000(this.this$1).getHeight() / 14);
                            }
                        }
                    });
                }

                static /* synthetic */ JWScrollPane access$000(1 x0) {
                    return x0.JWScrollPane.this;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addMWListener(Object li) {
        try {
            Method m = this.getClass().getMethod("addMouseWheelListener", Class.forName("java.awt.event.MouseWheelListener"));
            if (m != null) {
                m.invoke((Object)this, li);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setOverlayedComponent(JComponent ovComponent) {
        if (this.overlayedComponent != null) {
            super.remove(this.overlayedComponent);
            if (ovComponent == null) {
                Tracer.This.println("CLEAR OVERLAYED:" + this.overlayedComponent);
                this.repaint(this.overlayedComponent.getBounds());
            }
        }
        this.overlayedComponent = ovComponent;
        if (ovComponent != null) {
            Tracer.This.println("SET OVERLAYED:" + ovComponent);
            super.add((Component)ovComponent, 0);
        }
    }

    public JComponent getOverlayedComponent() {
        return this.overlayedComponent;
    }

    public void setGrid(int x, int y) {
        this.gridX = x;
        this.gridY = y;
    }

    public void setFlags(int newFlags) {
        this.flags = newFlags;
    }

    public int getFlags() {
        return this.flags;
    }

    public JWScrollPane(Component comp) {
        this.add(comp);
        this.init();
    }

    public void setHScrollerEnabled(boolean b) {
        this.sph.setVisible(b);
        this.hhidden = b;
    }

    public void setVScrollerEnabled(boolean b) {
        this.spv.setVisible(b);
        this.hhidden = b;
    }

    public void noHorz() {
        this.sph.setVisible(false);
        this.hhidden = true;
    }

    public void noVert() {
        this.spv.setVisible(false);
        this.vhidden = true;
    }

    public Component add(Component _comp) {
        this.comp = (JComponent)_comp;
        return this.comp;
    }

    public void init() {
        super.init();
        this.setLayout(null);
        this.spv = new ScrollerPanel();
        this.sph = new ScrollerPanel();
        super.add(this.comp);
        super.add(this.spv);
        super.add(this.sph);
        this.spv.init();
        this.sph.init(true);
        this.sph.setLineIncrement(1);
        this.spv.setLineIncrement(1);
        this.spv.binder().addTarget(this, "actionScrollV");
        this.sph.binder().addTarget(this, "actionScrollH");
        this.checkComponentValues();
    }

    public void _checkVisibleExtend() {
        try {
            Dimension d = this.comp.size();
            this.sph.setVisibleRange(d.width);
            this.spv.setVisibleRange(d.height);
            this.prevW = d.width;
            this.prevH = d.height;
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void _checkLayout() {
        try {
            Dimension par = this.size();
            Dimension sl = this.spv.getPreferredSize();
            Dimension sb = this.sph.getPreferredSize();
            if (this.hhidden) {
                sb.height = 0;
            }
            if (this.vhidden) {
                sl.width = 0;
            }
            this.sph.setBounds(1, par.height - sb.height - edge, par.width - sl.width - edge - 1, sb.height);
            this.spv.setBounds(par.width - sl.width - edge, 1, sl.width, par.height - edge - (sb.height == 0 ? 1 : sb.height) - 1);
            this.comp.setBounds(edge, edge, par.width - sl.width - edge * 2, par.height - sb.height - edge * 2);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void jwPaint(Graphics g) {
        this.checkComponentValues();
        Dimension d = this.size();
        g.setColor(JWColor.For("background.--"));
        g.drawLine(0, 0, d.width, 0);
        g.drawLine(0, 0, 0, d.height);
        g.setColor(JWColor.For("background.++"));
        g.drawLine(1, d.height - 1, d.width, d.height - 1);
        g.drawLine(d.width - 1, d.height - 1, d.width - 1, 0);
    }

    public void checkComponentValues() {
        int newSel;
        this._checkLayout();
        this._checkDataExtend();
        this._checkVisibleExtend();
        this.spv.checkPosition();
        this.sph.checkPosition();
        if (this.yOff() + this.getHeight() > this.comp.preferredSize().height) {
            newSel = this.comp.preferredSize().height - this.comp.size().height;
            this.spv.setSelection(Math.min(newSel, this.spv.getSelection()));
        }
        if (this.xOff() + this.getWidth() > this.comp.preferredSize().width) {
            newSel = this.comp.preferredSize().width - this.comp.size().width;
            this.sph.setSelection(Math.min(newSel, this.sph.getSelection()));
        }
    }

    public void _checkDataExtend() {
        try {
            Dimension d = this.comp.preferredSize();
            if (d.width != this.sph.getMaxValue() - this.sph.getMinValue()) {
                this.repaint();
            }
            this.sph.setRange(0, d.width);
            this.spv.setRange(0, d.height);
            this.prevExH = d.width;
            this.prevExV = d.height;
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public int xOff() {
        return this.sph.getSelection() / this.gridX * this.gridX;
    }

    public int yOff() {
        return this.spv.getSelection() / this.gridY * this.gridY;
    }

    public ScrollerPanel scrollbarHorz() {
        return this.sph;
    }

    public ScrollerPanel scrollbarVert() {
        return this.spv;
    }

    public void forceComponentRepaint() {
        this.repaint();
    }

    public void doLayout() {
        try {
            this.checkComponentValues();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    protected void repaintComponent() {
        try {
            if (!this.isShowing() || this.comp.getX() == 0) {
                return;
            }
            int diffY = this.yOff() - this.prevY;
            int diffX = this.xOff() - this.prevX;
            if (diffX == 0 && diffY == 0) {
                return;
            }
            Point p = this.getLocationOnScreen();
            Dimension d = this.getSize();
            if (diffX != 0 || diffY > 3 * this.comp.getHeight() / 4 || diffX != 0 && diffY != 0 || p.x < 0 || p.x + d.width > NCPanel.ScreenSize.width || p.y < 0 || p.y + d.height > NCPanel.ScreenSize.height) {
                this.comp.repaint();
            } else if (Math.abs(diffY) < this.prevH && diffY != 0) {
                Graphics g = this.comp.getGraphics();
                if (diffY > 0) {
                    g.copyArea(0, diffY, this.prevW, this.prevH - diffY, 0, -diffY);
                    this.comp.paintImmediately(0, this.prevH - diffY, this.prevW, diffY + 2);
                    repainter.doWithDelay(this.job, 5);
                } else {
                    g.copyArea(0, 0, this.prevW, this.prevH + diffY, 0, -diffY);
                    this.comp.paintImmediately(0, 0, this.prevW, -diffY + 2);
                    repainter.doWithDelay(this.job, 5);
                }
                g.dispose();
            } else if (Math.abs(diffX) < this.prevW && diffX != 0) {
                Graphics g = this.comp.getGraphics();
                if (diffX > 0) {
                    g.copyArea(diffX, 0, this.prevW - diffX, this.prevH, -diffX, 0);
                    this.comp.paintImmediately(0, 0, -diffX, this.prevH);
                    repainter.doWithDelay(this.job, 5);
                } else {
                    g.copyArea(0, 0, this.prevW + diffX, this.prevH, -diffX, 0);
                    this.comp.paintImmediately(0, 0, -diffX, this.prevH);
                    repainter.doWithDelay(this.job, 5);
                }
                g.dispose();
            } else {
                this.comp.repaint();
            }
        }
        catch (Exception e) {
            Tracer.This.println("scrollpane" + e);
        }
    }

    public Object actionScrollV(Object arg, Object sender) {
        this.checkComponentValues();
        ((JWScrollable)((Object)this.comp)).setOffsetY(this.yOff());
        this.repaintComponent();
        this.prevY = this.yOff();
        return null;
    }

    public Object actionScrollH(Object arg, Object sender) {
        this.checkComponentValues();
        ((JWScrollable)((Object)this.comp)).setOffsetX(this.xOff());
        this.repaintComponent();
        this.prevX = this.xOff();
        return null;
    }

    public void scrollYTo(int sel) {
        this.scrollbarVert().setSelection(sel);
    }

    public void scrollXTo(int sel) {
        this.scrollbarHorz().setSelection(sel);
    }

    public Dimension getMinimumSize() {
        Dimension compD = new Dimension(3 * ScrollerPanel.BARSIZE, 3 * ScrollerPanel.BARSIZE);
        return compD;
    }

    public boolean scrollToVisibleY(int ymin, int ymax) {
        this.checkComponentValues();
        int h = this.comp.getSize().height;
        if (this.yOff() > Math.min(ymin, ymax) || Math.max(ymin, ymax) - Math.min(ymin, ymax) > h) {
            this.scrollYTo(Math.min(ymin, ymax));
            return true;
        }
        if (h + this.yOff() < Math.max(ymin, ymax)) {
            this.scrollYTo(Math.max(ymin, ymax) - h);
            return true;
        }
        return false;
    }

    public void focusGained(FocusEvent e) {
        this.comp.requestFocus();
    }

    public void requestFocus() {
        this.comp.requestFocus();
    }

    public Dimension getPreferredSize() {
        Dimension compD = this.comp.getPreferredSize();
        compD.width = 100 + ScrollerPanel.BARSIZE;
        compD.height += ScrollerPanel.BARSIZE;
        return compD;
    }

    class RepaintMeJob
    implements Runnable {
        RepaintMeJob() {
        }

        public void run() {
            JWScrollPane.this.repaint();
        }
    }
}

