/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JArray;
import JCollections.JUnsafeTable;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.application.CardPanelEditorHost;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.IClassCreator;
import de.netcomputing.anyj.jwidgets.IHelpAgent;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.TextComponentBugFix;
import de.netcomputing.anyj.jwidgets.WorkerThread;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JTextField;
import netcomputing.tools.Platforms;

public class JWidgetsUtil {
    public static boolean DEBUG = true;
    static Color veryLightColor;
    static Color lightColor;
    static Color darkColor;
    static Color veryDarkColor;
    static Vector ClassPath;
    public static IHelpAgent HelpAgent;
    public static WorkerThread ws;
    public static WorkerThread longterm;
    public static TextComponentBugFix JTextFieldBugFix;

    public static boolean IsAgentShowing() {
        if (HelpAgent == null) {
            return false;
        }
        return HelpAgent.isAgentShowing();
    }

    public static void SetAgentPosition(Window w) {
        if (HelpAgent == null) {
            return;
        }
        HelpAgent.setAgentPosition(w);
    }

    public static void ShowAgent(boolean show) {
        if (HelpAgent == null) {
            return;
        }
        HelpAgent.showAgent(show);
    }

    public static void HelpEvent(String id) {
        if (HelpAgent == null) {
            return;
        }
        HelpAgent.helpEvent(id.replace(' ', '_'));
    }

    public static void CenterOnScreen(Window w) {
        Rectangle dimP = JWidgetsUtil.GetScreenBounds();
        Dimension dimD = w.getSize();
        w.setLocation(dimP.x + dimP.width / 2 - dimD.width / 2, dimP.y + dimP.height / 2 - dimD.height / 2);
    }

    public static void HelpEvent(Component comp) {
        if (HelpAgent == null) {
            return;
        }
        HelpAgent.helpEvent(comp);
    }

    public static Vector ClassPath() {
        if (ClassPath == null) {
            String s = System.getProperty("java.class.path");
            ClassPath = NCStringUtilities.SplitSeparatedString(";", s);
        }
        return ClassPath;
    }

    public static File LocateResource(String name) {
        name = name.replace('/', File.separatorChar);
        File res = null;
        Vector v = JWidgetsUtil.ClassPath();
        v.addElement(".");
        int n = 0;
        while (n < v.size()) {
            res = new File(v.elementAt(n).toString() + name);
            if (res.exists()) break;
            ++n;
        }
        return res;
    }

    public static void EnableAllComponents(Container act, boolean b) {
        Vector v = new Vector(20);
        JWidgetsUtil.AllComponents(v, act);
        int n = 0;
        while (n < v.size()) {
            ((Component)v.elementAt(n)).setEnabled(b);
            ++n;
        }
    }

    public static void AllComponents(Vector v, Container act) {
        if (act == null) {
            return;
        }
        int n = 0;
        while (n < act.countComponents()) {
            v.addElement(act.getComponent(n));
            if (act.getComponent(n) instanceof Container) {
                JWidgetsUtil.AllComponents(v, (Container)act.getComponent(n));
            }
            ++n;
        }
    }

    public static String StackTrace() {
        Exception ex = new Exception();
        ex.fillInStackTrace();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buf);
        ex.printStackTrace(out);
        return buf.toString();
    }

    public static FileInputStream LocateResourceStream(String name) {
        name = name.replace('/', File.separatorChar);
        String s = System.getProperty("java.class.path");
        Vector v = NCStringUtilities.SplitSeparatedString(";", s);
        File res = null;
        int n = 0;
        while (n < v.size()) {
            res = new File(v.elementAt(n).toString() + name);
            if (res.exists()) break;
            ++n;
        }
        try {
            if (res != null) {
                return new FileInputStream(res);
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
        return null;
    }

    public static void CenterWindow(Window f) {
        Rectangle screen = JWidgetsUtil.GetScreenBounds();
        Dimension fd = new Dimension(450, 500);
        f.setBounds(screen.x + (screen.width - fd.width) / 2, screen.y + (screen.height - fd.height) / 2, fd.width, fd.height);
    }

    public static Rectangle GetScreenBounds() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screen = new Rectangle(0, 0, screenSize.width, screenSize.height);
        if (screen.width > 1950) {
            Rectangle screen0 = screen;
            if (EditFrame.host != null && EditApp.App != null && EditApp.App.getMainWindow() != null && EditApp.App.getMainWindow().isShowing() && EditFrame.host instanceof CardPanelEditorHost) {
                screen = EditApp.App.getMainWindow().getBounds();
                if (screen.width > 1000 && screen.height > 600) {
                    return screen;
                }
            }
            screen = screen0;
            if (screen0.width < 3300) {
                screen.width = screen0.width / 2;
            } else if (screen0.width < 5120) {
                screen.width = screen0.width / 3;
            } else if (screen0.width < 5120) {
                screen.width = screen0.width / 4;
            }
        }
        return screen;
    }

    public static void CenterWindow(Window f, Dimension size) {
        Rectangle screen = JWidgetsUtil.GetScreenBounds();
        Dimension fd = size;
        f.setBounds(screen.x + (screen.width - fd.width) / 2, screen.y + (screen.height - fd.height) / 2, fd.width, fd.height);
    }

    public static void CenterWindow(Window f, Window parent) {
        Dimension screen = parent.getSize();
        Dimension fd = f.getSize();
        Point org = parent.getLocationOnScreen();
        f.setBounds(org.x + (screen.width - fd.width) / 2, org.y + (screen.height - fd.height) / 2, fd.width, fd.height);
    }

    public static void ForceToScreenSize(Rectangle r, int minDist) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (!Platforms.IsLinux()) {
            d.height -= 24;
        }
        if (r.x + r.width + minDist > d.width) {
            r.x -= r.x + r.width + minDist - d.width;
        }
        if (r.y + r.height + minDist > d.height) {
            r.y -= r.y + r.height + minDist - d.height;
        }
    }

    public static JArray MakeArrayIfNone(JUnsafeTable tab, Object key) {
        JArray res = (JArray)tab.get(key);
        if (res == null) {
            res = new JArray(10);
            tab.put(key, res);
        }
        return res;
    }

    public static void AddJob(Runnable job) {
        ws.addJob(job);
    }

    public static void AddLongRunningJob(Runnable job) {
        longterm.addJob(job);
    }

    public static boolean IsLongTermQueueEmpty() {
        return longterm.getWaiting();
    }

    public static String Abbrev(String s, int length) {
        if (s.length() < length) {
            return s;
        }
        return s.substring(0, Math.min(length - 1, s.length())) + "..";
    }

    public static void PaintRoundBorder(Graphics g, Color back, Color fore, int w, int h, boolean isPressed) {
        int off = 1;
        if (!isPressed) {
            g.setColor(back);
            g.drawArc(2, 1, h - 1, h - 1, 90, 180);
            g.drawLine(h / 2, h - 1, w - 2, h - 1);
            g.drawLine(w - 2, h, w - 2, 2);
            off = 0;
        }
        g.setColor(fore);
        g.fillArc(off, off, h - 1, h - 1, 90, 180);
        g.fillRect(h / 2 - 1 + off, off, w - h / 2 - 1, h - 1);
    }

    public static void PaintBorder(Graphics g, int w, int h, boolean isPressed) {
        Dimension d = new Dimension();
        JWidgetsUtil.PaintBorder(g, 0, 0, w, h, isPressed, false);
    }

    public static void PaintBorder(Graphics g, int x, int y, int w, int h, boolean isPressed) {
        JWidgetsUtil.PaintBorder(g, 0, 0, w, h, isPressed, false);
    }

    public static void PaintColoredBorder(Graphics g, int x, int y, int w, int h, boolean isPressed, boolean background) {
        JWidgetsUtil.PaintColoredBorder(g, x, y, w, h, isPressed, background, false);
    }

    public static void PaintColoredBorder(Graphics g, int x, int y, int w, int h, boolean isPressed, boolean background, boolean flat) {
        g.translate(x, y);
        Dimension d = new Dimension();
        d.width = w;
        d.height = h;
        --d.width;
        --d.height;
        Color c = g.getColor();
        if (background) {
            g.setColor(c);
            g.fillRect(1, 1, w - 2, h - 2);
        }
        if (!isPressed) {
            g.setColor(JWidgetsUtil.Brightness(c, 140));
            g.drawLine(0, 0, d.width, 0);
            g.drawLine(0, 0, 0, d.height);
            g.setColor(JWidgetsUtil.Brightness(c, 40));
            g.drawLine(0, d.height, d.width, d.height);
            g.drawLine(d.width, d.height, d.width, 0);
        } else {
            g.setColor(JWidgetsUtil.Brightness(c, 40));
            g.drawLine(0, 0, d.width, 0);
            g.drawLine(0, 0, 0, d.height);
            g.setColor(JWidgetsUtil.Brightness(c, 140));
            g.drawLine(0, d.height, d.width, d.height);
            g.drawLine(d.width, d.height, d.width, 0);
        }
        g.translate(-x, -y);
        ++d.width;
        ++d.height;
    }

    public static void PaintBorder(Graphics g, int x, int y, int w, int h, boolean isPressed, boolean background) {
        g.translate(x, y);
        Dimension d = new Dimension();
        d.width = w;
        d.height = h;
        d.width -= 4;
        d.height -= 4;
        if (background) {
            g.setColor(lightColor);
            g.fillRect(1, 1, w - 2, h - 2);
        }
        if (!isPressed) {
            g.setColor(veryLightColor);
            g.drawLine(0, 0, d.width, 0);
            g.drawLine(0, 0, 0, d.height);
            g.setColor(veryDarkColor);
            g.drawLine(1, d.height, d.width, d.height);
            g.drawLine(d.width, d.height, d.width, 1);
        } else {
            g.setColor(veryDarkColor);
            g.drawLine(0, 0, d.width, 0);
            g.drawLine(0, 0, 0, d.height);
            g.setColor(veryLightColor);
            g.drawLine(1, d.height, d.width, d.height);
            g.drawLine(d.width, d.height, d.width, 1);
        }
        g.translate(-x, -y);
    }

    public static void CalcColors() {
        lightColor = JWColor.For("background");
        veryLightColor = JWidgetsUtil.Brightness(lightColor, 140);
        darkColor = JWidgetsUtil.Brightness(lightColor, 75);
        veryDarkColor = JWidgetsUtil.Brightness(lightColor, 40);
    }

    public static Color FakeAlphaColor(Color color, Color back, int alpha, int base) {
        int crgb = color.getRGB();
        int brgb = back.getRGB();
        int res = -16777216;
        res |= 0xFF0000 & (int)((float)(brgb & 0xFF0000) + (float)((crgb & 0xFF0000) - (brgb & 0xFF0000)) * (float)alpha / (float)base);
        res |= 0xFF00 & (int)((float)(brgb & 0xFF00) + (float)((crgb & 0xFF00) - (brgb & 0xFF00)) * (float)alpha / (float)base);
        return new Color(res |= 0xFF & (int)((float)(brgb & 0xFF) + (float)((crgb & 0xFF) - (brgb & 0xFF)) * (float)alpha / (float)base));
    }

    public static Color Brightness(Color col, int perc) {
        int rgb = col.getRGB();
        int res = -16777216;
        return new Color(res |= Math.min(255, (rgb & 0xFF) * perc / 100) + (Math.min(255, ((rgb & 0xFF00) >> 8) * perc / 100) << 8) + (Math.min(255, ((rgb & 0xFF0000) >> 16) * perc / 100) << 16));
    }

    public static Container GetTopComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        Container c = comp.getParent();
        while (c != null && !(c instanceof Window) && !(c instanceof Applet)) {
            c = c.getParent();
        }
        return c;
    }

    public static Container GetTopComponentOne(Component comp) {
        if (comp == null) {
            return null;
        }
        Container c = comp.getParent();
        while (c != null && c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }

    public static Container GetTopNCPanel(Component comp) {
        Container c = comp.getParent();
        while (c != null && !(c instanceof NCPanel)) {
            c = c.getParent();
        }
        return c;
    }

    public static int FakeAlphaColor(int crgb, int brgb, int alpha, int base) {
        int res = -16777216;
        res |= 0xFF0000 & (int)((float)(brgb & 0xFF0000) + (float)((crgb & 0xFF0000) - (brgb & 0xFF0000)) * (float)alpha / (float)base);
        res |= 0xFF00 & (int)((float)(brgb & 0xFF00) + (float)((crgb & 0xFF00) - (brgb & 0xFF00)) * (float)alpha / (float)base);
        return res |= 0xFF & (int)((float)(brgb & 0xFF) + (float)((crgb & 0xFF) - (brgb & 0xFF)) * (float)alpha / (float)base);
    }

    public static void SelectDirToText(IClassCreator cc, final Frame f, final JTextField fileTxt, final String title, NCButton actionTrigger) {
        actionTrigger.addTarget(new Object(){

            public Object action(Object arg, Object sen) {
                String currentSel = fileTxt.getText().trim();
                File sel = AJDirSelector.SelectDirModal(f, null, title, null, currentSel, "");
                if (sel != null) {
                    fileTxt.setText(sel.getAbsolutePath());
                }
                return null;
            }
        }, "action");
    }

    public static void SelectDirToText(IClassCreator cc, final NCPanel f, final JTextField fileTxt, final String title, NCButton actionTrigger) {
        actionTrigger.addTarget(new Object(){

            public Object action(Object arg, Object sen) {
                String currentSel = fileTxt.getText().trim();
                File sel = AJDirSelector.SelectDirModal((Frame)f.getFrame(), null, title, null, currentSel, "");
                if (sel != null) {
                    fileTxt.setText(sel.getAbsolutePath());
                }
                return null;
            }
        }, "action");
    }

    public static void DrawButton(Graphics g, int type, int x, int y, int width, int height) {
        Color arrowColor = (type & 4) != 0 ? Color.red.darker() : Color.black;
        Color backColor = lightColor;
        if ((type & 0x10) == 0) {
            g.setColor(backColor);
            g.fillRect(x + 1, y + 1, width - 3, height - 3);
        }
        if ((type & 8) == 0) {
            if ((type & 2) == 0) {
                g.setColor(backColor);
                g.drawLine(x, y - 1, x + width - 1, y - 1);
                int dist = (height - 1) / 2;
                int foot = Math.min((width + 1) / 4, dist);
                int len = foot + foot;
                int offs = (width - 1) / 2 - foot;
                int run = 0;
                int pos = (type & 1) != 0 ? dist / 2 : height - 2 - dist / 2;
                while (len > 0) {
                    g.setColor(JWidgetsUtil.FakeAlphaColor(backColor, arrowColor, run, dist));
                    g.drawLine(x + offs, y + pos, x + offs + len, y + pos);
                    g.setColor(arrowColor);
                    g.drawLine(x + offs + 1, y + pos, x + offs + len - 1, y + pos);
                    pos += (type & 1) != 0 ? 1 : -1;
                    if ((run += foot) < dist) continue;
                    run %= dist;
                    ++offs;
                    len -= 2;
                }
                g.drawLine(x + offs, y + pos, x + offs + len, y + pos);
            } else {
                g.setColor(backColor);
                g.drawLine(x + width, y, x + width, y + height - 1);
                int dist = (width - 1) / 2;
                int foot = Math.min((height + 1) / 4, dist);
                int len = foot + foot;
                int offs = (height - 1) / 2 - foot;
                int run = 0;
                int pos = (type & 1) != 0 ? 1 + dist / 2 : width - 2 - dist / 2;
                while (len > 0) {
                    g.setColor(JWidgetsUtil.FakeAlphaColor(backColor, arrowColor, run, dist));
                    g.drawLine(x + pos, y + offs, x + pos, y + offs + len);
                    g.setColor(arrowColor);
                    g.drawLine(x + pos, y + offs + 1, x + pos, y + offs + len - 1);
                    pos += (type & 1) != 0 ? 1 : -1;
                    if ((run += foot) < dist) continue;
                    run %= dist;
                    ++offs;
                    len -= 2;
                }
                g.drawLine(x + pos, y + offs, x + pos, y + offs + len);
            }
        } else if ((type & 0x40) == 0) {
            int mx = x + width / 2 - 4;
            int my = y + height / 2 - 4;
            g.setColor(darkColor);
            g.drawRect(mx + 1, my, 1, 5);
            g.drawRect(mx, my + 1, 5, 1);
            g.setColor(Color.black);
            g.drawLine(mx + 2, my, mx + 4, my);
            g.drawLine(mx, my + 2, mx, my + 4);
            g.drawLine(mx + 2, my, mx, my + 2);
            g.setColor(backColor);
            g.drawLine(mx + 3, my + 2, mx + 6, my + 2);
            g.drawLine(mx + 2, my + 3, mx + 2, my + 6);
            g.setColor(Color.white);
            g.drawRect(mx + 4, my + 3, 1, 1);
            g.drawRect(mx + 3, my + 4, 1, 1);
        }
        if ((type & 0x20) == 0) {
            JWidgetsUtil.PaintBorder(g, x, y, width, height, (type & 0xC) == 4);
        }
    }

    public static File ClasspathLookUp(String fullName, String cp) {
        try {
            Vector classPath = NCStringUtilities.SplitSeparatedString(File.pathSeparator, cp);
            fullName = fullName.replace('.', File.separatorChar);
            fullName = fullName.replace('/', File.separatorChar);
            int n = 0;
            while (n < classPath.size()) {
                String dir = classPath.elementAt(n).toString();
                File f = new File(dir + File.separator + fullName + ".class");
                if (f.exists()) {
                    Tracer.This.println("ClasspathLookup RESULT:" + f.getAbsolutePath());
                    return f;
                }
                ++n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        Tracer.This.println("ClasspathLookup NO RESULT:");
        return null;
    }

    static {
        HelpAgent = null;
        ws = new WorkerThread();
        ws.start();
        longterm = new WorkerThread();
        longterm.start();
        JTextFieldBugFix = new TextComponentBugFix();
    }
}

