/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.NCBoundedRangeModel;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScrollerPanel
extends NCPanel {
    public static int BARSIZE = 16;
    JScrollBar sbar;
    NCBoundedRangeModel model;
    int SIZFAK = 1;
    Dimension dim = new Dimension(0, 0);

    public void init() {
        this.init(false);
    }

    public boolean getValueIsAdjusting() {
        return this.model.getValueIsAdjusting();
    }

    public void setEditorMode(boolean b) {
        this.model.isEditor = b;
    }

    public void init(boolean horizontal) {
        this.sbar = new JScrollBar(horizontal ? 0 : 1);
        this.model = new NCBoundedRangeModel();
        this.sbar.setModel(this.model);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.sbar);
        this.model.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ScrollerPanel.this.binder().notifyTargets(ScrollerPanel.this.getSelection());
            }
        });
        this.sbar.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                JWMenuBar.ResetMenu();
                EditFrame ef = EditFrame.Host().getCurrentEditFrame();
                if (ef != null) {
                    ef.closeCompletionPopup();
                }
            }
        });
    }

    public JScrollBar getSbar() {
        return this.sbar;
    }

    public void addKeyListener(KeyListener k) {
        this.sbar.addKeyListener(k);
    }

    void checkPosition() {
    }

    public void setVisibleRange(int d) {
        this.model.setExtent(this.SIZFAK * d);
        this.sbar.setBlockIncrement(this.SIZFAK * d);
        this.checkPosition();
    }

    public void setRange(int start, int end) {
        this.sbar.setMinimum(this.SIZFAK * start);
        this.sbar.setMaximum(this.SIZFAK * end);
        this.checkPosition();
    }

    public void setSelection(int sel) {
        this.model.setValue(this.SIZFAK * sel);
        this.checkPosition();
    }

    public int getVisibleRange() {
        if (this.model.getExtent() == 0) {
            return 0;
        }
        return this.model.getExtent() / this.SIZFAK;
    }

    public int getMinValue() {
        if (this.model.getMinimum() == 0) {
            return 0;
        }
        return this.model.getMinimum() / this.SIZFAK;
    }

    public int getMaxValue() {
        if (this.model.getMaximum() == 0) {
            return 0;
        }
        return this.model.getMaximum() / this.SIZFAK;
    }

    public int getSelection() {
        if (this.model.getValue() == 0) {
            return 0;
        }
        return this.model.getValue() / this.SIZFAK;
    }

    public void beHorizontal(boolean b) {
        this.sbar.setOrientation(this.isHorizontal() ? 0 : 1);
    }

    public boolean isHorizontal() {
        return this.sbar.getOrientation() == 0;
    }

    public void setLineIncrement(int d) {
        this.sbar.setUnitIncrement(this.SIZFAK * d);
    }

    public int getLineIncrement() {
        if (this.sbar.getUnitIncrement() == 0) {
            return 0;
        }
        return this.sbar.getUnitIncrement() / this.SIZFAK;
    }

    public Dimension preferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (!this.isHorizontal()) {
            this.dim.width = this.sbar.getMinimumSize().width;
            this.dim.height = this.size().height;
            return this.dim;
        }
        this.dim.width = this.size().width;
        this.dim.height = this.sbar.getMinimumSize().height;
        return this.dim;
    }

    void calcLineIncrement() {
        if (this.sbar.getUnitIncrement() == 0) {
            this.sbar.setUnitIncrement(this.model.getExtent() / 20);
        }
    }

    public void validate() {
        super.validate();
        this.calcLineIncrement();
    }

    public void focusGained(FocusEvent e) {
        this.getParent().requestFocus();
    }

    public void requestFocus() {
        this.getParent().requestFocus();
    }

    public void page(boolean up) {
        this.setSelection(this.getSelection() + (up ? -this.getVisibleRange() : this.getVisibleRange()));
    }

    public void scroll(boolean up) {
        this.setSelection(this.getSelection() + (up ? -this.getLineIncrement() : this.getLineIncrement()));
    }
}

