/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.IVisual;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.Visual;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

public class TextVisual
extends Visual {
    String text;
    Font font = null;
    public Color bgColor = null;
    public Color fgColor = null;

    public TextVisual(Component par, String _text) {
        this(par, _text, null);
    }

    public TextVisual(Component par, String _text, Font _font) {
        super(par);
        this.text = _text;
        this.font = _font;
    }

    public void paint(Graphics g, int ww, int hh) {
        Font f;
        Font font = f = this.font == null ? this.parent.getFont() : this.font;
        if (this.text.equals("")) {
            return;
        }
        if (this.bgColor != null) {
            g.setColor(this.bgColor);
        } else {
            g.setColor(this.parent.getBackground());
        }
        int w = this.preferredSize().width;
        int h = this.preferredSize().height;
        g.fillRect(0, 0, w, h);
        g.setColor(JWColor.For("label.text"));
        g.setFont(f);
        int tw = this.parent.getFontMetrics(f).stringWidth(this.text);
        int th = this.parent.getFontMetrics(f).getMaxAscent();
        g.drawString(this.text, 2, th);
    }

    public Dimension preferredSize() {
        Font f = this.font == null ? this.parent.getFont() : this.font;
        int sizex = this.parent.getFontMetrics(f).stringWidth(this.text) + 4;
        int sizey = this.parent.getFontMetrics(f).getHeight();
        return new Dimension(sizex, sizey);
    }

    public IVisual clone(String s) {
        if (!s.equals("highlighted") && !s.equals("pressed")) {
            return super.clone(s);
        }
        TextVisual v = null;
        try {
            v = (TextVisual)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (s.equals("grayed")) {
            if (this.fgColor == null) {
                v.fgColor = Color.white;
            }
            if (this.bgColor == null) {
                v.bgColor = Color.gray;
            }
            v.fgColor = v.fgColor.darker();
            v.bgColor = v.bgColor.darker();
        }
        if (s.equals("highlighted") || s.equals("pressed")) {
            v.bgColor = Color.white;
        }
        return v;
    }
}

