/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import JCollections.JArray;
import JCollections.JSet;
import Jack.ISymbolTranslator;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.parsing.RegEntry;
import de.netcomputing.anyj.parsing.Scope;
import de.netcomputing.anyj.parsing.SyntaxAnalyzer;
import de.netcomputing.anyj.parsing.UsageSearch;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import editapp.ClassDescription;
import editapp.FileRegistry;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class ScopeRegistry {
    static boolean useSourceBase = true;
    HashMap clazzNameToRegEntry;
    HashMap clazzNameToRealScope;
    Vector sourcePath;
    String sourcePathString;
    static HashMap regHash = new HashMap();
    HashSet parsed = new HashSet();
    HashMap spCache = new HashMap();
    HashMap packCache = new HashMap(500);

    public static ScopeRegistry New(String sp) {
        return new ScopeRegistry(sp);
    }

    public ScopeRegistry(String sp) {
        this.clazzNameToRegEntry = new HashMap(1000);
        this.clazzNameToRealScope = new HashMap(1000);
        this.setSourcePath(sp);
        this.sourcePathString = sp;
    }

    public void putClazzScope(String fullQualiClazz, Scope s) {
        this.clazzNameToRealScope.put(fullQualiClazz, s);
        if (UsageSearch.DEBUG) {
            System.out.println("PUT TO CLAZZ REGISTRY BY SCOPE:" + fullQualiClazz);
        }
    }

    public Scope getRoot(String fullQualiClazz) {
        RegEntry en = this.getEntry(fullQualiClazz);
        if (en != null) {
            return en.root;
        }
        return null;
    }

    public boolean canFree(String fullQualiClazz) {
        return true;
    }

    public Scope getClazzRoot(String fullQualiClazz) {
        if (fullQualiClazz == null) {
            return null;
        }
        Scope res = (Scope)this.clazzNameToRealScope.get(fullQualiClazz);
        if (res == null) {
            this.getRoot(fullQualiClazz);
            res = (Scope)this.clazzNameToRealScope.get(fullQualiClazz);
        }
        return res;
    }

    public int getNumParsedFiles() {
        return this.clazzNameToRealScope.size();
    }

    public HashMap getScopeMap(String fullQualiClazz) {
        return this.getEntry((String)fullQualiClazz).scopMap;
    }

    public ISymbolTranslator getSymbolTranslator(String fullQualiClazz) {
        return this.getEntry((String)fullQualiClazz).symbolTranslator;
    }

    RegEntry getEntry(String fullQualiClazz) {
        RegEntry result = (RegEntry)this.clazzNameToRegEntry.get(fullQualiClazz);
        if (result == null) {
            File f;
            if (useSourceBase) {
                ArrayList scopes = this.createScopeFromSourceBase(fullQualiClazz);
                if (scopes == null) {
                    return null;
                }
                int i = 0;
                while (i < scopes.size()) {
                    Scope scp = (Scope)scopes.get(i);
                    if (scp != null) {
                        RegEntry regen = new RegEntry();
                        regen.root = scp;
                        regen.symbolTranslator = null;
                        regen.scopMap = null;
                        String fqc = scp.getClazz();
                        if (UsageSearch.DEBUG) {
                            System.out.println("PUT TO CLAZZ REGISTRY SB:" + fqc);
                        }
                        this.clazzNameToRegEntry.put(fqc, regen);
                        this.putClazzScope(fqc, scp);
                    }
                    ++i;
                }
                result = (RegEntry)this.clazzNameToRegEntry.get(fullQualiClazz);
                if (result != null) {
                    return result;
                }
            }
            if ((f = this.sourcepathLookUp(fullQualiClazz)) == null) {
                return null;
            }
            try {
                result = this.buildRoot(f);
                this.clazzNameToRegEntry.put(fullQualiClazz, result);
                if (UsageSearch.DEBUG) {
                    System.out.println("PUT TO CLAZZ REGISTRY BY PARSE:" + fullQualiClazz);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    RegEntry buildRoot(File f) throws Exception {
        if (this.parsed.contains(f.getAbsolutePath())) {
            System.out.println("############## REPARSE:" + f);
            JWidgetsUtil.StackTrace();
        }
        this.parsed.add(f.getAbsolutePath());
        SyntaxAnalyzer analyzer = new SyntaxAnalyzer();
        long tim = System.currentTimeMillis();
        Scope root = new Scope("root", null);
        root.setScopeRegistry(this);
        Vector parsed = analyzer.parseBuildingScope(f.getAbsolutePath(), root);
        RegEntry result = new RegEntry();
        result.root = analyzer.rootScope;
        result.symbolTranslator = analyzer.clone;
        result.scopMap = analyzer.getScopeMap();
        if (parsed.size() > 1) {
            return null;
        }
        return result;
    }

    public File sourcepathLookUp(String fullName) {
        Object o = this.spCache.get(fullName);
        if (o != null) {
            return o instanceof String ? null : (File)o;
        }
        File res = ScopeRegistry.sourcepathLookUp(this.sourcePath, fullName);
        if (res == null) {
            this.spCache.put(fullName, "**NULL**");
        } else {
            this.spCache.put(fullName, res);
        }
        return res;
    }

    public static File sourcepathLookUp(Vector path, String fullName) {
        return NCFileUtilities.SourcepathLookUp(path, fullName);
    }

    public void setSourcePath(String sp) {
        this.sourcePath = NCStringUtilities.SplitSeparatedString(File.pathSeparator, sp);
        this.clearCaches();
    }

    public void clearCaches() {
        this.packCache.clear();
        this.spCache.clear();
    }

    public String checkForPackageType(String fullName0) {
        String s = (String)this.packCache.get(fullName0);
        if (s != null) {
            return s.equals("**NULL**") ? null : s;
        }
        String fullName = fullName0;
        if (fullName == null) {
            return null;
        }
        try {
            fullName = fullName.replace('.', File.separatorChar);
            fullName = fullName.replace('/', File.separatorChar);
            int n = 0;
            while (n < this.sourcePath.size()) {
                String dir = this.sourcePath.elementAt(n).toString();
                File f = new File(dir + File.separator + fullName);
                if (f.exists() && f.getAbsolutePath().equals(f.getAbsolutePath())) {
                    this.packCache.put(fullName0, fullName0);
                    return fullName0;
                }
                ++n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.sourcepathLookUp(fullName0) != null) {
            this.packCache.put(fullName0, fullName0);
            return fullName0;
        }
        this.packCache.put(fullName0, "**NULL**");
        return null;
    }

    ArrayList createScopeFromSourceBase(String fqClazz) {
        SourceBase sb = SourceBase.This();
        IndexEntry clazzIE = sb.getClassDef(fqClazz);
        if (clazzIE == null) {
            return null;
        }
        sb.update(clazzIE.fileString());
        ArrayList<Scope> result = new ArrayList<Scope>(4);
        JArray arr = sb.classDefinitionsIn(clazzIE.fileString());
        int i = 0;
        while (i < arr.size()) {
            IndexEntry clsIE = (IndexEntry)arr.at(i);
            ClassDescription clsdesc = (ClassDescription)clsIE.decl();
            Scope res = this.createScopeFromIE(sb, clsdesc.packageName() + "." + clsdesc.getClassName(), clsIE);
            result.add(res);
            ++i;
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    Scope createScopeFromIE(SourceBase sb, String fqClazz, IndexEntry clazzIE) {
        int pointIndex = fqClazz.lastIndexOf(".");
        Scope scp = new Scope(fqClazz, null);
        String[] imports = FileRegistry.This.get(clazzIE.fileString()).imports();
        HashSet<String> imps = new HashSet<String>(imports.length);
        int i = 0;
        while (i < imports.length) {
            imps.add(imports[i]);
            ++i;
        }
        scp.setImports(imps);
        scp.setFile(clazzIE.fileString());
        scp.setIsClazzScope(true);
        scp.setClazz(fqClazz);
        scp.setPack(fqClazz.substring(0, pointIndex));
        scp.setScopeRegistry(this);
        scp.addSuperClazz(clazzIE.getSuperClass());
        JSet interf = ((ClassDescription)clazzIE.decl()).interfaceSet();
        Enumeration en = interf.enumerate();
        while (en.hasMoreElements()) {
            scp.addSuperClazz((String)en.nextElement());
        }
        ArrayList res = sb.getMethodsAndFieldsOf(clazzIE);
        int i2 = 0;
        while (i2 < res.size()) {
            IndexEntry field = (IndexEntry)res.get(i2);
            if (field.isMethod()) {
                String name = field.getName();
                int ii = name.indexOf(40);
                if (ii >= 0) {
                    name = name.substring(0, ii);
                }
                scp.putMethod(name, field.getType());
            } else if (field.isField()) {
                scp.putVar(field.getName(), field.getType());
            }
            ++i2;
        }
        return scp;
    }

    public static String guessName(Vector sp, String absPath) {
        int n = 0;
        while (n < sp.size()) {
            if (absPath.startsWith((String)sp.elementAt(n))) {
                if ((absPath = absPath.substring(((String)sp.elementAt(n)).length())).endsWith(".java")) {
                    absPath = absPath.substring(0, absPath.length() - 5);
                }
                while (absPath.startsWith(File.separator)) {
                    absPath = absPath.substring(1);
                }
                while (absPath.endsWith(File.separator)) {
                    absPath = absPath.substring(0, absPath.length() - 1);
                }
                absPath = absPath.replace(File.separatorChar, '.');
                return absPath;
            }
            ++n;
        }
        return null;
    }
}

