/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.services;

import Jxe.CollapsedTextLine;
import Jxe.TextDocument;
import Jxe.TextView;
import de.netcomputing.anyj.TemplateOptions;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import editapp.EditApp;
import editapp.IndexEntry;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import jxeplugins.DocumentPosition;
import jxeplugins.JEBasicService;

public class AJEditingServices {
    public static void RegisterServices() {
        JEBasicService ser = new JEBasicService("Split Window", "Show in Splitted Editor", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && !((File)selection).isDirectory() || selection instanceof IndexEntry;
            }

            public void doProcess(Object selection, Object selector) {
                if (selection instanceof IndexEntry) {
                    IndexEntry ie = (IndexEntry)selection;
                    TextDocument tmpDoc = new TextDocument(new File(ie.fileString()));
                    EditApp.App.jol.showSecondDoc(tmpDoc);
                    DocumentPosition pos = ie.docPos();
                    tmpDoc.centerPosition(pos.getLine() - 1);
                } else {
                    TextDocument doc = EditApp.App.findOpenFileNamed(((File)selection).getAbsolutePath());
                    TextDocument tmpDoc = new TextDocument((File)selection);
                    EditApp.App.jol.showSecondDoc(tmpDoc);
                    tmpDoc.moveCursorAbs(doc.cX(), doc.cY());
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Edit", "Trim Selection", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof TextDocument && ((TextDocument)selection).hasSelection();
            }

            public void doProcess(Object selection, Object selector) {
                ((TextDocument)selection).trimSelection();
                ((TextDocument)selection).repaint();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Folding", "Collapse Block", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof TextDocument)) {
                    return false;
                }
                TextDocument doc = (TextDocument)selection;
                if (doc.hasSelection()) {
                    return false;
                }
                return doc.getFile() != null && doc.getFile().getName().endsWith(".java");
            }

            public void doProcess(Object selection, Object selector) {
                ((TextDocument)selection).collapseBlock();
                ((TextDocument)selection).markUndoDiff();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Folding", "Collapse All", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof TextDocument)) {
                    return false;
                }
                TextDocument doc = (TextDocument)selection;
                if (doc.hasSelection()) {
                    return false;
                }
                return doc.getFile() != null && doc.getFile().getName().endsWith(".java");
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument doc = (TextDocument)selection;
                TextView tv = doc.getView();
                doc.setView(null);
                doc.collapseToLevel(2);
                doc.setView(tv);
                doc.centerPosition();
                doc.repaintAll();
                ((TextDocument)selection).markUndoDiff();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Folding", "Collapse Level 2", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof TextDocument)) {
                    return false;
                }
                TextDocument doc = (TextDocument)selection;
                if (doc.hasSelection()) {
                    return false;
                }
                return doc.getFile() != null && doc.getFile().getName().endsWith(".java");
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument doc = (TextDocument)selection;
                TextView tv = doc.getView();
                doc.setView(null);
                doc.collapseToLevel(3);
                doc.setView(tv);
                doc.centerPosition();
                doc.repaintAll();
                ((TextDocument)selection).markUndoDiff();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Folding", "Collapse Comments", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof TextDocument)) {
                    return false;
                }
                TextDocument doc = (TextDocument)selection;
                if (doc.hasSelection()) {
                    return false;
                }
                return doc.getFile() != null && doc.getFile().getName().endsWith(".java");
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument doc = (TextDocument)selection;
                TextView tv = doc.getView();
                doc.setView(null);
                doc.collapseComments();
                doc.setView(tv);
                doc.centerPosition();
                doc.repaintAll();
                ((TextDocument)selection).markUndoDiff();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Folding", "Expand All", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof TextDocument)) {
                    return false;
                }
                TextDocument doc = (TextDocument)selection;
                if (doc.hasSelection()) {
                    return false;
                }
                return doc.getFile() != null && doc.getFile().getName().endsWith(".java");
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument doc = (TextDocument)selection;
                TextView tv = doc.getView();
                doc.setView(null);
                doc.expandAll();
                doc.setView(tv);
                doc.centerPosition();
                doc.repaintAll();
                ((TextDocument)selection).markUndoDiff();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Folding", "Expand Block", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof TextDocument)) {
                    return false;
                }
                TextDocument doc = (TextDocument)selection;
                if (doc.hasSelection()) {
                    return false;
                }
                return doc.getFile() != null && doc.getFile().getName().endsWith(".java") && doc.lineAt(doc.cY()) instanceof CollapsedTextLine;
            }

            public void doProcess(Object selection, Object selector) {
                ((TextDocument)selection).expandBlock();
                ((TextDocument)selection).markUndoDiff();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("", "Paste from ClipboardRing", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof TextDocument && TextDocument.clipBoardRing.size() > 0;
            }

            public void doProcess(Object selection, Object selector) {
                JWidgetsUtil.AddJob(new Runnable(this, selection){
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 9 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        ArrayList tmpRing = TextDocument.clipBoardRing;
                        Object[] o = new Object[tmpRing.size()];
                        int i = 0;
                        while (i < tmpRing.size()) {
                            o[i] = tmpRing.get(i);
                            ++i;
                        }
                        int sel = -1;
                        Rectangle screen = JWidgetsUtil.GetScreenBounds();
                        sel = ConfirmDiag.Select(EditApp.App.getMainWindow(), o, screen.x + screen.width / 2 - 80, screen.y + screen.height / 2 - o.length * 7);
                        if (sel >= 0) {
                            TextDocument doc = (TextDocument)this.val$selection;
                            if (doc.hasSelection()) {
                                doc.cutSelection();
                            }
                            doc.pasteString((String)tmpRing.get(sel));
                        }
                    }
                });
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Split Window", "Hide Splitted Editor", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                EditApp.App.jol.hideSecondDoc();
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Insert Template", "Add New Template", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument sel = null;
                EditFrame ef = EditFrame.Host().getCurrentEditFrame();
                if (ef != null && ef.getDocument().hasSelection()) {
                    sel = ef.getDocument().getSelection();
                }
                EditApp.App.openOptions("Global.Templates");
                TemplateOptions.This.addTemplate(sel);
            }
        };
        EditApp.ServReg.addService(ser);
    }
}

