/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.snapshots;

import JWVFile.VFile;
import java.io.File;
import java.util.ArrayList;

public class SnapShotRegistry {
    public String rootDir;
    static SnapShotRegistry This;

    public static SnapShotRegistry This() {
        if (This == null) {
            new VFile("#userdata/snapshots").mkdirs();
            This = new SnapShotRegistry(VFile.ResolveName("#userdata/snapshots"));
        }
        return This;
    }

    public SnapShotRegistry(String root) {
        this.rootDir = root;
    }

    private String getCopyTargetRoot(String fileDir, String tag) {
        fileDir = fileDir.replace(':', File.separatorChar);
        return tag + File.separator + fileDir;
    }

    public String getCopyTargetFile(File copyTargetFile, String tag) {
        String fi = null;
        fi = !copyTargetFile.isDirectory() ? this.getCopyTargetRoot(copyTargetFile.getParent(), tag) : this.getCopyTargetRoot(copyTargetFile.getAbsolutePath(), tag);
        return this.rootDir + File.separator + fi + File.separator + copyTargetFile.getName();
    }

    public void makeSnapShot(File f, String tag) throws Exception {
        String target = this.getCopyTargetFile(f, tag);
        if (!new File(target).exists() && !f.isDirectory()) {
            new File(target).getParentFile().mkdirs();
            VFile.Copy(f, new File(target));
        }
    }

    public ArrayList getTagsFor(String selDir) {
        ArrayList<String[]> res = new ArrayList<String[]>();
        File rt = new File(this.rootDir);
        String[] dirs = rt.list();
        int i = 0;
        while (dirs != null && i < dirs.length) {
            File cur = new File(this.rootDir, dirs[i]);
            if (cur.isDirectory()) {
                String targ = this.rootDir + File.separator + this.getCopyTargetRoot(selDir, dirs[i]);
                File targetFile = new File(targ = VFile.StripDoubleSeps(targ, File.separatorChar).toString());
                if (targetFile.exists()) {
                    res.add(new String[]{dirs[i], targ});
                }
            }
            ++i;
        }
        return res;
    }
}

