/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.wombatanalyzer;

import JCollections.DirIterator;
import JCollections.JArray;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.util.NCCollectionUtil;
import de.netcomputing.util.Tracer;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JProgressBar;
import util.ClassFile;

public class WombatAnalyzer {
    HashMap packages = new HashMap(10);
    HashMap classesPackages = new HashMap(10);
    HashSet imports = new HashSet(10);
    HashSet jars = new HashSet(11);

    void magicDir(File dir, HashMap packages, HashMap classPackages, HashSet jars, HashSet imports, JProgressBar progress) {
        String[] cont = dir.list();
        if (cont != null) {
            if (progress != null) {
                progress.setMinimum(0);
                progress.setMaximum(cont.length);
            }
            int n = 0;
            while (n < cont.length) {
                File act = new File(dir, cont[n]);
                if (progress != null) {
                    progress.setValue(n);
                    progress.setString(cont[n]);
                }
                if (act.getName().toLowerCase().endsWith(".jar")) {
                    if (!act.getName().equals("rt.jar")) {
                        jars.add(act);
                        try {
                            ZipFile zf = new ZipFile(act);
                            Enumeration<? extends ZipEntry> en = zf.entries();
                            while (en.hasMoreElements()) {
                                ZipEntry ze = en.nextElement();
                                if (!ze.isDirectory()) continue;
                                String pack = ze.getName().substring(0, ze.getName().length() - 1);
                                pack = pack.replace('/', '.');
                                pack = pack.replace('\\', '.');
                                WombatAnalyzer.putVect(classPackages, pack, act);
                            }
                            zf.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                } else if (act.getName().toLowerCase().endsWith(".java")) {
                    JArray pks = new JArray(10);
                    String pack = DocumentStream.ScanImports(new TextDocument(act), pks);
                    if (pack != null) {
                        WombatAnalyzer.putVect(packages, pack, AJCompileAndBuild.findRoot(pack, act.getParent()));
                    }
                    Enumeration en = pks.enumerate();
                    while (en.hasMoreElements()) {
                        imports.add(en.nextElement());
                    }
                } else if (act.getName().toLowerCase().endsWith(".class")) {
                    String pack = null;
                    try {
                        pack = ClassFile.ScanPackage(act.getAbsolutePath());
                        int i = pack.lastIndexOf(46);
                        pack = i >= 0 ? pack.substring(0, i) : "";
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (pack != null) {
                        WombatAnalyzer.putVect(classPackages, pack, AJCompileAndBuild.findRoot(pack, act.getParent()));
                    }
                }
                ++n;
            }
        }
    }

    void removeRoot(HashMap packageMap, Object path) {
        Iterator it = packageMap.values().iterator();
        while (it.hasNext()) {
            Set s = (Set)it.next();
            if (s == null) continue;
            Tracer.This.println("removing:" + path + " " + s.contains(path));
            s.remove(path);
        }
    }

    public void doMagic(Vector dirs, JProgressBar progress) {
        Iterator is;
        Set s;
        int dirIdx = 0;
        while (dirIdx < dirs.size()) {
            Vector dirCont = DirIterator.DirContent(new File(dirs.get(dirIdx).toString()), "none");
            int n = 0;
            while (n < dirCont.size()) {
                this.magicDir((File)dirCont.get(n), this.packages, this.classesPackages, this.jars, this.imports, progress);
                ++n;
            }
            ++dirIdx;
        }
        Tracer.This.println("=================== SOURCE PACKAGES ===========================");
        Iterator<Object> it = this.packages.keySet().iterator();
        while (it.hasNext()) {
            Object pack = it.next();
            Tracer.This.println(pack);
            s = (Set)this.packages.get(pack);
            is = s.iterator();
            while (is.hasNext()) {
                Tracer.This.println("     " + is.next());
            }
        }
        Tracer.This.println("=================== IMPORTS ===========================");
        it = this.imports.iterator();
        while (it.hasNext()) {
            Tracer.This.println(it.next());
        }
        Tracer.This.println("=================== CLASS PACKAGES ===========================");
        it = this.classesPackages.keySet().iterator();
        while (it.hasNext()) {
            Object pack = it.next();
            Tracer.This.println(pack);
            s = (Set)this.classesPackages.get(pack);
            if (s == null) continue;
            is = s.iterator();
            while (is.hasNext()) {
                Tracer.This.println("     " + is.next());
            }
        }
        if (progress != null) {
            progress.setValue(0);
            progress.setString("finished");
        }
    }

    static void putVect(HashMap map, Object key, Object value) {
        NCCollectionUtil.PutVect(map, key, value);
    }

    public Set computeSourceRoots() {
        HashSet result = new HashSet();
        Iterator it = this.packages.keySet().iterator();
        while (it.hasNext()) {
            Object pack = it.next();
            Set s = (Set)this.packages.get(pack);
            result.addAll(s);
        }
        return result;
    }

    public Set computeClassRoots() {
        HashSet result = new HashSet();
        Iterator it = this.classesPackages.keySet().iterator();
        while (it.hasNext()) {
            Object pack = it.next();
            Set s = (Set)this.classesPackages.get(pack);
            result.addAll(s);
        }
        return result;
    }

    public Set getConflictPackages(String rootA, String rootB) {
        HashSet res = this.getConflictPackages(rootA, rootB, this.packages);
        res.addAll(this.getConflictPackages(rootA, rootB, this.classesPackages));
        return res;
    }

    HashSet getConflictPackages(String rootA, String rootB, HashMap packMap) {
        HashSet<Object> result = new HashSet<Object>();
        Iterator it = packMap.keySet().iterator();
        while (it.hasNext()) {
            Object pk = null;
            Object k = it.next();
            pk = k;
            Set s = (Set)packMap.get(k);
            if (s == null || s.size() <= 1 || !s.contains(rootA) || !s.contains(rootB)) continue;
            result.add(pk);
        }
        return result;
    }

    public Set getConflictRoots(String root) {
        HashSet res = this.getConflictRoots(root, this.packages);
        res.addAll(this.getConflictRoots(root, this.classesPackages));
        return res;
    }

    HashSet getConflictRoots(String root, HashMap packMap) {
        HashSet result = new HashSet();
        Iterator it = packMap.keySet().iterator();
        while (it.hasNext()) {
            Set s = (Set)packMap.get(it.next());
            if (s == null || !s.contains(root) || s.size() <= 1) continue;
            Iterator iit = s.iterator();
            while (iit.hasNext()) {
                Object cur = iit.next();
                if (cur.equals(root)) continue;
                result.add(cur);
            }
        }
        return result;
    }
}

