/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.application.services;

import Jxe.EditCanvas;
import de.netcomputing.anyj.jwidgets.IDataItem;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.application.services.INCService;
import de.netcomputing.application.services.INCServiceRegistryListener;
import de.netcomputing.util.NCCollectionUtilities;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Hashtable;
import editapp.EditApp;
import editapp.JServiceMenuItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class NCServiceRegistry {
    public static int SHORTCUTDELAY = 1000;
    protected ArrayList services = new ArrayList();
    protected ArrayList listeners = new ArrayList();
    public static JPopupMenu lastOne;
    protected INCService lastSelectedService;

    public void addServiceRegistryListener(INCServiceRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeServiceRegistryListener(INCServiceRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeEvent(ChangeEvent ev) {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            ((INCServiceRegistryListener)this.listeners.get(i)).servicesChanged(ev);
            --i;
        }
    }

    public void addService(INCService ser) {
        int idx = this.services.indexOf(ser);
        Object oldser = null;
        if (idx >= 0) {
            oldser = this.services.get(idx);
        }
        if (oldser != null) {
            INCService oSer = oldser;
            ser.copyAttributes(oSer);
            this.services.remove(oldser);
        }
        this.services.add(ser);
    }

    public void setServices(ArrayList sers) {
        this.services = sers;
    }

    public ArrayList getServices() {
        return this.services;
    }

    public ArrayList getServices(String category, Object selection, Object selector) {
        ArrayList<INCService> res = new ArrayList<INCService>(10);
        int n = 0;
        while (n < this.services.size()) {
            INCService serv = (INCService)this.services.get(n);
            if (serv.getCategory().equals(category) && serv.canProcess(selection, selector)) {
                res.add(serv);
            }
            ++n;
        }
        return res;
    }

    public JPopupMenu buildCategoryPopup(String[] categs, final Set disabled) {
        int catCount = 0;
        int n = 0;
        while (n < categs.length) {
            if (!"-".equals(categs[n])) {
                ++catCount;
            }
            ++n;
        }
        String[] s = new String[catCount];
        catCount = 0;
        int n2 = 0;
        while (n2 < categs.length) {
            if (!"-".equals(categs[n2])) {
                String tmp = categs[n2];
                if (tmp.startsWith("=>")) {
                    tmp = tmp.substring(2);
                }
                s[catCount++] = tmp;
            }
            ++n2;
        }
        JPopupMenu result = new JPopupMenu();
        int n3 = 0;
        while (n3 < s.length) {
            final String finalSN = s[n3];
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem(s[n3], !disabled.contains(s[n3])){

                public String getText() {
                    return "".equals(finalSN) ? "Copy/Paste" : finalSN;
                }
            };
            item.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent ev) {
                    if (item.isSelected()) {
                        disabled.remove(finalSN);
                    } else {
                        disabled.add(finalSN);
                    }
                    NCServiceRegistry.this.fireChangeEvent(new ChangeEvent(this));
                }
            });
            result.add(item);
            ++n3;
        }
        return result;
    }

    public String[] getServiceCategories() {
        HashSet<String> map = new HashSet<String>(20);
        int n = 0;
        while (n < this.services.size()) {
            map.add(((INCService)this.services.get(n)).getCategory());
            ++n;
        }
        Object[] res = map.toArray();
        NCCollectionUtilities.SortByString(res);
        String[] result = new String[res.length];
        int n2 = 0;
        while (n2 < result.length) {
            result[n2] = (String)res[n2];
            ++n2;
        }
        return result;
    }

    public void remService(INCService ser) {
        this.services.remove(ser);
    }

    public void remCategory(String s) {
        int n = this.services.size() - 1;
        while (n >= 0) {
            if (((INCService)this.services.get(n)).getCategory().equals(s)) {
                this.services.remove(n);
            }
            --n;
        }
    }

    public void remServiceNamed(String ser) {
        int n = this.services.size() - 1;
        while (n >= 0) {
            if (this.services.get(n).toString().equals(ser)) {
                this.services.remove(n);
            }
            --n;
        }
        int n2 = this.services.size() - 1;
        while (n2 >= 0) {
            if (((INCService)this.services.get(n2)).getMenuName().equals(ser)) {
                this.services.remove(n2);
                --n2;
            }
            --n2;
        }
    }

    public INCService getServiceNamed(String ser) {
        int n = 0;
        while (n < this.services.size()) {
            if (this.services.get(n).toString().equals(ser)) {
                return (INCService)this.services.get(n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.services.size()) {
            if (((INCService)this.services.get(n2)).getMenuName().equals(ser)) {
                return (INCService)this.services.get(n2);
            }
            ++n2;
        }
        return null;
    }

    public JMenuBar buildFullJMenuBar(String[] cats) {
        JMenuBar jwb = new JMenuBar();
        Hashtable categories = new Hashtable();
        ArrayList servs = this.getServices();
        Collections.sort(servs);
        int n = 0;
        while (n < servs.size()) {
            INCService serv = (INCService)servs.get(n);
            JMenu submen = (JMenu)categories.get(serv.getCategory());
            if (submen == null) {
                submen = new JMenu(serv.getCategory());
                categories.put(serv.getCategory(), submen);
            }
            INCService finalServ = serv;
            final JServiceMenuItem js = new JServiceMenuItem(serv, submen);
            submen.add(js);
            js.setIcon(js.im);
            JMenu finalMen = submen;
            js.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    NCServiceRegistry.this.itemEntered(js);
                }
            });
            ++n;
        }
        String actCat = null;
        JMenu curr = null;
        JMenu servCat = null;
        boolean expand = true;
        HashSet<Character> topMnemonics = new HashSet<Character>(7);
        int n2 = -1;
        while (n2 < cats.length) {
            if (n2 == -1 || cats[n2] == null) {
                actCat = cats[n2 + 1];
                curr = new JMenu(actCat);
                jwb.add(curr);
                JServiceMenuItem.ResetShortCutTab();
                if (actCat.length() > 0) {
                    JServiceMenuItem.PutToShortCutTab(new Character(Character.toLowerCase(actCat.charAt(0))));
                    JServiceMenuItem.PutToShortCutTab(new Character(Character.toUpperCase(actCat.charAt(0))));
                    int mnemIdx = 0;
                    while (topMnemonics.contains(new Character(actCat.charAt(mnemIdx)))) {
                        ++mnemIdx;
                    }
                    curr.setMnemonic(actCat.charAt(mnemIdx));
                    topMnemonics.add(new Character(actCat.charAt(mnemIdx)));
                }
                ++n2;
            } else if (cats[n2].equals("-")) {
                curr.addSeparator();
            } else {
                String curCat = cats[n2];
                if (curCat.startsWith("=>")) {
                    curCat = curCat.substring(2);
                    expand = false;
                } else {
                    expand = true;
                }
                servCat = (JMenu)categories.get(curCat);
                if (servCat != null) {
                    JServiceMenuItem actServMen;
                    int nn;
                    Component[] subs;
                    if (!expand) {
                        curr.add(servCat);
                        servCat.setIcon(JServiceMenuItem.GetEmptyIcon());
                        subs = servCat.getMenuComponents();
                        nn = 0;
                        while (subs != null && nn < subs.length) {
                            if (subs[nn] instanceof JServiceMenuItem) {
                                actServMen = (JServiceMenuItem)subs[nn];
                                actServMen.addMouseListener(new MouseAdapter(){

                                    public void mouseEntered(MouseEvent e) {
                                        NCServiceRegistry.this.lastSelectedService = actServMen.getService();
                                        NCServiceRegistry.this.itemEntered(actServMen);
                                    }
                                });
                            }
                            ++nn;
                        }
                    } else {
                        subs = servCat.getMenuComponents();
                        nn = 0;
                        while (subs != null && nn < subs.length) {
                            if (subs[nn] instanceof JServiceMenuItem) {
                                actServMen = (JServiceMenuItem)subs[nn];
                                actServMen.recalcMnemonic();
                                actServMen.setPar(curr);
                                curr.add(actServMen);
                                JMenu finalCurr = curr;
                                actServMen.addMouseListener(new MouseAdapter(){

                                    public void mouseEntered(MouseEvent e) {
                                        NCServiceRegistry.this.lastSelectedService = actServMen.getService();
                                        NCServiceRegistry.this.itemEntered(actServMen);
                                    }
                                });
                            }
                            ++nn;
                        }
                    }
                } else {
                    Tracer.This.println("unknown category0:" + cats[n2]);
                }
            }
            ++n2;
        }
        return jwb;
    }

    protected HashSet getValidServicesFor(List selections, Object requestor, HashMap serMap) {
        return this.getValidServicesFor(selections, requestor, serMap, false);
    }

    protected abstract void mutateString(String var1, List var2, Object var3, int var4);

    protected HashSet getValidServicesFor(List selections, Object requestor, HashMap serMap, boolean all) {
        HashSet valid = new HashSet(20);
        int mutateCount = 0;
        int nn = 0;
        while (nn < selections.size()) {
            Object selection = selections.get(nn);
            if (selection instanceof IDataItem) {
                selection = ((IDataItem)selection).dataObject();
            }
            if (selection instanceof String) {
                ++mutateCount;
                this.mutateString(selection.toString(), selections, requestor, nn + 1);
            }
            int n = 0;
            while (n < this.services.size()) {
                try {
                    INCService tmp;
                    INCService serv = (INCService)this.services.get(n);
                    if (this.isServiceValidForRequestor(selection, requestor, serv, all) && ((tmp = (INCService)(valid.contains(this.services.get(n)) ? this.services.get(n) : null)) == null || tmp.getUsage() < serv.getUsage())) {
                        valid.add(this.services.get(n));
                        serMap.put(serv, new Object[]{selection, requestor});
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++n;
            }
            ++nn;
        }
        Tracer.This.println("-----: selection size:" + selections.size() + " mutateCount:" + mutateCount + " services.size():" + this.services.size());
        return valid;
    }

    protected boolean isServiceValidForRequestor(Object selection, Object requestor, INCService serv, boolean all) {
        return !(requestor instanceof JListPanel && !serv.getShowInList() && !all || requestor instanceof EditCanvas && !serv.getShowInEditor() && !all || !serv.canProcess(selection, requestor));
    }

    protected Action createAction(final INCService ser, final Object sel, final Object req) {
        return new AbstractAction(){
            INCService service;
            Object selection;
            Object requestor;
            {
                this.service = ser;
                this.selection = sel;
                this.requestor = req;
            }

            public void actionPerformed(ActionEvent arg) {
                ser.doProcess(sel, req);
            }
        };
    }

    protected Object createActionListener(final INCService ser, final Object sel, final Object req) {
        return new ActionListener(){
            INCService service;
            Object selection;
            Object requestor;
            {
                this.service = ser;
                this.selection = sel;
                this.requestor = req;
            }

            public void actionPerformed(ActionEvent arg) {
                ser.doProcess(sel, req);
            }
        };
    }

    public JPopupMenu getMenu(Object requestor, Object something) {
        return this.getMenu(requestor, this.findSelectionFromObject(requestor, something), this.getDefaultPopMenu());
    }

    public JPopupMenu getMenu(Object requestor, Object something, String[] menuCat) {
        return this.getMenu(requestor, this.findSelectionFromObject(requestor, something), menuCat);
    }

    public JPopupMenu getMenu(Object requestor, List selection, String[] cats) {
        HashMap serMap = new HashMap(20);
        JPopupMenu jwb = new JPopupMenu();
        jwb.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                EditApp.MenuOpen = true;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                EditApp.MenuOpen = false;
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                EditApp.MenuOpen = false;
            }
        });
        HashMap<String, JMenu> categories = new HashMap<String, JMenu>();
        HashSet servset = this.getValidServicesFor(selection, requestor, serMap);
        ArrayList servs = new ArrayList();
        servs.addAll(servset);
        int n = 0;
        while (n < servs.size()) {
            INCService serv = (INCService)servs.get(n);
            JMenu submen = (JMenu)categories.get(serv.getCategory());
            if (submen == null) {
                JMenu finalMen = submen = new JMenu(serv.getCategory());
                submen.setIcon(JServiceMenuItem.GetEmptyIcon());
                categories.put(serv.getCategory(), submen);
            }
            final INCService finalServ = serv;
            JServiceMenuItem js = new JServiceMenuItem(serv, submen);
            submen.add(js);
            js.setIcon(js.im);
            js.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    NCServiceRegistry.this.itemEntered(finalServ);
                }
            });
            ++n;
        }
        String actCat = null;
        Object curr = null;
        JMenu servCat = null;
        boolean prevWasSeparator = true;
        boolean expand = true;
        int n2 = 0;
        while (n2 < cats.length) {
            actCat = cats[n2];
            expand = true;
            if (cats[n2].equals("-")) {
                if (!prevWasSeparator) {
                    jwb.addSeparator();
                    prevWasSeparator = true;
                }
            } else {
                String curCat = cats[n2];
                if (curCat.startsWith("=>")) {
                    curCat = curCat.substring(2);
                    expand = false;
                }
                if ((servCat = (JMenu)categories.get(curCat)) != null) {
                    if (expand) {
                        Component[] subs = servCat.getMenuComponents();
                        int nn = 0;
                        while (subs != null && nn < subs.length) {
                            if (subs[nn] instanceof JServiceMenuItem) {
                                final JServiceMenuItem actServMen = (JServiceMenuItem)subs[nn];
                                actServMen.setMnemonic(0);
                                actServMen.setEnabled(true);
                                Object[] o = (Object[])serMap.get(actServMen.getService());
                                actServMen.setAction(this.createAction(actServMen.getService(), o[0], o[1]));
                                actServMen.recalcMnemonic();
                                jwb.add(actServMen);
                                actServMen.addChangeListener(new ChangeListener(){

                                    public void stateChanged(ChangeEvent e) {
                                        NCServiceRegistry.this.lastSelectedService = actServMen.getService();
                                        NCServiceRegistry.this.itemEntered(actServMen);
                                    }
                                });
                                prevWasSeparator = false;
                            }
                            ++nn;
                        }
                    } else {
                        JMenu sub = new JMenu(curCat);
                        sub.setIcon(JServiceMenuItem.GetEmptyIcon());
                        Component[] subs = servCat.getMenuComponents();
                        int nn = 0;
                        while (subs != null && nn < subs.length) {
                            if (subs[nn] instanceof JServiceMenuItem) {
                                final JServiceMenuItem actServMen = (JServiceMenuItem)subs[nn];
                                actServMen.setMnemonic(0);
                                actServMen.setEnabled(true);
                                Object[] o = (Object[])serMap.get(actServMen.getService());
                                actServMen.setAction(this.createAction(actServMen.getService(), o[0], o[1]));
                                actServMen.setPar(sub);
                                sub.add(actServMen);
                                actServMen.recalcMnemonic();
                                actServMen.addChangeListener(new ChangeListener(){

                                    public void stateChanged(ChangeEvent e) {
                                        NCServiceRegistry.this.lastSelectedService = actServMen.getService();
                                        NCServiceRegistry.this.itemEntered(actServMen);
                                    }
                                });
                                prevWasSeparator = false;
                            }
                            ++nn;
                        }
                        jwb.add(sub);
                    }
                } else {
                    Tracer.This.println("unknown category2:" + cats[n2]);
                }
            }
            ++n2;
        }
        lastOne = jwb;
        return jwb;
    }

    protected abstract void itemEntered(JServiceMenuItem var1);

    protected abstract void itemEntered(INCService var1);

    protected abstract String[] getDefaultPopMenu();

    protected abstract List findSelectionFromObject(Object var1, Object var2);
}

