/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import de.netcomputing.cvswrap.commands.CVSCommand;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class RemoveWrapper
extends CVSCommand {
    Vector msg;

    public RemoveWrapper(String repository) {
        super(repository);
    }

    public Vector getMsg() {
        return this.msg;
    }

    public String runRemove(String dirOrFile, boolean recursive) {
        File tmp = CVSCommand.getTmpFile();
        File f = new File(dirOrFile);
        String cline = CVSCommand.CVS + CVSCommand.REMOVE + "-f " + (recursive ? "-R " : "-l ") + f.getName();
        String wdir = f.getParent();
        int res = this.execute(wdir, cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseRemoveEntries(din, wdir)) {
                return "unexpected command output, aborting";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline;
        }
        return null;
    }

    public boolean parseRemoveEntries(DataInputStream din, String base) {
        try {
            String line = null;
            this.msg = new Vector();
            while ((line = din.readLine()) != null) {
                if (!line.startsWith("cvs remove: ")) {
                    return false;
                }
                this.msg.addElement(line.substring("cvs remove: ".length()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

