/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import de.netcomputing.cvswrap.commands.CVSCommand;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;

public class TagWrapper
extends CVSCommand {
    String msg = null;

    public TagWrapper(String repository) {
        super(repository);
    }

    public String runTag(String module, String tagName, boolean force, boolean createBranch) {
        File tmp = CVSCommand.getTmpFile();
        this.msg = null;
        String cline = CVSCommand.CVS + "-d " + this.repositoryDir + " " + CVSCommand.TAG + (createBranch ? "-b " : "") + (force ? "-F " : "") + tagName + " " + module;
        String wdir = ".";
        int res = this.execute(wdir, cline, tmp.getAbsolutePath());
        try {
            FileInputStream in = new FileInputStream(tmp);
            DataInputStream din = new DataInputStream(in);
            if (!this.parseTagResult(din)) {
                if (this.msg != null) {
                    return this.msg;
                }
                return "There were errors. Please check the CVS-log in the Output Window";
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error reading command output of " + cline;
        }
        return null;
    }

    public boolean parseTagResult(DataInputStream din) {
        try {
            String line = null;
            while ((line = din.readLine()) != null) {
                if (line.startsWith("W ")) {
                    return false;
                }
                if (line.indexOf("[rtag aborted]:") < 0) continue;
                this.msg = line;
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

