/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.gui;

import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.cvswrap.commands.CVSCommand;
import de.netcomputing.cvswrap.commands.CreateWrapper;
import de.netcomputing.cvswrap.gui.CVSConfigGUI;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netcomputing.tools.Platforms;
import netcomputing.tools.PropWriter;

public class CVSConfig
extends NCPanel {
    static CVSConfig This;
    NCTextField cvsRoot;
    NCTextField logTxt;
    NCTextField commitTxt;
    NCTextField addTxt;
    NCTextField checkoutTxt;
    NCTextField updateTxt;
    NCTextField removeTxt;
    NCTextField statusTxt;
    NCTextField diffTxt;
    NCTextField cvsTxt;
    NCTextField importTxt;
    NCTextField historyTxt;
    NCButton defaultBtn;
    NCButton cancelBtn;
    NCButton applyBtn;
    JTextField[] txt;

    public static CVSConfig This() {
        return This;
    }

    public CVSConfig() {
        This = this;
        this.initGui();
    }

    public void initGui() {
        new CVSConfigGUI().createGui(this);
        this.applyBtn.setMnemonic('O');
        this.cancelBtn.setMnemonic('C');
        DocumentListener enableButtons = new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                CVSConfig.this.enableApplyButtons(true);
            }

            public void insertUpdate(DocumentEvent e) {
                CVSConfig.this.enableApplyButtons(true);
            }

            public void changedUpdate(DocumentEvent e) {
                CVSConfig.this.enableApplyButtons(true);
            }
        };
        this.txt = new JTextField[]{this.historyTxt, this.importTxt, this.cvsTxt, this.diffTxt, this.statusTxt, this.statusTxt, this.removeTxt, this.updateTxt, this.checkoutTxt, this.addTxt, this.commitTxt, this.logTxt, this.cvsRoot};
        int n = 0;
        while (n < this.txt.length) {
            this.txt[n].getDocument().addDocumentListener(enableButtons);
            ++n;
        }
    }

    public void initRepository() {
        File dirF = AJDirSelector.SelectDirModal(EditApp.App.getMainWindow(), null, "Choose the repository's directory", null, null);
        if (dirF == null) {
            return;
        }
        CreateWrapper cw = new CreateWrapper(null);
        String res = cw.runInit(":local:" + dirF.getAbsolutePath());
        if (res != null) {
            Confirm.ModalMsg("Error During CVS init", res);
            return;
        }
        this.cvsRoot.setText(":local:" + dirF.getAbsolutePath());
        this.applyBtn_actionPerformed(null);
        if (EditApp.App != null) {
            EditApp.App.updateDirTree();
        }
    }

    public String getCVSRoot() {
        String s = this.cvsRoot.getText().trim();
        if (s.startsWith(File.separator) || s.length() > 3 && s.charAt(1) == ':' && s.charAt(2) == '\\') {
            this.cvsRoot.setText(":local:" + s);
            this.applyBtn_actionPerformed(null);
        }
        return this.cvsRoot.getText().trim();
    }

    void enableApplyButtons(boolean b) {
        this.applyBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            this.loadProperty(pw.getStream("CVSOptions"));
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.ok();
    }

    void storeProperty(DataOutputStream dos) throws Exception {
        dos.writeUTF(this.cvsRoot.getText());
        dos.writeUTF(CVSCommand.CVS);
        dos.writeUTF(CVSCommand.ADD);
        dos.writeUTF(CVSCommand.UPDATE);
        dos.writeUTF(CVSCommand.REMOVE);
        dos.writeUTF(CVSCommand.COMMIT);
        dos.writeUTF(CVSCommand.CHECKOUT);
        dos.writeUTF(CVSCommand.HISTORY);
        dos.writeUTF(CVSCommand.IMPORT);
        dos.writeUTF(CVSCommand.DIFF);
        dos.writeUTF(CVSCommand.STATUS);
        dos.writeUTF(CVSCommand.LOG);
    }

    void loadProperty(DataInputStream dis) throws Exception {
        this.setDefault();
        this.cvsRoot.setText(dis.readUTF());
        CVSCommand.CVS = dis.readUTF();
        CVSCommand.ADD = dis.readUTF();
        CVSCommand.UPDATE = dis.readUTF();
        CVSCommand.REMOVE = dis.readUTF();
        CVSCommand.COMMIT = dis.readUTF();
        CVSCommand.CHECKOUT = dis.readUTF();
        CVSCommand.HISTORY = dis.readUTF();
        CVSCommand.IMPORT = dis.readUTF();
        CVSCommand.DIFF = dis.readUTF();
        CVSCommand.STATUS = dis.readUTF();
        CVSCommand.LOG = dis.readUTF();
        this.copyCVSStringsToGUI();
    }

    public void storeProperty(PropWriter pw) throws Exception {
        this.storeProperty(pw.createStream("CVSOptions"));
    }

    String checkBlank(String s) {
        if (!s.endsWith(" ")) {
            return s.trim() + " ";
        }
        return s;
    }

    void copyCVSStringsFromGUI() {
        CVSCommand.CVS = this.checkBlank(this.cvsTxt.getText());
        CVSCommand.ADD = this.checkBlank(this.addTxt.getText());
        CVSCommand.UPDATE = this.checkBlank(this.updateTxt.getText());
        CVSCommand.REMOVE = this.checkBlank(this.removeTxt.getText());
        CVSCommand.COMMIT = this.checkBlank(this.commitTxt.getText());
        CVSCommand.CHECKOUT = this.checkBlank(this.checkoutTxt.getText());
        CVSCommand.HISTORY = this.checkBlank(this.historyTxt.getText());
        CVSCommand.IMPORT = this.checkBlank(this.importTxt.getText());
        CVSCommand.DIFF = this.checkBlank(this.diffTxt.getText());
        CVSCommand.STATUS = this.checkBlank(this.statusTxt.getText());
        CVSCommand.LOG = this.checkBlank(this.logTxt.getText());
    }

    void copyCVSStringsToGUI() {
        this.cvsTxt.setText(CVSCommand.CVS.trim());
        this.addTxt.setText(CVSCommand.ADD.trim());
        this.updateTxt.setText(CVSCommand.UPDATE.trim());
        this.removeTxt.setText(CVSCommand.REMOVE.trim());
        this.commitTxt.setText(CVSCommand.COMMIT.trim());
        this.checkoutTxt.setText(CVSCommand.CHECKOUT.trim());
        this.historyTxt.setText(CVSCommand.HISTORY.trim());
        this.importTxt.setText(CVSCommand.IMPORT.trim());
        this.diffTxt.setText(CVSCommand.DIFF.trim());
        this.statusTxt.setText(CVSCommand.STATUS.trim());
        this.logTxt.setText(CVSCommand.LOG.trim());
    }

    void ok() {
        try {
            this.storeProperty(EditApp.App.getLocalWriter().copyAbsolute("tmp").createStream("cvsopt_tmp"));
            this.enableApplyButtons(false);
            this.copyCVSStringsFromGUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setDefault() {
        CVSCommand.CVS = Platforms.IsWindows() ? "($anyjbase)/bin/cvs " : "cvs ";
        CVSCommand.ADD = "add ";
        CVSCommand.UPDATE = "update ";
        CVSCommand.REMOVE = "remove ";
        CVSCommand.COMMIT = "commit ";
        CVSCommand.CHECKOUT = "checkout ";
        CVSCommand.HISTORY = "history ";
        CVSCommand.IMPORT = "import ";
        CVSCommand.DIFF = "diff ";
        CVSCommand.STATUS = "status ";
        CVSCommand.LOG = "log ";
        this.copyCVSStringsToGUI();
    }

    void cancel() {
        try {
            this.loadProperty(EditApp.App.getLocalWriter().copyAbsolute("tmp").getStream("cvsopt_tmp"));
            this.enableApplyButtons(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void defaultBtn_actionPerformed(ActionEvent var0) {
        this.setDefault();
        this.ok();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.cancel();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        this.ok();
    }
}

